/*
 * Decompiled with CFR 0.152.
 */
package org.oryxel.gfp.packets.server;

import java.util.ArrayList;
import java.util.Optional;
import org.cloudburstmc.math.vector.Vector3d;
import org.cloudburstmc.math.vector.Vector3i;
import org.geysermc.mcprotocollib.network.packet.Packet;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.EntityMetadata;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.MetadataTypes;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.type.ObjectEntityMetadata;
import org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.entity.ClientboundAddEntityPacket;
import org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.entity.ClientboundEntityPositionSyncPacket;
import org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.entity.ClientboundMoveEntityPosPacket;
import org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.entity.ClientboundMoveEntityPosRotPacket;
import org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.entity.ClientboundMoveVehiclePacket;
import org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.entity.ClientboundRemoveEntitiesPacket;
import org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.entity.ClientboundSetEntityDataPacket;
import org.oryxel.gfp.protocol.event.MCPLPacketEvent;
import org.oryxel.gfp.protocol.listener.JavaPacketListener;
import org.oryxel.gfp.session.CachedSession;

public class ServerEntityPackets
implements JavaPacketListener {
    @Override
    public void packetReceived(MCPLPacketEvent event) {
        ClientboundAddEntityPacket packet;
        CachedSession session = event.getSession();
        Object object = event.getPacket();
        if (object instanceof ClientboundAddEntityPacket) {
            packet = (ClientboundAddEntityPacket)object;
            session.getEntityCache().cacheEntity(packet.getEntityId(), Vector3d.from((double)packet.getX(), (double)packet.getY(), (double)packet.getZ()));
            event.setPacket((Packet)new ClientboundAddEntityPacket(packet.getEntityId(), packet.getUuid(), packet.getType(), packet.getData(), packet.getX() - (double)session.getOffset().getX(), packet.getY(), packet.getZ() - (double)session.getOffset().getZ(), packet.getMovement(), packet.getYaw(), packet.getHeadYaw(), packet.getPitch()));
        }
        if ((object = event.getPacket()) instanceof ClientboundRemoveEntitiesPacket) {
            packet = (ClientboundRemoveEntitiesPacket)object;
            object = packet.getEntityIds();
            int n = ((Packet)object).length;
            for (int i = 0; i < n; ++i) {
                Packet id = object[i];
                session.getEntityCache().remove((int)id);
            }
        }
        if ((object = event.getPacket()) instanceof ClientboundSetEntityDataPacket) {
            packet = (ClientboundSetEntityDataPacket)object;
            ArrayList<Object> list = new ArrayList<Object>();
            for (EntityMetadata meta : packet.getMetadata()) {
                Object inner;
                Optional opt;
                Object value;
                if (meta.getId() == 14 && meta.getType() == MetadataTypes.OPTIONAL_BLOCK_POS && (value = meta.getValue()) instanceof Optional && (opt = (Optional)value).isPresent() && (inner = opt.get()) instanceof Vector3i) {
                    Vector3i pos = (Vector3i)inner;
                    list.add(new ObjectEntityMetadata(meta.getId(), MetadataTypes.OPTIONAL_BLOCK_POS, Optional.of(pos.sub(session.getOffset()))));
                    continue;
                }
                list.add(meta);
            }
            event.setPacket((Packet)new ClientboundSetEntityDataPacket(packet.getEntityId(), (EntityMetadata[])list.toArray(EntityMetadata[]::new)));
        }
        if ((object = event.getPacket()) instanceof ClientboundEntityPositionSyncPacket) {
            packet = (ClientboundEntityPositionSyncPacket)object;
            session.getEntityCache().moveAbsolute(packet.getId(), packet.getPosition());
            event.setPacket((Packet)new ClientboundEntityPositionSyncPacket(packet.getId(), packet.getPosition().sub(session.getOffset().toDouble()), packet.getDeltaMovement(), packet.getYRot(), packet.getXRot(), packet.isOnGround()));
        }
        if ((object = event.getPacket()) instanceof ClientboundMoveEntityPosRotPacket) {
            packet = (ClientboundMoveEntityPosRotPacket)object;
            session.getEntityCache().moveRelative(packet.getEntityId(), Vector3d.from((double)packet.getMoveX(), (double)packet.getMoveY(), (double)packet.getMoveZ()));
        }
        if ((object = event.getPacket()) instanceof ClientboundMoveEntityPosPacket) {
            packet = (ClientboundMoveEntityPosPacket)object;
            session.getEntityCache().moveRelative(packet.getEntityId(), Vector3d.from((double)packet.getMoveX(), (double)packet.getMoveY(), (double)packet.getMoveZ()));
        }
        if ((object = event.getPacket()) instanceof ClientboundMoveVehiclePacket) {
            packet = (ClientboundMoveVehiclePacket)object;
            event.setPacket((Packet)new ClientboundMoveVehiclePacket(packet.getPosition().sub(session.getOffset().toDouble()), packet.getYRot(), packet.getXRot()));
        }
    }
}

