/*
 * Decompiled with CFR 0.152.
 */
package org.oryxel.gfp.session;

import lombok.Generated;
import org.cloudburstmc.math.vector.Vector3f;
import org.cloudburstmc.math.vector.Vector3i;
import org.cloudburstmc.protocol.bedrock.BedrockServerSession;
import org.cloudburstmc.protocol.bedrock.packet.BedrockPacket;
import org.cloudburstmc.protocol.bedrock.packet.SetSpawnPositionPacket;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.util.DimensionUtils;
import org.geysermc.mcprotocollib.network.ClientSession;
import org.oryxel.gfp.cache.ChunkCache;
import org.oryxel.gfp.cache.EntityCache;
import org.oryxel.gfp.geyser.util.GeyserUtil;
import org.oryxel.gfp.protocol.mitm.CloudburstReceiveListener;
import org.oryxel.gfp.protocol.mitm.CloudburstSendListener;

public class CachedSession {
    private final GeyserSession session;
    public ClientSession mcplSession;
    public BedrockServerSession cloudburstDownstream;
    public CloudburstSendListener cloudburstUpstream;
    public CloudburstReceiveListener downstreamPacketHandler;
    public long runtimeId = -1L;
    private Vector3i offset = Vector3i.from((int)0, (int)0, (int)0);
    public Vector3i lastRealPosInt = Vector3i.ZERO;
    public Vector3f rotation = Vector3f.ZERO;
    public Vector3f cachedVelocity = Vector3f.ZERO;
    public boolean silentDimensionSwitch = false;
    private final ChunkCache chunkCache = new ChunkCache(this);
    private final EntityCache entityCache = new EntityCache(this);
    public Vector3i worldSpawn = null;

    public CachedSession(GeyserSession session) {
        this.session = session;
        GeyserUtil.hookIntoCloudburstMC(this);
    }

    public void kick(String reason) {
        this.session.disconnect(reason);
    }

    public void reOffsetPlayer(double x, double z, Vector3i newOffset) {
        float posX = Float.parseFloat(Double.toString(x));
        float posZ = Float.parseFloat(Double.toString(z));
        this.session.getPlayerEntity().setPositionManual(Vector3f.from((float)posX, (float)this.getSession().getPlayerEntity().getPosition().getY(), (float)posZ));
        this.offset = newOffset;
        this.chunkCache.sendChunksWithOffset();
        this.entityCache.resendWithOffset();
        this.sendWorldSpawn();
    }

    public void sendWorldSpawn() {
        if (this.worldSpawn == null) {
            return;
        }
        SetSpawnPositionPacket spawnPositionPacket = new SetSpawnPositionPacket();
        spawnPositionPacket.setBlockPosition(this.worldSpawn.sub(this.offset));
        spawnPositionPacket.setDimensionId(DimensionUtils.javaToBedrock((GeyserSession)this.session));
        spawnPositionPacket.setSpawnType(SetSpawnPositionPacket.Type.WORLD_SPAWN);
        this.session.sendUpstreamPacket((BedrockPacket)spawnPositionPacket);
    }

    @Generated
    public GeyserSession getSession() {
        return this.session;
    }

    @Generated
    public Vector3i getOffset() {
        return this.offset;
    }

    @Generated
    public void setOffset(Vector3i offset) {
        this.offset = offset;
    }

    @Generated
    public ChunkCache getChunkCache() {
        return this.chunkCache;
    }

    @Generated
    public EntityCache getEntityCache() {
        return this.entityCache;
    }
}

