/*
 * Decompiled with CFR 0.152.
 */
package dev.microcontrollers.simpleblockoverlay.util;

import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTextureView;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.function.Consumer;
import net.minecraft.class_11219;
import net.minecraft.class_276;
import net.minecraft.class_310;
import net.minecraft.class_9801;

public class BufferUploader {
    public static void drawWithPipeline(RenderPipeline renderPipeline, GpuBufferSlice dynamicTransforms, class_9801 meshData, Consumer<RenderPass> renderPassConsumer) {
        GpuTextureView colorTextureView;
        VertexFormat.class_5595 indexType;
        GpuBuffer indexBuffer;
        GpuBuffer vertexBuffer = renderPipeline.getVertexFormat().uploadImmediateVertexBuffer(meshData.method_60818());
        if (meshData.method_60821() == null) {
            RenderSystem.class_5590 autoStorageIndexBuffer = RenderSystem.getSequentialBuffer((VertexFormat.class_5596)meshData.method_60822().comp_752());
            indexBuffer = autoStorageIndexBuffer.method_68274(meshData.method_60822().comp_751());
            indexType = autoStorageIndexBuffer.method_31924();
        } else {
            indexBuffer = renderPipeline.getVertexFormat().uploadImmediateIndexBuffer(meshData.method_60821());
            indexType = meshData.method_60822().comp_753();
        }
        class_276 renderTarget = class_310.method_1551().method_1522();
        GpuTextureView gpuTextureView = colorTextureView = RenderSystem.outputColorTextureOverride != null ? RenderSystem.outputColorTextureOverride : renderTarget.method_71639();
        GpuTextureView depthTextureView = renderTarget.field_1478 ? (RenderSystem.outputDepthTextureOverride != null ? RenderSystem.outputDepthTextureOverride : renderTarget.method_71640()) : null;
        try (RenderPass renderPass = RenderSystem.getDevice().createCommandEncoder().createRenderPass(() -> "Immediate Rendering For" + String.valueOf(renderPipeline), colorTextureView, OptionalInt.empty(), depthTextureView, OptionalDouble.empty());){
            renderPassConsumer.accept(renderPass);
            renderPass.setPipeline(renderPipeline);
            class_11219 scissorState = RenderSystem.getScissorStateForRenderTypeDraws();
            if (scissorState.method_72091()) {
                renderPass.enableScissor(scissorState.method_72092(), scissorState.method_72093(), scissorState.method_72094(), scissorState.method_72095());
            }
            RenderSystem.bindDefaultUniforms((RenderPass)renderPass);
            renderPass.setUniform("DynamicTransforms", dynamicTransforms);
            renderPass.setVertexBuffer(0, vertexBuffer);
            for (int i = 0; i < 12; ++i) {
                GpuTextureView shaderTexture = RenderSystem.getShaderTexture((int)i);
                if (shaderTexture == null) continue;
                renderPass.bindSampler("Sampler" + i, shaderTexture);
            }
            renderPass.setIndexBuffer(indexBuffer, indexType);
            renderPass.drawIndexed(0, 0, meshData.method_60822().comp_751(), 1);
        }
        meshData.close();
    }

    public static void drawWithPipeline(RenderPipeline renderPipeline, GpuBufferSlice dynamicTransforms, class_9801 meshData) {
        BufferUploader.drawWithPipeline(renderPipeline, dynamicTransforms, meshData, renderPass -> {});
    }
}

