/*
 * Decompiled with CFR 0.152.
 */
package dev.microcontrollers.simpleblockoverlay.util;

import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.platform.DepthTestFunction;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.VertexFormat;
import dev.microcontrollers.simpleblockoverlay.SimpleBlockOverlay;
import dev.microcontrollers.simpleblockoverlay.config.SimpleBlockOverlayConfig;
import dev.microcontrollers.simpleblockoverlay.util.BufferUploader;
import dev.microcontrollers.simpleblockoverlay.util.ColorUtil;
import dev.microcontrollers.simpleblockoverlay.util.DynamicTransformsBuilder;
import java.awt.Color;
import net.minecraft.class_10799;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_287;
import net.minecraft.class_290;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_638;
import net.minecraft.class_9799;
import net.minecraft.class_9974;

public class RenderUtil {
    private static final double Z_FIGHTING_OFFSET = 0.001;
    public static final RenderPipeline LINES_THROUGH_WALLS = class_10799.method_67887((RenderPipeline)RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{class_10799.field_56859}).withLocation(SimpleBlockOverlay.id("pipeline/texture_through_walls_sbo")).withDepthTestFunction(DepthTestFunction.NO_DEPTH_TEST).build());
    public static final RenderPipeline FILLED_THROUGH_WALLS = class_10799.method_67887((RenderPipeline)RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{class_10799.field_56860}).withLocation(SimpleBlockOverlay.id("pipeline/debug_filled_box_through_walls")).withVertexFormat(class_290.field_1576, VertexFormat.class_5596.field_27380).withDepthTestFunction(DepthTestFunction.NO_DEPTH_TEST).build());

    public static void renderOverlayBox(class_4587 poseStack) {
        class_310 minecraft = class_310.method_1551();
        class_239 hitResult = class_310.method_1551().field_1765;
        if (hitResult == null || hitResult.method_17783() != class_239.class_240.field_1332) {
            return;
        }
        class_638 level = minecraft.field_1687;
        class_2338 pos = ((class_3965)hitResult).method_17777();
        assert (level != null);
        class_2680 state = level.method_8320(pos);
        class_243 camera = minecraft.field_1773.method_19418().method_19326();
        Color color = ColorUtil.getOverlayColor();
        assert (poseStack != null);
        poseStack.method_22903();
        poseStack.method_22904((double)pos.method_10263() - camera.field_1352, (double)pos.method_10264() - camera.field_1351, (double)pos.method_10260() - camera.field_1350);
        RenderPipeline pipeline = ((SimpleBlockOverlayConfig)SimpleBlockOverlayConfig.CONFIG.instance()).disableDepth ? FILLED_THROUGH_WALLS : class_10799.field_56837;
        class_9799 byteBufferBuilder = new class_9799(pipeline.getVertexFormat().getVertexSize() * 30);
        class_287 builder = new class_287(byteBufferBuilder, pipeline.getVertexFormatMode(), pipeline.getVertexFormat());
        state.method_26218((class_1922)level, pos).method_1089((minX, minY, minZ, maxX, maxY, maxZ) -> class_9974.method_62300((class_4587)poseStack, (class_4588)builder, (double)(minX - 0.001), (double)(minY - 0.001), (double)(minZ - 0.001), (double)(maxX + 0.001), (double)(maxY + 0.001), (double)(maxZ + 0.001), (float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f), (float)((float)color.getAlpha() / 255.0f)));
        BufferUploader.drawWithPipeline(pipeline, DynamicTransformsBuilder.of().build(), builder.method_60794());
        poseStack.method_22909();
    }

    public static void renderOutline(class_4587 poseStack) {
        class_239 hitResult = class_310.method_1551().field_1765;
        class_310 minecraft = class_310.method_1551();
        if (hitResult == null || hitResult.method_17783() != class_239.class_240.field_1332) {
            return;
        }
        class_638 level = minecraft.field_1687;
        class_2338 pos = ((class_3965)hitResult).method_17777();
        assert (level != null);
        class_2680 state = level.method_8320(pos);
        class_243 camera = minecraft.field_1773.method_19418().method_19326();
        Color color = ColorUtil.getOutlineColor();
        float[] colorComponents = new float[]{(float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, (float)color.getAlpha() / 255.0f};
        assert (poseStack != null);
        poseStack.method_22903();
        poseStack.method_22904((double)pos.method_10263() - camera.field_1352, (double)pos.method_10264() - camera.field_1351, (double)pos.method_10260() - camera.field_1350);
        state.method_26218((class_1922)level, pos).method_1089((minX, minY, minZ, maxX, maxY, maxZ) -> RenderUtil.renderOutlineHelper(poseStack, new class_238(minX - camera.field_1352 - 0.001, minY - camera.field_1351 - 0.001, minZ - camera.field_1350 - 0.001, maxX - camera.field_1352 + 0.001, maxY - camera.field_1351 + 0.001, maxZ - camera.field_1350 + 0.001).method_997(camera), colorComponents, ((SimpleBlockOverlayConfig)SimpleBlockOverlayConfig.CONFIG.instance()).lineWidth, ((SimpleBlockOverlayConfig)SimpleBlockOverlayConfig.CONFIG.instance()).disableDepth));
        poseStack.method_22909();
    }

    public static void renderOutlineHelper(class_4587 poseStack, class_238 aabb, float[] colorComponents, float lineWidth, boolean throughWalls) {
        RenderPipeline pipeline = throughWalls ? LINES_THROUGH_WALLS : class_10799.field_56833;
        class_9799 byteBufferBuilder = new class_9799(pipeline.getVertexFormat().getVertexSize() * 24);
        class_287 builder = new class_287(byteBufferBuilder, pipeline.getVertexFormatMode(), pipeline.getVertexFormat());
        class_9974.method_62295((class_4587.class_4665)poseStack.method_23760(), (class_4588)builder, (class_238)aabb, (float)colorComponents[0], (float)colorComponents[1], (float)colorComponents[2], (float)colorComponents[3]);
        RenderSystem.lineWidth((float)lineWidth);
        BufferUploader.drawWithPipeline(pipeline, DynamicTransformsBuilder.of().withLineWidth(lineWidth).build(), builder.method_60800());
    }
}

