/*
 * Decompiled with CFR 0.152.
 */
package quantum.cleanview.mixin;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.border.WorldBorder;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import quantum.cleanview.Config;

@Mixin(value={Gui.class})
public class GuiMixin {
    @Shadow
    @Final
    private Minecraft minecraft;
    @Shadow
    public float vignetteBrightness = 1.0f;
    @Shadow
    @Final
    private static ResourceLocation VIGNETTE_LOCATION;

    @Inject(method={"Lnet/minecraft/client/gui/Gui;renderVignette(Lnet/minecraft/client/gui/GuiGraphics;Lnet/minecraft/world/entity/Entity;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void cleanView(GuiGraphics p_283063_, Entity p_283439_, CallbackInfo ci) {
        if (!Config.CleanViewValue) {
            return;
        }
        if (!Config.BoarderVignetteValue) {
            ci.cancel();
            return;
        }
        WorldBorder worldborder = this.minecraft.level.getWorldBorder();
        float f = 0.0f;
        if (p_283439_ != null) {
            float f1 = (float)worldborder.getDistanceToBorder(p_283439_);
            double d0 = Math.min(worldborder.getLerpSpeed() * (double)worldborder.getWarningTime() * 1000.0, Math.abs(worldborder.getLerpTarget() - worldborder.getSize()));
            double d1 = Math.max((double)worldborder.getWarningBlocks(), d0);
            if ((double)f1 < d1) {
                f = 1.0f - (float)((double)f1 / d1);
            }
        }
        if (f > 0.0f) {
            f = Mth.clamp((float)f, (float)0.0f, (float)1.0f);
            int i = ARGB.colorFromFloat((float)1.0f, (float)0.0f, (float)f, (float)f);
            p_283063_.blit(RenderPipelines.VIGNETTE, VIGNETTE_LOCATION, 0, 0, 0.0f, 0.0f, p_283063_.guiWidth(), p_283063_.guiHeight(), p_283063_.guiWidth(), p_283063_.guiHeight(), i);
        }
        ci.cancel();
    }
}

