/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.manure.forge.events;

import com.natamus.collective_common_forge.functions.WorldFunctions;
import com.natamus.manure_common_forge.events.ManureDropEvent;
import com.natamus.manure_common_forge.util.Util;
import java.lang.invoke.MethodHandles;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.EntityLeaveLevelEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.bus.BusGroup;
import net.minecraftforge.eventbus.api.listener.SubscribeEvent;

public class ForgeManureDropEvent {
    public static void registerEventsInBus() {
        BusGroup.DEFAULT.register(MethodHandles.lookup(), ForgeManureDropEvent.class);
    }

    @SubscribeEvent
    public static void onWorldLoad(LevelEvent.Load e) {
        Level level = WorldFunctions.getWorldIfInstanceOfAndNotRemote((LevelAccessor)e.getLevel());
        if (level == null) {
            return;
        }
        Util.attemptBlacklistProcessing(level);
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent.Post e) {
        ManureDropEvent.onServerTick(e.server());
    }

    @SubscribeEvent
    public static void onEntityJoin(EntityJoinLevelEvent e) {
        Level level = e.getLevel();
        if (level.isClientSide()) {
            return;
        }
        ManureDropEvent.onEntityJoin(e.getEntity(), (ServerLevel)level);
    }

    @SubscribeEvent
    public static void onEntityLeave(EntityLeaveLevelEvent e) {
        Level level = e.getLevel();
        if (level.isClientSide()) {
            return;
        }
        ManureDropEvent.onEntityLeave(e.getEntity(), (ServerLevel)level);
    }
}

