/*
 * Decompiled with CFR 0.152.
 */
package com.typewritermc.basic.entries.audience;

import com.typewritermc.core.entries.Ref;
import com.typewritermc.engine.paper.entry.entries.AudienceFilter;
import com.typewritermc.engine.paper.entry.entries.AudienceFilterEntry;
import com.typewritermc.engine.paper.entry.temporal.TemporalInteractionKt;
import com.typewritermc.engine.paper.events.AsyncCinematicEndEvent;
import com.typewritermc.engine.paper.events.AsyncCinematicStartEvent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0012H\u0007R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/typewritermc/basic/entries/audience/CinematicAudienceFilter;", "Lcom/typewritermc/engine/paper/entry/entries/AudienceFilter;", "ref", "Lcom/typewritermc/core/entries/Ref;", "Lcom/typewritermc/engine/paper/entry/entries/AudienceFilterEntry;", "pageId", "", "<init>", "(Lcom/typewritermc/core/entries/Ref;Ljava/lang/String;)V", "filter", "", "player", "Lorg/bukkit/entity/Player;", "onCinematicStart", "", "event", "Lcom/typewritermc/engine/paper/events/AsyncCinematicStartEvent;", "onCinematicEnd", "Lcom/typewritermc/engine/paper/events/AsyncCinematicEndEvent;", "BasicExtension"})
public final class CinematicAudienceFilter
extends AudienceFilter {
    @NotNull
    private final String pageId;

    public CinematicAudienceFilter(@NotNull Ref<? extends AudienceFilterEntry> ref, @NotNull String pageId) {
        Intrinsics.checkNotNullParameter(ref, (String)"ref");
        Intrinsics.checkNotNullParameter((Object)pageId, (String)"pageId");
        super(ref);
        this.pageId = pageId;
    }

    public boolean filter(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        boolean inCinematic = !StringsKt.isBlank((CharSequence)this.pageId) ? TemporalInteractionKt.isPlayingTemporal((Player)player, (String)this.pageId) : TemporalInteractionKt.isPlayingTemporal((Player)player);
        return inCinematic;
    }

    @EventHandler
    public final void onCinematicStart(@NotNull AsyncCinematicStartEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!StringsKt.isBlank((CharSequence)this.pageId) && !Intrinsics.areEqual((Object)event.getPageId(), (Object)this.pageId)) {
            return;
        }
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue((Object)player, (String)"getPlayer(...)");
        this.updateFilter(player, true);
    }

    @EventHandler
    public final void onCinematicEnd(@NotNull AsyncCinematicEndEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!StringsKt.isBlank((CharSequence)this.pageId) && !Intrinsics.areEqual((Object)event.getPageId(), (Object)this.pageId)) {
            return;
        }
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue((Object)player, (String)"getPlayer(...)");
        this.updateFilter(player, false);
    }
}

