/*
 * Decompiled with CFR 0.152.
 */
package com.typewritermc.basic.entries.audience;

import com.typewritermc.basic.entries.audience.TriggerAudienceDisplay;
import com.typewritermc.core.entries.Ref;
import com.typewritermc.core.extension.annotations.Entry;
import com.typewritermc.core.extension.annotations.Help;
import com.typewritermc.engine.paper.entry.PlaceholderParser;
import com.typewritermc.engine.paper.entry.TriggerableEntry;
import com.typewritermc.engine.paper.entry.entries.AudienceDisplay;
import com.typewritermc.engine.paper.entry.entries.AudienceEntry;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Entry(name="trigger_audience", description="Triggers a sequence when the player enters or exits the audience", color="#4CAF50", icon="mdi:account-arrow-right")
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B;\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u000e\u0010\u0014\u001a\u00020\u0015H\u0096@\u00a2\u0006\u0002\u0010\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\"\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u000e\u0010\u000f\u001a\u0004\b\u0010\u0010\u0011R\"\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0012\u0010\u000f\u001a\u0004\b\u0013\u0010\u0011\u00a8\u0006\u0017"}, d2={"Lcom/typewritermc/basic/entries/audience/TriggerAudienceEntry;", "Lcom/typewritermc/engine/paper/entry/entries/AudienceEntry;", "id", "", "name", "onEnter", "Lcom/typewritermc/core/entries/Ref;", "Lcom/typewritermc/engine/paper/entry/TriggerableEntry;", "onExit", "<init>", "(Ljava/lang/String;Ljava/lang/String;Lcom/typewritermc/core/entries/Ref;Lcom/typewritermc/core/entries/Ref;)V", "getId", "()Ljava/lang/String;", "getName", "getOnEnter$annotations", "()V", "getOnEnter", "()Lcom/typewritermc/core/entries/Ref;", "getOnExit$annotations", "getOnExit", "display", "Lcom/typewritermc/engine/paper/entry/entries/AudienceDisplay;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "BasicExtension"})
@SourceDebugExtension(value={"SMAP\nTriggerAudienceEntry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TriggerAudienceEntry.kt\ncom/typewritermc/basic/entries/audience/TriggerAudienceEntry\n+ 2 EntryReference.kt\ncom/typewritermc/core/entries/EntryReferenceKt\n*L\n1#1,49:1\n6#2:50\n6#2:51\n*S KotlinDebug\n*F\n+ 1 TriggerAudienceEntry.kt\ncom/typewritermc/basic/entries/audience/TriggerAudienceEntry\n*L\n31#1:50\n33#1:51\n*E\n"})
public final class TriggerAudienceEntry
implements AudienceEntry {
    @NotNull
    private final String id;
    @NotNull
    private final String name;
    @NotNull
    private final Ref<TriggerableEntry> onEnter;
    @NotNull
    private final Ref<TriggerableEntry> onExit;

    public TriggerAudienceEntry(@NotNull String id, @NotNull String name, @NotNull Ref<TriggerableEntry> onEnter, @NotNull Ref<TriggerableEntry> onExit) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(onEnter, (String)"onEnter");
        Intrinsics.checkNotNullParameter(onExit, (String)"onExit");
        this.id = id;
        this.name = name;
        this.onEnter = onEnter;
        this.onExit = onExit;
    }

    public /* synthetic */ TriggerAudienceEntry(String string, String string2, Ref ref, Ref ref2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        boolean $i$f$emptyRef;
        if ((n & 1) != 0) {
            string = "";
        }
        if ((n & 2) != 0) {
            string2 = "";
        }
        if ((n & 4) != 0) {
            $i$f$emptyRef = false;
            ref = new Ref("", Reflection.getOrCreateKotlinClass(TriggerableEntry.class), null, 4, null);
        }
        if ((n & 8) != 0) {
            $i$f$emptyRef = false;
            ref2 = new Ref("", Reflection.getOrCreateKotlinClass(TriggerableEntry.class), null, 4, null);
        }
        this(string, string2, (Ref<TriggerableEntry>)ref, (Ref<TriggerableEntry>)ref2);
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public final Ref<TriggerableEntry> getOnEnter() {
        return this.onEnter;
    }

    @Help(text="The sequence to trigger when the player enters the audience.")
    public static /* synthetic */ void getOnEnter$annotations() {
    }

    @NotNull
    public final Ref<TriggerableEntry> getOnExit() {
        return this.onExit;
    }

    @Help(text="The sequence to trigger when the player exits the audience.")
    public static /* synthetic */ void getOnExit$annotations() {
    }

    @Nullable
    public Object display(@NotNull Continuation<? super AudienceDisplay> $completion) {
        return new TriggerAudienceDisplay(this.onEnter, this.onExit);
    }

    @NotNull
    public PlaceholderParser parser() {
        return super.parser();
    }

    public TriggerAudienceEntry() {
        this(null, null, null, null, 15, null);
    }
}

