/*
 * Decompiled with CFR 0.152.
 */
package com.typewritermc.basic.entries.dialogue.messengers.input;

import com.typewritermc.basic.entries.dialogue.InputDialogueEntry;
import com.typewritermc.basic.entries.dialogue.messengers.input.JavaInputDialogueDialogueMessengerKt;
import com.typewritermc.core.entries.Entry;
import com.typewritermc.core.interaction.EntryContextKey;
import com.typewritermc.core.interaction.InteractionContext;
import com.typewritermc.engine.paper.entry.dialogue.DialogueMessenger;
import com.typewritermc.engine.paper.entry.dialogue.MessengerState;
import com.typewritermc.engine.paper.entry.dialogue.TickContext;
import com.typewritermc.engine.paper.entry.dialogue.TypeDurationKt;
import com.typewritermc.engine.paper.entry.entries.DialogueEntry;
import com.typewritermc.engine.paper.entry.entries.EventTrigger;
import com.typewritermc.engine.paper.entry.entries.Var;
import com.typewritermc.engine.paper.extensions.placeholderapi.PlaceholderExpansionKt;
import com.typewritermc.engine.paper.interaction.ChatHistory;
import com.typewritermc.engine.paper.interaction.ChatHistoryHandlerKt;
import com.typewritermc.engine.paper.utils.ExtensionsKt;
import com.typewritermc.engine.paper.utils.MiniMessagesKt;
import io.papermc.paper.event.player.AsyncChatEvent;
import java.time.Duration;
import java.util.List;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00022\b\u0012\u0004\u0012\u00020\u00050\u0004Bq\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u0005\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0018\u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00100\u000e\u0012\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u000e\u0012\u001a\u0010\u0012\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00018\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u00130\u000e\u00a2\u0006\u0004\b\u0015\u0010\u0016J\b\u0010*\u001a\u00020+H\u0016J\u0010\u0010,\u001a\u00020+2\u0006\u0010-\u001a\u00020.H\u0003J\u0010\u00103\u001a\u00020+2\u0006\u0010\b\u001a\u000204H\u0016J\f\u00105\u001a\u00020+*\u00020\u0007H\u0002R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00100\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0012\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00018\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u00130\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001a\u001a\n \u001c*\u0004\u0018\u00010\u001b0\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001d\u001a\n \u001c*\u0004\u0018\u00010\u001b0\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001e\u001a\u0004\u0018\u00018\u0000X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u001fR\u001a\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00140\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R$\u0010%\u001a\u00020$2\u0006\u0010#\u001a\u00020$8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\u0014\u0010/\u001a\u0002008BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b1\u00102\u00a8\u00066"}, d2={"Lcom/typewritermc/basic/entries/dialogue/messengers/input/JavaInputDialogueDialogueMessenger;", "IntermediateType", "", "ContextType", "Lcom/typewritermc/engine/paper/entry/dialogue/DialogueMessenger;", "Lcom/typewritermc/basic/entries/dialogue/InputDialogueEntry;", "player", "Lorg/bukkit/entity/Player;", "context", "Lcom/typewritermc/core/interaction/InteractionContext;", "entry", "key", "Lcom/typewritermc/core/interaction/EntryContextKey;", "parser", "Lkotlin/Function1;", "", "Lkotlin/Result;", "contextConverter", "triggers", "", "Lcom/typewritermc/engine/paper/entry/entries/EventTrigger;", "<init>", "(Lorg/bukkit/entity/Player;Lcom/typewritermc/core/interaction/InteractionContext;Lcom/typewritermc/basic/entries/dialogue/InputDialogueEntry;Lcom/typewritermc/core/interaction/EntryContextKey;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)V", "speakerDisplayName", "text", "infoText", "typingDuration", "Ljava/time/Duration;", "kotlin.jvm.PlatformType", "playedTime", "provided", "Ljava/lang/Object;", "eventTriggers", "getEventTriggers", "()Ljava/util/List;", "value", "", "animationComplete", "getAnimationComplete", "()Z", "setAnimationComplete", "(Z)V", "init", "", "onPlayerChat", "event", "Lio/papermc/paper/event/player/AsyncChatEvent;", "percentage", "", "getPercentage", "()D", "tick", "Lcom/typewritermc/engine/paper/entry/dialogue/TickContext;", "sendInputDialogue", "BasicExtension"})
public final class JavaInputDialogueDialogueMessenger<IntermediateType, ContextType>
extends DialogueMessenger<InputDialogueEntry> {
    @NotNull
    private final EntryContextKey key;
    @NotNull
    private final Function1<String, Result<IntermediateType>> parser;
    @NotNull
    private final Function1<IntermediateType, ContextType> contextConverter;
    @NotNull
    private final Function1<IntermediateType, List<EventTrigger>> triggers;
    @NotNull
    private String speakerDisplayName;
    @NotNull
    private String text;
    @NotNull
    private String infoText;
    private Duration typingDuration;
    private Duration playedTime;
    @Nullable
    private IntermediateType provided;

    public JavaInputDialogueDialogueMessenger(@NotNull Player player, @NotNull InteractionContext context, @NotNull InputDialogueEntry entry2, @NotNull EntryContextKey key, @NotNull Function1<? super String, ? extends Result<? extends IntermediateType>> parser, @NotNull Function1<? super IntermediateType, ? extends ContextType> contextConverter, @NotNull Function1<? super IntermediateType, ? extends List<? extends EventTrigger>> triggers) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)entry2, (String)"entry");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(parser, (String)"parser");
        Intrinsics.checkNotNullParameter(contextConverter, (String)"contextConverter");
        Intrinsics.checkNotNullParameter(triggers, (String)"triggers");
        super(player, context, (DialogueEntry)entry2);
        this.key = key;
        this.parser = parser;
        this.contextConverter = contextConverter;
        this.triggers = triggers;
        this.speakerDisplayName = "";
        this.text = "";
        this.infoText = "";
        this.typingDuration = Duration.ZERO;
        this.playedTime = Duration.ZERO;
    }

    @NotNull
    public List<EventTrigger> getEventTriggers() {
        return (List)this.triggers.invoke(this.provided);
    }

    public boolean getAnimationComplete() {
        if (!StringsKt.startsWith$default((String)this.infoText, (String)"<red>", (boolean)false, (int)2, null)) {
            this.infoText = "<red>" + this.infoText;
        }
        return this.getState() == MessengerState.FINISHED;
    }

    public void setAnimationComplete(boolean value) {
        this.playedTime = !value ? Duration.ZERO : this.typingDuration;
    }

    public void init() {
        super.init();
        this.speakerDisplayName = PlaceholderExpansionKt.parsePlaceholders((String)((String)Var.get$default((Var)((InputDialogueEntry)this.getEntry()).getSpeakerDisplayName(), (Player)this.getPlayer(), null, (int)2, null)), (Player)this.getPlayer());
        this.text = PlaceholderExpansionKt.parsePlaceholders((String)((String)Var.get$default(((InputDialogueEntry)this.getEntry()).getText(), (Player)this.getPlayer(), null, (int)2, null)), (Player)this.getPlayer());
        this.infoText = JavaInputDialogueDialogueMessengerKt.getInputInfoText();
        this.typingDuration = TypeDurationKt.getTypingDurationType().totalDuration(MiniMessagesKt.stripped((String)this.text), (Duration)Var.get$default(((InputDialogueEntry)this.getEntry()).getDuration(), (Player)this.getPlayer(), null, (int)2, null));
    }

    @EventHandler(priority=EventPriority.LOW)
    private final void onPlayerChat(AsyncChatEvent event) {
        if (!Intrinsics.areEqual((Object)event.getPlayer().getUniqueId(), (Object)this.getPlayer().getUniqueId())) {
            return;
        }
        event.setCancelled(true);
        Component component = event.message();
        Intrinsics.checkNotNullExpressionValue((Object)component, (String)"message(...)");
        String message = MiniMessagesKt.plainText((Component)component);
        Object result = ((Result)this.parser.invoke((Object)message)).unbox-impl();
        if (Result.isFailure-impl((Object)result)) {
            Object object = Result.exceptionOrNull-impl((Object)result);
            if (object == null || (object = ((Throwable)object).getMessage()) == null) {
                object = "<red>Invalid input";
            }
            this.infoText = object;
            this.sendInputDialogue(this.getPlayer());
            return;
        }
        Object object = Result.isFailure-impl((Object)result) ? null : result;
        if (object == null) {
            return;
        }
        Object value = object;
        this.provided = value;
        this.set(this.getContext(), (Entry)this.getEntry(), this.key, this.contextConverter.invoke(value));
        this.setState(MessengerState.FINISHED);
    }

    private final double getPercentage() {
        return !this.typingDuration.isZero() ? (double)this.playedTime.toMillis() / (double)this.typingDuration.toMillis() : 1.2;
    }

    public void tick(@NotNull TickContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (this.getState() != MessengerState.RUNNING) {
            return;
        }
        Duration duration = this.playedTime = this.playedTime.plus(context.getDeltaTime());
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"playedTime");
        long playedTicks = ExtensionsKt.toTicks((Duration)duration);
        if (this.getPercentage() > 1.1) {
            boolean shouldDisplay;
            boolean bl = shouldDisplay = playedTicks % (long)50 == 0L;
            if (!shouldDisplay) {
                return;
            }
        }
        this.sendInputDialogue(this.getPlayer());
    }

    private final void sendInputDialogue(Player $this$sendInputDialogue) {
        String rawText = MiniMessagesKt.stripped((String)this.text);
        int resultingLines = ExtensionsKt.getLineCount((String)MiniMessagesKt.limitLineLength((String)rawText, (int)JavaInputDialogueDialogueMessengerKt.getInputMaxLineLength()));
        String string = this.text;
        double d = this.getPercentage();
        TagResolver[] tagResolverArray = JavaInputDialogueDialogueMessengerKt.getInputPadding();
        int n = RangesKt.coerceAtLeast((int)JavaInputDialogueDialogueMessengerKt.getInputMinLength(), (int)resultingLines);
        int n2 = JavaInputDialogueDialogueMessengerKt.getInputMaxLineLength();
        Component message = MiniMessagesKt.asPartialFormattedMini((String)string, (double)d, (int)n, (int)n2, (String)tagResolverArray);
        int charactersLeft = RangesKt.coerceAtLeast((int)(50 - MiniMessagesKt.stripped((String)this.infoText).length()), (int)0);
        int charactersPadding = charactersLeft / 2;
        String string2 = JavaInputDialogueDialogueMessengerKt.getInputFormat();
        tagResolverArray = new TagResolver[5];
        Intrinsics.checkNotNullExpressionValue((Object)Placeholder.parsed((String)"speaker", (String)this.speakerDisplayName), (String)"parsed(...)");
        Intrinsics.checkNotNullExpressionValue((Object)Placeholder.component((String)"message", (ComponentLike)((ComponentLike)message)), (String)"component(...)");
        Intrinsics.checkNotNullExpressionValue((Object)Placeholder.parsed((String)"info_text", (String)this.infoText), (String)"parsed(...)");
        Intrinsics.checkNotNullExpressionValue((Object)Placeholder.unparsed((String)"info_padding", (String)StringsKt.repeat((CharSequence)" ", (int)charactersPadding)), (String)"unparsed(...)");
        Intrinsics.checkNotNullExpressionValue((Object)Placeholder.parsed((String)"padding", (String)JavaInputDialogueDialogueMessengerKt.getInputPadding()), (String)"parsed(...)");
        Component component = MiniMessagesKt.asMiniWithResolvers((String)string2, (TagResolver[])tagResolverArray);
        Component componentWithDarkMessages = ChatHistory.composeDarkMessage$default((ChatHistory)ChatHistoryHandlerKt.getChatHistory((Player)$this$sendInputDialogue), (Component)component, (boolean)false, (int)2, null);
        $this$sendInputDialogue.sendMessage(componentWithDarkMessages);
    }
}

