/*
 * Decompiled with CFR 0.152.
 */
package com.typewritermc.basic.entries.dialogue.messengers.option;

import com.typewritermc.basic.entries.dialogue.Option;
import com.typewritermc.basic.entries.dialogue.OptionContextKeys;
import com.typewritermc.basic.entries.dialogue.OptionDialogueEntry;
import com.typewritermc.basic.entries.dialogue.messengers.option.JavaOptionDialogueDialogueMessengerKt;
import com.typewritermc.core.entries.Entry;
import com.typewritermc.core.interaction.InteractionContext;
import com.typewritermc.core.utils.LoopingKt;
import com.typewritermc.engine.paper.entry.BaseEntryKt;
import com.typewritermc.engine.paper.entry.Modifier;
import com.typewritermc.engine.paper.entry.dialogue.ConfirmationKeyHandler;
import com.typewritermc.engine.paper.entry.dialogue.ConfirmationKeyKt;
import com.typewritermc.engine.paper.entry.dialogue.DialogueMessenger;
import com.typewritermc.engine.paper.entry.dialogue.MessengerState;
import com.typewritermc.engine.paper.entry.dialogue.TickContext;
import com.typewritermc.engine.paper.entry.dialogue.TypeDurationKt;
import com.typewritermc.engine.paper.entry.entries.DialogueEntry;
import com.typewritermc.engine.paper.entry.entries.EventTrigger;
import com.typewritermc.engine.paper.entry.entries.Var;
import com.typewritermc.engine.paper.extensions.placeholderapi.PlaceholderExpansionKt;
import com.typewritermc.engine.paper.interaction.ChatHistory;
import com.typewritermc.engine.paper.interaction.ChatHistoryHandlerKt;
import com.typewritermc.engine.paper.utils.ExtensionsKt;
import com.typewritermc.engine.paper.utils.MiniMessagesKt;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.JoinConfiguration;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0002\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010-\u001a\u00020.H\u0016J\u0010\u0010/\u001a\u00020.2\u0006\u00100\u001a\u000201H\u0003J\u0010\u00102\u001a\u00020.2\u0006\u0010\u0005\u001a\u000203H\u0016J\u0010\u00104\u001a\u00020.2\u0006\u0010\u001c\u001a\u00020\rH\u0002J\u0010\u00105\u001a\u0002062\u0006\u00107\u001a\u00020\u001aH\u0002J\b\u00108\u001a\u00020.H\u0016R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\u0011\u0010\u0012R\u0016\u0010\u0013\u001a\u0004\u0018\u00010\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00140\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001c\u001a\n \u001d*\u0004\u0018\u00010\r0\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001e\u001a\n \u001d*\u0004\u0018\u00010\r0\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u001a\u0010%\u001a\b\u0012\u0004\u0012\u00020&0\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010$R$\u0010(\u001a\u00020 2\u0006\u0010\u000e\u001a\u00020 8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,\u00a8\u00069"}, d2={"Lcom/typewritermc/basic/entries/dialogue/messengers/option/JavaOptionDialogueDialogueMessenger;", "Lcom/typewritermc/engine/paper/entry/dialogue/DialogueMessenger;", "Lcom/typewritermc/basic/entries/dialogue/OptionDialogueEntry;", "player", "Lorg/bukkit/entity/Player;", "context", "Lcom/typewritermc/core/interaction/InteractionContext;", "entry", "<init>", "(Lorg/bukkit/entity/Player;Lcom/typewritermc/core/interaction/InteractionContext;Lcom/typewritermc/basic/entries/dialogue/OptionDialogueEntry;)V", "confirmationKeyHandler", "Lcom/typewritermc/engine/paper/entry/dialogue/ConfirmationKeyHandler;", "typeDuration", "Ljava/time/Duration;", "value", "", "selectedIndex", "setSelectedIndex", "(I)V", "selected", "Lcom/typewritermc/basic/entries/dialogue/Option;", "getSelected", "()Lcom/typewritermc/basic/entries/dialogue/Option;", "usableOptions", "", "speakerDisplayName", "", "parsedText", "playTime", "kotlin.jvm.PlatformType", "totalDuration", "completedAnimation", "", "eventTriggers", "Lcom/typewritermc/engine/paper/entry/entries/EventTrigger;", "getEventTriggers", "()Ljava/util/List;", "modifiers", "Lcom/typewritermc/engine/paper/entry/Modifier;", "getModifiers", "animationComplete", "getAnimationComplete", "()Z", "setAnimationComplete", "(Z)V", "init", "", "onPlayerItemHeld", "event", "Lorg/bukkit/event/player/PlayerItemHeldEvent;", "tick", "Lcom/typewritermc/engine/paper/entry/dialogue/TickContext;", "displayMessage", "formatOptions", "Lnet/kyori/adventure/text/Component;", "rawText", "dispose", "BasicExtension"})
@SourceDebugExtension(value={"SMAP\nJavaOptionDialogueDialogueMessenger.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JavaOptionDialogueDialogueMessenger.kt\ncom/typewritermc/basic/entries/dialogue/messengers/option/JavaOptionDialogueDialogueMessenger\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,227:1\n774#2:228\n865#2,2:229\n774#2:231\n865#2,2:232\n*S KotlinDebug\n*F\n+ 1 JavaOptionDialogueDialogueMessenger.kt\ncom/typewritermc/basic/entries/dialogue/messengers/option/JavaOptionDialogueDialogueMessenger\n*L\n98#1:228\n98#1:229,2\n137#1:231\n137#1:232,2\n*E\n"})
public final class JavaOptionDialogueDialogueMessenger
extends DialogueMessenger<OptionDialogueEntry> {
    @Nullable
    private ConfirmationKeyHandler confirmationKeyHandler;
    @NotNull
    private final Duration typeDuration;
    private int selectedIndex;
    @NotNull
    private List<Option> usableOptions;
    @NotNull
    private String speakerDisplayName;
    @NotNull
    private String parsedText;
    private Duration playTime;
    private Duration totalDuration;
    private boolean completedAnimation;

    public JavaOptionDialogueDialogueMessenger(@NotNull Player player, @NotNull InteractionContext context, @NotNull OptionDialogueEntry entry2) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)entry2, (String)"entry");
        super(player, context, (DialogueEntry)entry2);
        this.typeDuration = (Duration)Var.get$default(entry2.getDuration(), (Player)player, null, (int)2, null);
        this.usableOptions = CollectionsKt.emptyList();
        this.speakerDisplayName = "";
        this.parsedText = "";
        this.playTime = Duration.ZERO;
        this.totalDuration = Duration.ZERO;
    }

    private final void setSelectedIndex(int value) {
        this.selectedIndex = value;
        this.set(this.getContext(), (Entry)this.getEntry(), OptionContextKeys.SELECTED_OPTION, value + 1);
    }

    private final Option getSelected() {
        return (Option)CollectionsKt.getOrNull(this.usableOptions, (int)this.selectedIndex);
    }

    @NotNull
    public List<EventTrigger> getEventTriggers() {
        Object object;
        return CollectionsKt.plus((Collection)((OptionDialogueEntry)this.getEntry()).getEventTriggers(), (Iterable)((object = this.getSelected()) != null && (object = ((Option)object).getEventTriggers()) != null ? (Iterable)object : (Iterable)CollectionsKt.emptyList()));
    }

    @NotNull
    public List<Modifier> getModifiers() {
        Object object;
        return CollectionsKt.plus((Collection)((OptionDialogueEntry)this.getEntry()).getModifiers(), (Iterable)((object = this.getSelected()) != null && (object = ((Option)object).getModifiers()) != null ? (Iterable)object : (Iterable)CollectionsKt.emptyList()));
    }

    public boolean getAnimationComplete() {
        return this.playTime.compareTo(this.totalDuration) >= 0;
    }

    public void setAnimationComplete(boolean value) {
        this.playTime = !value ? Duration.ZERO : this.totalDuration;
    }

    /*
     * WARNING - void declaration
     */
    public void init() {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Iterable iterable = ((OptionDialogueEntry)this.getEntry()).getOptions();
        JavaOptionDialogueDialogueMessenger javaOptionDialogueDialogueMessenger = this;
        boolean $i$f$filter = false;
        void var3_5 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Option it = (Option)element$iv$iv;
            boolean bl = false;
            if (!BaseEntryKt.matches((Iterable)it.getCriteria(), (Player)this.getPlayer(), (InteractionContext)this.getContext())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        javaOptionDialogueDialogueMessenger.usableOptions = (List)destination$iv$iv;
        this.speakerDisplayName = PlaceholderExpansionKt.parsePlaceholders((String)((String)Var.get$default(((OptionDialogueEntry)this.getEntry()).getSpeakerDisplayName(), (Player)this.getPlayer(), null, (int)2, null)), (Player)this.getPlayer());
        this.parsedText = PlaceholderExpansionKt.parsePlaceholders((String)((String)Var.get$default(((OptionDialogueEntry)this.getEntry()).getText(), (Player)this.getPlayer(), null, (int)2, null)), (Player)this.getPlayer());
        String rawText = MiniMessagesKt.stripped((String)this.parsedText);
        Duration typingDuration = TypeDurationKt.getTypingDurationType().totalDuration(rawText, this.typeDuration);
        Duration optionsShowingDuration = Duration.ofMillis((long)this.usableOptions.size() * (long)JavaOptionDialogueDialogueMessengerKt.access$getDelayOptionShow());
        this.totalDuration = typingDuration.plus(optionsShowingDuration);
        super.init();
        this.confirmationKeyHandler = ConfirmationKeyKt.getConfirmationKey().handler(this.getPlayer(), () -> JavaOptionDialogueDialogueMessenger.init$lambda$1(this));
    }

    @EventHandler
    private final void onPlayerItemHeld(PlayerItemHeldEvent event) {
        int newIndex;
        if (!Intrinsics.areEqual((Object)event.getPlayer().getUniqueId(), (Object)this.getPlayer().getUniqueId())) {
            return;
        }
        int curSlot = event.getPreviousSlot();
        int newSlot = event.getNewSlot();
        int dif = LoopingKt.loopingDistance((int)curSlot, (int)newSlot, (int)8);
        int index = this.selectedIndex;
        event.setCancelled(true);
        for (newIndex = (index + dif) % this.usableOptions.size(); newIndex < 0; newIndex += this.usableOptions.size()) {
        }
        this.setSelectedIndex(newIndex);
        Duration duration = this.playTime;
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"playTime");
        this.displayMessage(duration);
    }

    /*
     * WARNING - void declaration
     */
    public void tick(@NotNull TickContext context) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super.tick(context);
        boolean isFirst = Intrinsics.areEqual((Object)this.playTime, (Object)Duration.ZERO);
        this.playTime = this.playTime.plus(context.getDeltaTime());
        if (this.getState() != MessengerState.RUNNING) {
            return;
        }
        boolean forceSend = false;
        Iterable $this$filter$iv = ((OptionDialogueEntry)this.getEntry()).getOptions();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Option it = (Option)element$iv$iv;
            boolean bl = false;
            if (!BaseEntryKt.matches((Iterable)it.getCriteria(), (Player)this.getPlayer(), (InteractionContext)this.getContext())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List newOptions = (List)destination$iv$iv;
        if (!Intrinsics.areEqual((Object)newOptions, this.usableOptions)) {
            this.usableOptions = newOptions;
            this.setSelectedIndex(0);
            forceSend = true;
        }
        if (this.usableOptions.isEmpty()) {
            this.setAnimationComplete(true);
            this.setState(MessengerState.FINISHED);
            return;
        }
        Duration duration = this.playTime;
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"playTime");
        if (ExtensionsKt.toTicks((Duration)duration) % (long)100 > 0L && this.completedAnimation && !isFirst && !forceSend) {
            return;
        }
        Duration duration2 = this.playTime;
        Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"playTime");
        this.displayMessage(duration2);
    }

    private final void displayMessage(Duration playTime) {
        String rawText = MiniMessagesKt.stripped((String)this.parsedText);
        double typePercentage = this.typeDuration.isZero() ? 1.0 : TypeDurationKt.getTypingDurationType().calculatePercentage(playTime, this.typeDuration, rawText);
        int resultingLines = ExtensionsKt.getLineCount((String)MiniMessagesKt.limitLineLength((String)rawText, (int)JavaOptionDialogueDialogueMessengerKt.getOptionMaxLineLength()));
        String string = this.parsedText;
        int n = JavaOptionDialogueDialogueMessengerKt.getOptionMaxLineLength();
        Component text = MiniMessagesKt.asPartialFormattedMini((String)string, (double)typePercentage, (int)resultingLines, (int)n, (String)"");
        String string2 = JavaOptionDialogueDialogueMessengerKt.getOptionFormat();
        TagResolver[] tagResolverArray = new TagResolver[3];
        Intrinsics.checkNotNullExpressionValue((Object)Placeholder.parsed((String)"speaker", (String)this.speakerDisplayName), (String)"parsed(...)");
        Intrinsics.checkNotNullExpressionValue((Object)Placeholder.component((String)"text", (ComponentLike)((ComponentLike)text)), (String)"component(...)");
        Intrinsics.checkNotNullExpressionValue((Object)Placeholder.component((String)"options", (ComponentLike)((ComponentLike)this.formatOptions(rawText))), (String)"component(...)");
        Component message = MiniMessagesKt.asMiniWithResolvers((String)string2, (TagResolver[])tagResolverArray);
        Component component = ChatHistory.composeDarkMessage$default((ChatHistory)ChatHistoryHandlerKt.getChatHistory((Player)this.getPlayer()), (Component)message, (boolean)false, (int)2, null);
        this.getPlayer().sendMessage(component);
    }

    private final Component formatOptions(String rawText) {
        int i;
        int showingOptions;
        List around = LoopingKt.around(this.usableOptions, (int)this.selectedIndex, (int)1, (int)2);
        List lines = new ArrayList();
        Duration typingDuration = TypeDurationKt.getTypingDurationType().totalDuration(rawText, this.typeDuration);
        Duration timeAfterTyping = this.playTime.minus(typingDuration);
        int limitedOptions = RangesKt.coerceAtLeast((int)((int)(timeAfterTyping.toMillis() / (long)JavaOptionDialogueDialogueMessengerKt.access$getDelayOptionShow())), (int)0);
        int maxOptions = Math.min(4, around.size());
        this.completedAnimation = maxOptions == (showingOptions = Math.min(maxOptions, limitedOptions));
        for (i = 0; i < showingOptions; ++i) {
            Option option = (Option)around.get(i);
            boolean isSelected = Intrinsics.areEqual((Object)this.getSelected(), (Object)option);
            String prefix = isSelected ? JavaOptionDialogueDialogueMessengerKt.access$getSelectedPrefix() : (i == 0 && this.selectedIndex > 1 && this.usableOptions.size() > 4 ? JavaOptionDialogueDialogueMessengerKt.access$getUpPrefix() : (i == 3 && this.selectedIndex < this.usableOptions.size() - 3 && this.usableOptions.size() > 4 ? JavaOptionDialogueDialogueMessengerKt.access$getDownPrefix() : JavaOptionDialogueDialogueMessengerKt.access$getUnselectedPrefix()));
            String format = isSelected ? JavaOptionDialogueDialogueMessengerKt.access$getSelectedOption() : JavaOptionDialogueDialogueMessengerKt.access$getUnselectedOption();
            Collection collection = lines;
            TagResolver[] tagResolverArray = new TagResolver[2];
            Intrinsics.checkNotNullExpressionValue((Object)Placeholder.parsed((String)"prefix", (String)prefix), (String)"parsed(...)");
            Intrinsics.checkNotNullExpressionValue((Object)Placeholder.parsed((String)"option_text", (String)PlaceholderExpansionKt.parsePlaceholders((String)((String)Var.get$default(option.getText(), (Player)this.getPlayer(), null, (int)2, null)), (Player)this.getPlayer())), (String)"parsed(...)");
            collection.add(MiniMessagesKt.asMiniWithResolvers((String)format, (TagResolver[])tagResolverArray));
        }
        for (i = showingOptions; i < maxOptions; ++i) {
            ((Collection)lines).add(Component.text((String)" \n"));
        }
        Component component = Component.join((JoinConfiguration)JoinConfiguration.noSeparators(), (Iterable)lines);
        Intrinsics.checkNotNullExpressionValue((Object)component, (String)"join(...)");
        return component;
    }

    public void dispose() {
        super.dispose();
        ConfirmationKeyHandler confirmationKeyHandler = this.confirmationKeyHandler;
        if (confirmationKeyHandler != null) {
            confirmationKeyHandler.dispose();
        }
        this.confirmationKeyHandler = null;
    }

    private static final Unit init$lambda$1(JavaOptionDialogueDialogueMessenger this$0) {
        this$0.completeOrFinish();
        return Unit.INSTANCE;
    }
}

