/*
 * Decompiled with CFR 0.152.
 */
package com.typewritermc.basic.entries.dialogue.messengers.timed;

import com.typewritermc.basic.entries.dialogue.TimedDialogueEntry;
import com.typewritermc.basic.entries.dialogue.messengers.timed.JavaTimedDialogueDialogueMessengerKt;
import com.typewritermc.core.interaction.InteractionContext;
import com.typewritermc.engine.paper.entry.dialogue.ConfirmationKeyHandler;
import com.typewritermc.engine.paper.entry.dialogue.ConfirmationKeyKt;
import com.typewritermc.engine.paper.entry.dialogue.DialogueMessenger;
import com.typewritermc.engine.paper.entry.dialogue.MessengerState;
import com.typewritermc.engine.paper.entry.dialogue.TickContext;
import com.typewritermc.engine.paper.entry.dialogue.TypeDurationKt;
import com.typewritermc.engine.paper.entry.entries.DialogueEntry;
import com.typewritermc.engine.paper.entry.entries.Var;
import com.typewritermc.engine.paper.extensions.placeholderapi.PlaceholderExpansionKt;
import com.typewritermc.engine.paper.utils.MiniMessagesKt;
import java.time.Duration;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0002\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u0005\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020\u001dH\u0016R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0012\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0013\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0014\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u00168V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001b\u00a8\u0006!"}, d2={"Lcom/typewritermc/basic/entries/dialogue/messengers/timed/JavaTimedDialogueDialogueMessenger;", "Lcom/typewritermc/engine/paper/entry/dialogue/DialogueMessenger;", "Lcom/typewritermc/basic/entries/dialogue/TimedDialogueEntry;", "player", "Lorg/bukkit/entity/Player;", "context", "Lcom/typewritermc/core/interaction/InteractionContext;", "entry", "<init>", "(Lorg/bukkit/entity/Player;Lcom/typewritermc/core/interaction/InteractionContext;Lcom/typewritermc/basic/entries/dialogue/TimedDialogueEntry;)V", "confirmationKeyHandler", "Lcom/typewritermc/engine/paper/entry/dialogue/ConfirmationKeyHandler;", "speakerDisplayName", "", "text", "typingDuration", "Ljava/time/Duration;", "kotlin.jvm.PlatformType", "waitDuration", "totalDuration", "playedTime", "value", "", "animationComplete", "getAnimationComplete", "()Z", "setAnimationComplete", "(Z)V", "init", "", "tick", "Lcom/typewritermc/engine/paper/entry/dialogue/TickContext;", "dispose", "BasicExtension"})
public final class JavaTimedDialogueDialogueMessenger
extends DialogueMessenger<TimedDialogueEntry> {
    @Nullable
    private ConfirmationKeyHandler confirmationKeyHandler;
    @NotNull
    private String speakerDisplayName;
    @NotNull
    private String text;
    private Duration typingDuration;
    private Duration waitDuration;
    private Duration totalDuration;
    private Duration playedTime;

    public JavaTimedDialogueDialogueMessenger(@NotNull Player player, @NotNull InteractionContext context, @NotNull TimedDialogueEntry entry2) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)entry2, (String)"entry");
        super(player, context, (DialogueEntry)entry2);
        this.speakerDisplayName = "";
        this.text = "";
        this.typingDuration = Duration.ZERO;
        this.waitDuration = Duration.ZERO;
        this.totalDuration = Duration.ZERO;
        this.playedTime = Duration.ZERO;
    }

    public boolean getAnimationComplete() {
        return this.playedTime.compareTo(this.typingDuration) >= 0;
    }

    public void setAnimationComplete(boolean value) {
        this.playedTime = !value ? Duration.ZERO : this.typingDuration;
    }

    public void init() {
        super.init();
        this.speakerDisplayName = PlaceholderExpansionKt.parsePlaceholders((String)((String)Var.get$default(((TimedDialogueEntry)this.getEntry()).getSpeakerDisplayName(), (Player)this.getPlayer(), null, (int)2, null)), (Player)this.getPlayer());
        this.text = PlaceholderExpansionKt.parsePlaceholders((String)((String)Var.get$default(((TimedDialogueEntry)this.getEntry()).getText(), (Player)this.getPlayer(), null, (int)2, null)), (Player)this.getPlayer());
        this.typingDuration = TypeDurationKt.getTypingDurationType().totalDuration(MiniMessagesKt.stripped((String)this.text), (Duration)Var.get$default(((TimedDialogueEntry)this.getEntry()).getTypingDuration(), (Player)this.getPlayer(), null, (int)2, null));
        this.waitDuration = (Duration)Var.get$default(((TimedDialogueEntry)this.getEntry()).getWaitDuration(), (Player)this.getPlayer(), null, (int)2, null);
        this.totalDuration = this.typingDuration.plus(this.waitDuration);
        this.confirmationKeyHandler = ConfirmationKeyKt.getConfirmationKey().handler(this.getPlayer(), () -> JavaTimedDialogueDialogueMessenger.init$lambda$0(this));
    }

    public void tick(@NotNull TickContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (this.getState() != MessengerState.RUNNING) {
            return;
        }
        this.playedTime = this.playedTime.plus(context.getDeltaTime());
        if (this.playedTime.compareTo(this.totalDuration) >= 0) {
            this.setState(MessengerState.FINISHED);
            return;
        }
        Player player = this.getPlayer();
        Duration duration = (Duration)Var.get$default(((TimedDialogueEntry)this.getEntry()).getTypingDuration(), (Player)this.getPlayer(), null, (int)2, null);
        Duration duration2 = this.typingDuration;
        Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"typingDuration");
        Duration duration3 = this.waitDuration;
        Intrinsics.checkNotNullExpressionValue((Object)duration3, (String)"waitDuration");
        Duration duration4 = this.playedTime;
        Intrinsics.checkNotNullExpressionValue((Object)duration4, (String)"playedTime");
        JavaTimedDialogueDialogueMessengerKt.sendTimedDialogue(player, this.text, this.speakerDisplayName, duration, duration2, duration3, duration4, (Boolean)((TimedDialogueEntry)this.getEntry()).getAllowSkip().get(this.getPlayer(), this.getContext()));
    }

    public void dispose() {
        super.dispose();
        ConfirmationKeyHandler confirmationKeyHandler = this.confirmationKeyHandler;
        if (confirmationKeyHandler != null) {
            confirmationKeyHandler.dispose();
        }
        this.confirmationKeyHandler = null;
    }

    private static final Unit init$lambda$0(JavaTimedDialogueDialogueMessenger this$0) {
        if (this$0.getState() != MessengerState.RUNNING) {
            return Unit.INSTANCE;
        }
        if (!((Boolean)((TimedDialogueEntry)this$0.getEntry()).getAllowSkip().get(this$0.getPlayer(), this$0.getContext())).booleanValue()) {
            return Unit.INSTANCE;
        }
        this$0.completeOrFinish();
        return Unit.INSTANCE;
    }
}

