/*
 * Decompiled with CFR 0.152.
 */
package com.typewritermc.basic.entries.fact;

import com.typewritermc.core.entries.Ref;
import com.typewritermc.core.extension.annotations.Entry;
import com.typewritermc.core.extension.annotations.Help;
import com.typewritermc.core.utils.DurationFormatKt;
import com.typewritermc.engine.paper.entry.ParsingContext;
import com.typewritermc.engine.paper.entry.PlaceholderEntryKt;
import com.typewritermc.engine.paper.entry.PlaceholderNodeBuilder;
import com.typewritermc.engine.paper.entry.PlaceholderParser;
import com.typewritermc.engine.paper.entry.entries.ExpirableFactEntry;
import com.typewritermc.engine.paper.entry.entries.GroupEntry;
import com.typewritermc.engine.paper.entry.entries.PersistableFactEntry;
import com.typewritermc.engine.paper.facts.FactData;
import com.typewritermc.engine.paper.facts.FactId;
import com.typewritermc.engine.paper.utils.CronExpression;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Entry(name="cron_fact", description="Saved until a specified date, like (0 0 * * 1)", color="#5843e6", icon="mingcute:calendar-time-add-fill")
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B?\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0004\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0003\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0005\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0014\u0010\u0006\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001c\u0010\n\u001a\u00020\u000b8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001f"}, d2={"Lcom/typewritermc/basic/entries/fact/CronFactEntry;", "Lcom/typewritermc/engine/paper/entry/entries/ExpirableFactEntry;", "Lcom/typewritermc/engine/paper/entry/entries/PersistableFactEntry;", "id", "", "name", "comment", "group", "Lcom/typewritermc/core/entries/Ref;", "Lcom/typewritermc/engine/paper/entry/entries/GroupEntry;", "cron", "Lcom/typewritermc/engine/paper/utils/CronExpression;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/typewritermc/core/entries/Ref;Lcom/typewritermc/engine/paper/utils/CronExpression;)V", "getId", "()Ljava/lang/String;", "getName", "getComment", "getGroup", "()Lcom/typewritermc/core/entries/Ref;", "getCron$annotations", "()V", "getCron", "()Lcom/typewritermc/engine/paper/utils/CronExpression;", "hasExpired", "", "Lcom/typewritermc/engine/paper/facts/FactId;", "data", "Lcom/typewritermc/engine/paper/facts/FactData;", "parser", "Lcom/typewritermc/engine/paper/entry/PlaceholderParser;", "BasicExtension"})
@SourceDebugExtension(value={"SMAP\nCronFactEntry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CronFactEntry.kt\ncom/typewritermc/basic/entries/fact/CronFactEntry\n+ 2 EntryReference.kt\ncom/typewritermc/core/entries/EntryReferenceKt\n*L\n1#1,71:1\n6#2:72\n*S KotlinDebug\n*F\n+ 1 CronFactEntry.kt\ncom/typewritermc/basic/entries/fact/CronFactEntry\n*L\n33#1:72\n*E\n"})
public final class CronFactEntry
implements ExpirableFactEntry,
PersistableFactEntry {
    @NotNull
    private final String id;
    @NotNull
    private final String name;
    @NotNull
    private final String comment;
    @NotNull
    private final Ref<GroupEntry> group;
    @NotNull
    private final CronExpression cron;

    public CronFactEntry(@NotNull String id, @NotNull String name, @NotNull String comment, @NotNull Ref<GroupEntry> group2, @NotNull CronExpression cron) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)comment, (String)"comment");
        Intrinsics.checkNotNullParameter(group2, (String)"group");
        Intrinsics.checkNotNullParameter((Object)cron, (String)"cron");
        this.id = id;
        this.name = name;
        this.comment = comment;
        this.group = group2;
        this.cron = cron;
    }

    public /* synthetic */ CronFactEntry(String string, String string2, String string3, Ref ref, CronExpression cronExpression, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "";
        }
        if ((n & 2) != 0) {
            string2 = "";
        }
        if ((n & 4) != 0) {
            string3 = "";
        }
        if ((n & 8) != 0) {
            boolean $i$f$emptyRef = false;
            ref = new Ref("", Reflection.getOrCreateKotlinClass(GroupEntry.class), null, 4, null);
        }
        if ((n & 0x10) != 0) {
            cronExpression = CronExpression.Companion.default();
        }
        this(string, string2, string3, (Ref<GroupEntry>)ref, cronExpression);
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public String getComment() {
        return this.comment;
    }

    @NotNull
    public Ref<GroupEntry> getGroup() {
        return this.group;
    }

    @NotNull
    public final CronExpression getCron() {
        return this.cron;
    }

    @Help(text="The cron expression when the fact expires.")
    public static /* synthetic */ void getCron$annotations() {
    }

    public boolean hasExpired(@NotNull FactId id, @NotNull FactData data) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return this.cron.nextLocalDateTimeAfter(data.getLastUpdate()).isBefore(LocalDateTime.now());
    }

    @NotNull
    public PlaceholderParser parser() {
        return PlaceholderEntryKt.placeholderParser(arg_0 -> CronFactEntry.parser$lambda$5(this, arg_0));
    }

    @NotNull
    public FactData readForGroup-1dlmaes(@NotNull String groupId) {
        return super.readForGroup-1dlmaes(groupId);
    }

    @NotNull
    public FactData readSinglePlayer(@NotNull Player player) {
        return super.readSinglePlayer(player);
    }

    @NotNull
    public FactData read(@NotNull FactId id) {
        return super.read(id);
    }

    public void write(@NotNull FactId id, int value) {
        super.write(id, value);
    }

    public void write(@NotNull Player player, int value) {
        super.write(player, value);
    }

    public boolean canCache(@NotNull FactId id, @NotNull FactData factData) {
        return super.canCache(id, factData);
    }

    @NotNull
    public FactData readForPlayersGroup(@NotNull Player player) {
        return super.readForPlayersGroup(player);
    }

    @Nullable
    public FactId identifier(@NotNull Player player) {
        return super.identifier(player);
    }

    public boolean canPersist(@NotNull FactId id, @NotNull FactData data) {
        return super.canPersist(id, data);
    }

    private static final String parser$lambda$5$lambda$4$lambda$3$lambda$1$lambda$0(CronFactEntry this$0, ParsingContext $this$supplyPlayer, Player player) {
        Intrinsics.checkNotNullParameter((Object)$this$supplyPlayer, (String)"$this$supplyPlayer");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        LocalDateTime lastUpdate = this$0.readForPlayersGroup(player).getLastUpdate();
        LocalDateTime expires = this$0.cron.nextLocalDateTimeAfter(lastUpdate);
        LocalDateTime now = LocalDateTime.now();
        if (now.isAfter(expires)) {
            return "now";
        }
        java.time.Duration duration = java.time.Duration.between(now, expires);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"between(...)");
        java.time.Duration duration2 = duration;
        long difference = Duration.plus-LRDsOJo((long)DurationKt.toDuration((long)duration2.getSeconds(), (DurationUnit)DurationUnit.SECONDS), (long)DurationKt.toDuration((int)duration2.getNano(), (DurationUnit)DurationUnit.NANOSECONDS));
        return DurationFormatKt.formatCompact-LRDsOJo((long)difference);
    }

    private static final Unit parser$lambda$5$lambda$4$lambda$3$lambda$1(CronFactEntry this$0, PlaceholderNodeBuilder $this$literal) {
        Intrinsics.checkNotNullParameter((Object)$this$literal, (String)"$this$literal");
        PlaceholderEntryKt.supplyPlayer((PlaceholderNodeBuilder)$this$literal, (arg_0, arg_1) -> CronFactEntry.parser$lambda$5$lambda$4$lambda$3$lambda$1$lambda$0(this$0, arg_0, arg_1));
        return Unit.INSTANCE;
    }

    private static final String parser$lambda$5$lambda$4$lambda$3$lambda$2(CronFactEntry this$0, ParsingContext $this$supplyPlayer, Player player) {
        Intrinsics.checkNotNullParameter((Object)$this$supplyPlayer, (String)"$this$supplyPlayer");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        LocalDateTime lastUpdate = this$0.readForPlayersGroup(player).getLastUpdate();
        LocalDateTime expires = this$0.cron.nextLocalDateTimeAfter(lastUpdate);
        return expires.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
    }

    private static final Unit parser$lambda$5$lambda$4$lambda$3(CronFactEntry this$0, PlaceholderNodeBuilder $this$literal) {
        Intrinsics.checkNotNullParameter((Object)$this$literal, (String)"$this$literal");
        PlaceholderEntryKt.literal((PlaceholderNodeBuilder)$this$literal, (String)"relative", arg_0 -> CronFactEntry.parser$lambda$5$lambda$4$lambda$3$lambda$1(this$0, arg_0));
        PlaceholderEntryKt.supplyPlayer((PlaceholderNodeBuilder)$this$literal, (arg_0, arg_1) -> CronFactEntry.parser$lambda$5$lambda$4$lambda$3$lambda$2(this$0, arg_0, arg_1));
        return Unit.INSTANCE;
    }

    private static final Unit parser$lambda$5$lambda$4(CronFactEntry this$0, PlaceholderNodeBuilder $this$literal) {
        Intrinsics.checkNotNullParameter((Object)$this$literal, (String)"$this$literal");
        PlaceholderEntryKt.literal((PlaceholderNodeBuilder)$this$literal, (String)"expires", arg_0 -> CronFactEntry.parser$lambda$5$lambda$4$lambda$3(this$0, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit parser$lambda$5(CronFactEntry this$0, PlaceholderNodeBuilder $this$placeholderParser) {
        Intrinsics.checkNotNullParameter((Object)$this$placeholderParser, (String)"$this$placeholderParser");
        PlaceholderEntryKt.include((PlaceholderNodeBuilder)$this$placeholderParser, (PlaceholderParser)super.parser());
        PlaceholderEntryKt.literal((PlaceholderNodeBuilder)$this$placeholderParser, (String)"time", arg_0 -> CronFactEntry.parser$lambda$5$lambda$4(this$0, arg_0));
        return Unit.INSTANCE;
    }

    public CronFactEntry() {
        this(null, null, null, null, null, 31, null);
    }
}

