/*
 * Decompiled with CFR 0.152.
 */
package com.typewritermc.basic.entries.variables;

import com.mthaler.aparser.arithmetic.EvalKt;
import com.mthaler.aparser.arithmetic.Expression;
import com.mthaler.aparser.util.Try;
import com.typewritermc.basic.entries.fact.RoundingMode;
import com.typewritermc.basic.entries.variables.CalculatedVariableData;
import com.typewritermc.basic.entries.variables.CalculationVariable;
import com.typewritermc.core.exceptions.ContextDataNotFoundException;
import com.typewritermc.core.extension.annotations.Entry;
import com.typewritermc.core.extension.annotations.GenericConstraint;
import com.typewritermc.core.extension.annotations.Help;
import com.typewritermc.core.extension.annotations.VariableData;
import com.typewritermc.core.utils.Generic;
import com.typewritermc.engine.paper.TypewriterPaperPluginKt;
import com.typewritermc.engine.paper.entry.entries.VarContext;
import com.typewritermc.engine.paper.entry.entries.VariableEntry;
import com.typewritermc.engine.paper.entry.entries.VariableEntryKt;
import com.typewritermc.engine.paper.extensions.placeholderapi.PlaceholderExpansionKt;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

@Entry(name="calculated_variable", description="A variable that is calculated", color="#4CAF50", icon="fa6-solid:calculator")
@GenericConstraint.Container(value={@GenericConstraint(type=int.class), @GenericConstraint(type=double.class)})
@VariableData(type=CalculatedVariableData.class)
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0003\u0018\u00002\u00020\u0001B5\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ%\u0010\u0015\u001a\u0002H\u0016\"\b\b\u0000\u0010\u0016*\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u00160\u0019H\u0016\u00a2\u0006\u0002\u0010\u001aR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001c\u0010\b\u001a\u00020\t8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001b"}, d2={"Lcom/typewritermc/basic/entries/variables/CalculatedVariable;", "Lcom/typewritermc/engine/paper/entry/entries/VariableEntry;", "id", "", "name", "variables", "", "Lcom/typewritermc/basic/entries/variables/CalculationVariable;", "roundingMode", "Lcom/typewritermc/basic/entries/fact/RoundingMode;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Lcom/typewritermc/basic/entries/fact/RoundingMode;)V", "getId", "()Ljava/lang/String;", "getName", "getVariables", "()Ljava/util/List;", "getRoundingMode$annotations", "()V", "getRoundingMode", "()Lcom/typewritermc/basic/entries/fact/RoundingMode;", "get", "T", "", "context", "Lcom/typewritermc/engine/paper/entry/entries/VarContext;", "(Lcom/typewritermc/engine/paper/entry/entries/VarContext;)Ljava/lang/Object;", "BasicExtension"})
@SourceDebugExtension(value={"SMAP\nCalculatedVariable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CalculatedVariable.kt\ncom/typewritermc/basic/entries/variables/CalculatedVariable\n+ 2 VariableEntry.kt\ncom/typewritermc/engine/paper/entry/entries/VariableEntryKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,70:1\n39#2:71\n1803#3,3:72\n*S KotlinDebug\n*F\n+ 1 CalculatedVariable.kt\ncom/typewritermc/basic/entries/variables/CalculatedVariable\n*L\n32#1:71\n39#1:72,3\n*E\n"})
final class CalculatedVariable
implements VariableEntry {
    @NotNull
    private final String id;
    @NotNull
    private final String name;
    @NotNull
    private final List<CalculationVariable> variables;
    @NotNull
    private final RoundingMode roundingMode;

    public CalculatedVariable(@NotNull String id, @NotNull String name, @NotNull List<CalculationVariable> variables, @NotNull RoundingMode roundingMode) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(variables, (String)"variables");
        Intrinsics.checkNotNullParameter((Object)((Object)roundingMode), (String)"roundingMode");
        this.id = id;
        this.name = name;
        this.variables = variables;
        this.roundingMode = roundingMode;
    }

    public /* synthetic */ CalculatedVariable(String string, String string2, List list, RoundingMode roundingMode, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "";
        }
        if ((n & 2) != 0) {
            string2 = "";
        }
        if ((n & 4) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 8) != 0) {
            roundingMode = RoundingMode.ROUND;
        }
        this(string, string2, list, roundingMode);
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public final List<CalculationVariable> getVariables() {
        return this.variables;
    }

    @NotNull
    public final RoundingMode getRoundingMode() {
        return this.roundingMode;
    }

    @Help(text="Rounding mode is only applied if the variable is of type Int")
    public static /* synthetic */ void getRoundingMode$annotations() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public <T> T get(@NotNull VarContext<T> context) {
        void $this$fold$iv;
        Intrinsics.checkNotNullParameter(context, (String)"context");
        VarContext<T> $this$getData$iv = context;
        boolean $i$f$getData = false;
        CalculatedVariableData calculatedVariableData = (CalculatedVariableData)$this$getData$iv.getData(CalculatedVariableData.class);
        if (calculatedVariableData == null) {
            throw new ContextDataNotFoundException(context.getKlass(), (Object)context.getData(), this.getId());
        }
        CalculatedVariableData data = calculatedVariableData;
        String expression = ((Object)StringsKt.trim((CharSequence)PlaceholderExpansionKt.parsePlaceholders((String)data.getExpression(), (Player)context.getPlayer()))).toString();
        if (StringsKt.isBlank((CharSequence)expression)) {
            return (T)VariableEntryKt.cast(context, (Object)0.0);
        }
        List variables = CollectionsKt.plus((Collection)data.getVariables(), (Iterable)this.variables);
        Iterable iterable = variables;
        String initial$iv = expression;
        boolean $i$f$fold = false;
        String accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void variable;
            CalculationVariable calculationVariable = (CalculationVariable)element$iv;
            String expression2 = accumulator$iv;
            boolean bl = false;
            Double d = (Double)((Generic)variable.getValue().get(context.getPlayer(), context.getInteractionContext())).get(Reflection.getOrCreateKotlinClass(Double.TYPE));
            double value = d != null ? d : 0.0;
            accumulator$iv = StringsKt.replace$default((String)expression2, (String)("<" + variable.getVariable() + ">"), (String)String.valueOf(value), (boolean)false, (int)4, null);
        }
        String replacedExpression = accumulator$iv;
        Try result = EvalKt.tryEval$default(Expression.INSTANCE.invoke(replacedExpression), null, 1, null);
        if (!(result instanceof Try.Success)) {
            if (result instanceof Try.Failure) {
                TypewriterPaperPluginKt.getLogger().warning("Could not evaluate expression '" + expression + "'" + (String)(!Intrinsics.areEqual((Object)expression, (Object)replacedExpression) ? " -> '" + replacedExpression + "'" : "") + " for player " + context.getPlayer().getName() + " for variable " + this.getId());
                return (T)VariableEntryKt.cast(context, (Object)0.0);
            }
            throw new NoWhenBranchMatchedException();
        }
        double value = ((Number)((Try.Success)result).getValue()).doubleValue();
        if (Intrinsics.areEqual((Object)context.getKlass(), (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE))) {
            return (T)VariableEntryKt.cast(context, (Object)this.roundingMode.apply(value));
        }
        return (T)VariableEntryKt.cast(context, (Object)value);
    }

    public CalculatedVariable() {
        this(null, null, null, null, 15, null);
    }
}

