/*
 * Decompiled with CFR 0.152.
 */
package com.typewritermc.quest.entries.audience;

import com.typewritermc.core.entries.Entry;
import com.typewritermc.core.entries.LibraryKt;
import com.typewritermc.core.extension.annotations.Colored;
import com.typewritermc.core.extension.annotations.Help;
import com.typewritermc.core.extension.annotations.MultiLine;
import com.typewritermc.core.extension.annotations.Placeholder;
import com.typewritermc.engine.paper.entry.PlaceholderParser;
import com.typewritermc.engine.paper.entry.entries.AudienceDisplay;
import com.typewritermc.engine.paper.entry.entries.LinesEntry;
import com.typewritermc.engine.paper.entry.entries.LinesProperty;
import com.typewritermc.engine.paper.extensions.placeholderapi.PlaceholderExpansionKt;
import com.typewritermc.engine.paper.utils.MiniMessagesKt;
import com.typewritermc.quest.ObjectiveEntry;
import com.typewritermc.quest.QuestEntryKt;
import java.util.Comparator;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.typewritermc.core.extension.annotations.Entry(name="objective_lines", description="Display all the current objectives", color="#FF4500", icon="fluent:clipboard-task-list-ltr-24-filled")
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B5\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u001c\u0010\u0005\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u000e\u0010\u000f\u001a\u0004\b\u0010\u0010\fR\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0016"}, d2={"Lcom/typewritermc/quest/entries/audience/ObjectiveLinesEntry;", "Lcom/typewritermc/engine/paper/entry/entries/LinesEntry;", "id", "", "name", "format", "priorityOverride", "Ljava/util/Optional;", "", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/Optional;)V", "getId", "()Ljava/lang/String;", "getName", "getFormat$annotations", "()V", "getFormat", "getPriorityOverride", "()Ljava/util/Optional;", "lines", "player", "Lorg/bukkit/entity/Player;", "QuestExtension"})
@SourceDebugExtension(value={"SMAP\nObjectiveLinesEntry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ObjectiveLinesEntry.kt\ncom/typewritermc/quest/entries/audience/ObjectiveLinesEntry\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,40:1\n622#2:41\n*S KotlinDebug\n*F\n+ 1 ObjectiveLinesEntry.kt\ncom/typewritermc/quest/entries/audience/ObjectiveLinesEntry\n*L\n36#1:41\n*E\n"})
public final class ObjectiveLinesEntry
implements LinesEntry {
    @NotNull
    private final String id;
    @NotNull
    private final String name;
    @NotNull
    private final String format;
    @NotNull
    private final Optional<Integer> priorityOverride;

    public ObjectiveLinesEntry(@NotNull String id, @NotNull String name, @NotNull String format, @NotNull Optional<Integer> priorityOverride) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        Intrinsics.checkNotNullParameter(priorityOverride, (String)"priorityOverride");
        this.id = id;
        this.name = name;
        this.format = format;
        this.priorityOverride = priorityOverride;
    }

    public /* synthetic */ ObjectiveLinesEntry(String string, String string2, String string3, Optional optional, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "";
        }
        if ((n & 2) != 0) {
            string2 = "";
        }
        if ((n & 4) != 0) {
            string3 = "<objective>";
        }
        if ((n & 8) != 0) {
            Optional<Integer> optional2 = Optional.empty();
            Intrinsics.checkNotNullExpressionValue(optional2, (String)"empty(...)");
            optional = optional2;
        }
        this(string, string2, string3, optional);
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public final String getFormat() {
        return this.format;
    }

    @Help(text="The format for the line. Use &lt;objective&gt; to replace with the objective name.")
    @Colored
    @Placeholder
    @MultiLine
    public static /* synthetic */ void getFormat$annotations() {
    }

    @NotNull
    public Optional<Integer> getPriorityOverride() {
        return this.priorityOverride;
    }

    @NotNull
    public String lines(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Sequence<ObjectiveEntry> $this$sortedByDescending$iv = QuestEntryKt.trackedShowingObjectives(player);
        boolean $i$f$sortedByDescending = false;
        return SequencesKt.joinToString$default((Sequence)SequencesKt.sortedWith($this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                ObjectiveEntry it = (ObjectiveEntry)b;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(LibraryKt.getPriority((Entry)((Entry)it)));
                it = (ObjectiveEntry)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(LibraryKt.getPriority((Entry)((Entry)it))));
            }
        }), (CharSequence)"\n", null, null, (int)0, null, arg_0 -> ObjectiveLinesEntry.lines$lambda$1(this, player, arg_0), (int)30, null);
    }

    @NotNull
    public PlaceholderParser parser() {
        return super.parser();
    }

    @NotNull
    public KClass<LinesProperty> type() {
        return super.type();
    }

    @NotNull
    public LinesProperty build(@NotNull Player player) {
        return super.build(player);
    }

    public boolean canApply(@NotNull Player player) {
        return super.canApply(player);
    }

    @Nullable
    public Object display(@NotNull Continuation<? super AudienceDisplay> $completion) {
        return super.display($completion);
    }

    private static final CharSequence lines$lambda$1(ObjectiveLinesEntry this$0, Player $player, ObjectiveEntry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return MiniMessagesKt.replaceTagPlaceholders((String)PlaceholderExpansionKt.parsePlaceholders((String)this$0.format, (Player)$player), (String)"objective", (String)it.display($player));
    }

    public ObjectiveLinesEntry() {
        this(null, null, null, null, 15, null);
    }
}

