/*
 * Decompiled with CFR 0.152.
 */
package com.typewritermc.rpgregions.entries.action;

import com.typewritermc.core.entries.Ref;
import com.typewritermc.core.extension.annotations.Entry;
import com.typewritermc.core.extension.annotations.Help;
import com.typewritermc.engine.paper.entry.Criteria;
import com.typewritermc.engine.paper.entry.Modifier;
import com.typewritermc.engine.paper.entry.TriggerableEntry;
import com.typewritermc.engine.paper.entry.entries.ActionEntry;
import com.typewritermc.engine.paper.entry.entries.ActionTrigger;
import com.typewritermc.engine.paper.entry.entries.EventTrigger;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.islandearth.rpgregions.api.RPGRegionsAPI;
import net.islandearth.rpgregions.managers.data.account.RPGRegionsAccount;
import net.islandearth.rpgregions.managers.data.region.ConfiguredRegion;
import net.islandearth.rpgregions.managers.data.region.Discovery;
import net.islandearth.rpgregions.managers.data.region.WorldDiscovery;
import org.jetbrains.annotations.NotNull;

@Entry(name="discover_rpg_region", description="Create a discover for an RPGRegions region", color="#D32F2F", icon="fa6-solid:address-book")
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B[\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0006\u0012\u0014\b\u0002\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\u0006\u0012\b\b\u0002\u0010\r\u001a\u00020\u0003\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\f\u0010\u0019\u001a\u00020\u001a*\u00020\u001bH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0014R \u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0014R\u0016\u0010\r\u001a\u00020\u00038\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001c"}, d2={"Lcom/typewritermc/rpgregions/entries/action/DiscoverRegionActionEntry;", "Lcom/typewritermc/engine/paper/entry/entries/ActionEntry;", "id", "", "name", "criteria", "", "Lcom/typewritermc/engine/paper/entry/Criteria;", "modifiers", "Lcom/typewritermc/engine/paper/entry/Modifier;", "triggers", "Lcom/typewritermc/core/entries/Ref;", "Lcom/typewritermc/engine/paper/entry/TriggerableEntry;", "region", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/lang/String;)V", "getId", "()Ljava/lang/String;", "getName", "getCriteria", "()Ljava/util/List;", "getModifiers", "getTriggers", "getRegion$annotations", "()V", "execute", "", "Lcom/typewritermc/engine/paper/entry/entries/ActionTrigger;", "RPGRegionsExtension"})
public final class DiscoverRegionActionEntry
implements ActionEntry {
    @NotNull
    private final String id;
    @NotNull
    private final String name;
    @NotNull
    private final List<Criteria> criteria;
    @NotNull
    private final List<Modifier> modifiers;
    @NotNull
    private final List<Ref<TriggerableEntry>> triggers;
    @NotNull
    private final String region;

    public DiscoverRegionActionEntry(@NotNull String id, @NotNull String name, @NotNull List<Criteria> criteria, @NotNull List<Modifier> modifiers, @NotNull List<Ref<TriggerableEntry>> triggers, @NotNull String region) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(criteria, (String)"criteria");
        Intrinsics.checkNotNullParameter(modifiers, (String)"modifiers");
        Intrinsics.checkNotNullParameter(triggers, (String)"triggers");
        Intrinsics.checkNotNullParameter((Object)region, (String)"region");
        this.id = id;
        this.name = name;
        this.criteria = criteria;
        this.modifiers = modifiers;
        this.triggers = triggers;
        this.region = region;
    }

    public /* synthetic */ DiscoverRegionActionEntry(String string, String string2, List list, List list2, List list3, String string3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "";
        }
        if ((n & 2) != 0) {
            string2 = "";
        }
        if ((n & 4) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 8) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        if ((n & 0x10) != 0) {
            list3 = CollectionsKt.emptyList();
        }
        if ((n & 0x20) != 0) {
            string3 = "";
        }
        this(string, string2, list, list2, list3, string3);
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public List<Criteria> getCriteria() {
        return this.criteria;
    }

    @NotNull
    public List<Modifier> getModifiers() {
        return this.modifiers;
    }

    @NotNull
    public List<Ref<TriggerableEntry>> getTriggers() {
        return this.triggers;
    }

    @Help(text="Make sure that this is the region ID, not the region's display name")
    private static /* synthetic */ void getRegion$annotations() {
    }

    public void execute(@NotNull ActionTrigger $this$execute) {
        Intrinsics.checkNotNullParameter((Object)$this$execute, (String)"<this>");
        Optional region = RPGRegionsAPI.getAPI().getManagers().getRegionsCache().getConfiguredRegion(this.region);
        if (!region.isPresent()) {
            return;
        }
        CompletableFuture user = RPGRegionsAPI.getAPI().getManagers().getStorageManager().getAccount($this$execute.getPlayer().getUniqueId());
        LocalDateTime localDateTime = LocalDateTime.now();
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"now(...)");
        LocalDateTime date = localDateTime;
        WorldDiscovery worldDiscovery = new WorldDiscovery(date, ((ConfiguredRegion)region.get()).getId());
        ((RPGRegionsAccount)user.get()).addDiscovery((Discovery)worldDiscovery);
        RPGRegionsAPI.getAPI().getManagers().getStorageManager().removeCachedAccount($this$execute.getPlayer().getUniqueId());
    }

    @NotNull
    public List<EventTrigger> getEventTriggers() {
        return super.getEventTriggers();
    }

    public DiscoverRegionActionEntry() {
        this(null, null, null, null, null, null, 63, null);
    }
}

