/*
 * Decompiled with CFR 0.152.
 */
package com.extollit.collect;

import com.extollit.collect.AbstractArrayIterable;
import java.util.Arrays;
import java.util.Iterator;

public final class KeyedArrayIterable<T>
extends AbstractArrayIterable<Entry<T>, T> {
    public KeyedArrayIterable(T[] elements) {
        super(elements);
    }

    @Override
    public Iterator<Entry<T>> iterator() {
        return new Iter<Object>((T[])this.delegate);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KeyedArrayIterable that = (KeyedArrayIterable)o;
        return Arrays.equals(this.delegate, that.delegate);
    }

    public int hashCode() {
        return Arrays.hashCode(this.delegate);
    }

    public static class Iter<T>
    extends AbstractArrayIterable.AbstractIter<Entry<T>, T> {
        public Iter(T[] array) {
            super(array);
        }

        @Override
        protected final Entry<T> map(int index, T input) {
            return new Entry<T>(index, input);
        }
    }

    public static final class Entry<T> {
        public final int index;
        public final T element;

        public Entry(int index, T element) {
            this.index = index;
            this.element = element;
        }

        public String toString() {
            return this.index + " -> " + this.element;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Entry entry2 = (Entry)o;
            if (this.index != entry2.index) {
                return false;
            }
            return this.element != null ? this.element.equals(entry2.element) : entry2.element == null;
        }

        public int hashCode() {
            return this.index;
        }

        public <V> Entry<V> with(V value) {
            return new Entry<V>(this.index, value);
        }
    }
}

