/*
 * Decompiled with CFR 0.152.
 */
package com.extollit.gaming.ai.path.model;

import com.extollit.gaming.ai.path.model.IBlockDescription;
import com.extollit.gaming.ai.path.model.IColumnarSpace;
import com.extollit.gaming.ai.path.model.IInstanceSpace;
import com.extollit.gaming.ai.path.model.OcclusionField;

public class ColumnarOcclusionFieldList {
    public final IColumnarSpace container;
    private OcclusionField[] fields;

    public ColumnarOcclusionFieldList(IColumnarSpace container) {
        this.container = container;
    }

    public void reset() {
        this.fields = null;
    }

    public void onBlockChanged(int x, int y, int z, IBlockDescription description, int metaData) {
        OcclusionField[] fields = this.fields;
        if (fields == null) {
            return;
        }
        OcclusionField field = fields[y >> 4 & 0xF];
        if (field == null) {
            return;
        }
        field.set(this.container, x, y, z, description);
    }

    public final OcclusionField occlusionFieldAt(int cx, int cy, int cz) {
        OcclusionField result;
        OcclusionField[] fields = this.fields;
        if (fields == null) {
            fields = this.fields = new OcclusionField[16];
        }
        if ((result = fields[cy]) == null) {
            OcclusionField occlusionField;
            fields[cy] = occlusionField = this.createOcclusionField(cx, cy, cz);
            return fields[cy];
        }
        return result;
    }

    public final OcclusionField optOcclusionFieldAt(int cy) {
        return this.fields == null ? null : this.fields[cy];
    }

    public static OcclusionField optOcclusionFieldAt(IInstanceSpace instance, int cx, int cy, int cz) {
        IColumnarSpace columnarSpace = instance.columnarSpaceAt(cx, cz);
        if (columnarSpace == null) {
            return null;
        }
        return columnarSpace.occlusionFields().optOcclusionFieldAt(cy);
    }

    protected OcclusionField createOcclusionField(int cx, int cy, int cz) {
        OcclusionField occlusionField = new OcclusionField();
        occlusionField.loadFrom(this.container, cx, cy, cz);
        return occlusionField;
    }
}

