/*
 * Decompiled with CFR 0.152.
 */
package com.extollit.gaming.ai.path.model;

import com.extollit.collect.FilterIterable;
import com.extollit.collect.FlattenIterable;
import com.extollit.gaming.ai.path.model.Coords;
import com.extollit.gaming.ai.path.model.INode;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

class SparseSpatialMap<T extends INode> {
    private static final float OUTER_LOAD_FACTOR = 0.9f;
    private final HashMap<CoarseKey, TreeMap<Integer, T>> space;
    private final CoarseKey coarseKey = new CoarseKey();
    private int size;
    private int kx0;
    private int ky0;
    private int kz0;
    private TreeMap<Integer, T> inner0;

    public SparseSpatialMap() {
        this.space = new HashMap(4, 0.9f);
    }

    private int relativeKey(int x, int y, int z) {
        return x & 0xFF | (y & 0xFF) << 8 | (z & 0xFF) << 16;
    }

    public boolean has(int x, int y, int z) {
        Map<Integer, T> inner = this.acquireInner(x, y, z);
        if (inner != null) {
            int relativeKey = this.relativeKey(x, y, z);
            return inner.containsKey(relativeKey);
        }
        return false;
    }

    public boolean has(T value) {
        if (value == null) {
            throw new NullPointerException();
        }
        for (Map map : this.space.values()) {
            if (!map.containsValue(value)) continue;
            return true;
        }
        return false;
    }

    public T get(int x, int y, int z) {
        Map<Integer, T> inner = this.acquireInner(x, y, z);
        if (inner != null) {
            int relativeKey = this.relativeKey(x, y, z);
            return (T)((INode)inner.get(relativeKey));
        }
        return null;
    }

    public T put(int x, int y, int z, T value) {
        INode value0;
        if (value == null) {
            throw new NullPointerException();
        }
        this.kx0 = x;
        this.ky0 = y;
        this.kz0 = z;
        CoarseKey coarseKey = this.coarseKey;
        coarseKey.set(x, y, z);
        this.inner0 = this.space.get(coarseKey);
        TreeMap<Integer, Object> inner = this.inner0;
        if (inner == null) {
            this.inner0 = new TreeMap();
            inner = this.inner0;
            this.space.put(coarseKey.dup(), this.inner0);
        }
        if ((value0 = (INode)inner.put(this.relativeKey(x, y, z), value)) == null) {
            ++this.size;
        }
        return (T)value0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T remove(int x, int y, int z) {
        TreeMap<Integer, T> inner;
        CoarseKey coarseKey = this.coarseKey;
        if (this.inner0 != null && x == this.kx0 && y == this.ky0 && z == this.kz0) {
            inner = this.inner0;
        } else {
            this.kx0 = x;
            this.ky0 = y;
            this.kz0 = z;
            coarseKey.set(x, y, z);
            this.inner0 = this.space.get(coarseKey);
            inner = this.inner0;
        }
        if (inner != null) {
            try {
                int relativeKey = this.relativeKey(x, y, z);
                INode value0 = (INode)inner.remove(relativeKey);
                if (value0 != null) {
                    --this.size;
                }
                INode iNode = value0;
                return (T)iNode;
            }
            finally {
                if (inner.isEmpty()) {
                    this.space.remove(coarseKey);
                    this.inner0 = null;
                }
            }
        }
        return null;
    }

    public void clear() {
        this.space.clear();
        this.size = 0;
        this.inner0 = null;
    }

    public Iterable<T> cullOutside(int x0, int y0, int z0, int xN, int yN, int zN) {
        int size0 = this.size;
        LinkedList<Collection<T>> cullees = new LinkedList<Collection<T>>();
        Iterator<Map.Entry<CoarseKey, TreeMap<Integer, T>>> i = this.space.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<CoarseKey, TreeMap<Integer, T>> entry2 = i.next();
            CoarseKey key = entry2.getKey();
            TreeMap<Integer, T> subMap = entry2.getValue();
            if (key.x >= x0 && key.y >= y0 && key.z >= z0 && key.x <= xN && key.y <= yN && key.z <= zN) continue;
            i.remove();
            cullees.add(subMap.values());
            this.size -= subMap.size();
        }
        if (size0 != this.size) {
            this.inner0 = null;
        }
        return new FlattenIterable(cullees);
    }

    public Set<Coords> keySet() {
        return new KeySet();
    }

    public Collection<T> values() {
        return new ValueCollection();
    }

    private Map<Integer, T> acquireInner(int x, int y, int z) {
        if (this.inner0 != null && this.kx0 == x && this.ky0 == y && this.kz0 == z) {
            return this.inner0;
        }
        this.kx0 = x;
        this.ky0 = y;
        this.kz0 = z;
        CoarseKey coarseKey = this.coarseKey;
        coarseKey.set(x, y, z);
        this.inner0 = this.space.get(coarseKey);
        return this.inner0;
    }

    private final class ValueCollection
    extends AbstractCollection<T> {
        private ValueCollection() {
        }

        @Override
        public Iterator<T> iterator() {
            return new Iter();
        }

        @Override
        public int size() {
            return SparseSpatialMap.this.size;
        }

        private final class Iter
        extends AbstractIterator<T> {
            private Iter() {
            }

            @Override
            protected final T map(T value) {
                return value;
            }
        }
    }

    private final class KeySet
    extends AbstractSet<Coords> {
        private KeySet() {
        }

        @Override
        public Iterator<Coords> iterator() {
            return new Iter();
        }

        @Override
        public int size() {
            return SparseSpatialMap.this.size;
        }

        private final class Iter
        extends AbstractIterator<Coords> {
            private Iter() {
            }

            @Override
            protected final Coords map(T value) {
                return value.coordinates();
            }
        }
    }

    private abstract class AbstractIterator<V>
    extends FilterIterable.Iter<V>
    implements Iterator<V> {
        private Iterator<Map.Entry<CoarseKey, TreeMap<Integer, T>>> oi;
        private Iterator<Map.Entry<Integer, T>> ii;

        public AbstractIterator() {
            this.oi = SparseSpatialMap.this.space.entrySet().iterator();
        }

        @Override
        protected V findNext() {
            Map.Entry<Object, Object> entry2;
            Iterator oi = this.oi;
            Iterator<Map.Entry<Integer, Object>> ii = this.ii;
            while (ii == null || !ii.hasNext()) {
                if (oi.hasNext()) {
                    entry2 = oi.next();
                    this.ii = ((TreeMap)entry2.getValue()).entrySet().iterator();
                    ii = this.ii;
                    continue;
                }
                return null;
            }
            entry2 = ii.next();
            return this.map((INode)entry2.getValue());
        }

        protected abstract V map(T var1);
    }

    private static final class CoarseKey {
        private int x;
        private int y;
        private int z;
        private int hashCode;

        private CoarseKey(int x, int y, int z) {
            this.set(x, y, z);
        }

        CoarseKey() {
        }

        CoarseKey(CoarseKey original) {
            this.x = original.x;
            this.y = original.y;
            this.z = original.z;
            this.hashCode = original.hashCode;
        }

        CoarseKey dup() {
            return new CoarseKey(this);
        }

        void set(int x, int y, int z) {
            this.x = x >>= 3;
            this.y = y >>= 3;
            this.z = z >>= 3;
            int result = 1;
            result = 31 * result + z;
            result = 31 * result + y;
            this.hashCode = result = 31 * result + x;
        }

        public final boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CoarseKey coarseKey = (CoarseKey)o;
            return this.x == coarseKey.x && this.y == coarseKey.y && this.z == coarseKey.z;
        }

        public final int hashCode() {
            return this.hashCode;
        }
    }
}

