/*
 * Decompiled with CFR 0.152.
 */
package com.extollit.gaming.ai.path.model;

import com.extollit.gaming.ai.path.model.Node;
import com.extollit.gaming.ai.path.model.SortedPointQueue;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;

final class TreeTransitional {
    private final Node nextRoot;
    private final Deque<RotateNodeOp> dq;

    public TreeTransitional(Node nextRoot) {
        LinkedList<RotateNodeOp> dq = new LinkedList<RotateNodeOp>();
        this.nextRoot = nextRoot;
        Node curr = this.nextRoot.up();
        byte length = nextRoot.length();
        int newLength0 = 0;
        while (curr != null) {
            Node up = curr.up();
            byte length0 = length;
            length = curr.length();
            curr.orphan();
            curr.dirty(true);
            int dl = newLength0 + (length0 - length) - length;
            dq.add(new RotateNodeOp(curr, dl));
            newLength0 = length + dl;
            curr = up;
        }
        this.dq = dq;
        this.nextRoot.orphan();
    }

    public boolean queue(Node head, Node root) {
        for (RotateNodeOp op : this.dq) {
            if (op.root != root) continue;
            op.heads.add(head);
            return true;
        }
        return false;
    }

    public void finish(SortedPointQueue queue) {
        Deque<RotateNodeOp> dq = this.dq;
        Node prev = this.nextRoot;
        while (!dq.isEmpty()) {
            RotateNodeOp op = dq.pop();
            Node next = op.root;
            next.bindParent(prev);
            for (Node head : op.heads) {
                if (head.dirty()) {
                    queue.addLength(head, op.diff);
                }
                for (Node curr = head.up(); curr != null && curr != next && curr.dirty(); curr = curr.up()) {
                    curr.addLength(op.diff);
                }
                if (!next.dirty()) continue;
                next.addLength(op.diff);
            }
            prev = next;
        }
    }

    private static final class RotateNodeOp {
        public final Node root;
        public final int diff;
        public final List<Node> heads = new LinkedList<Node>();

        public RotateNodeOp(Node root, int diff) {
            this.root = root;
            this.diff = diff;
        }

        public String toString() {
            return this.diff + ": " + this.root;
        }
    }
}

