/*
 * Decompiled with CFR 0.152.
 */
package com.extollit.gaming.ai.path.persistence;

import com.extollit.gaming.ai.path.HydrazinePathFinder;
import com.extollit.gaming.ai.path.model.IInstanceSpace;
import com.extollit.gaming.ai.path.persistence.internal.DummyPathingEntity;
import com.extollit.gaming.ai.path.persistence.internal.ReaderWriters;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.OutputStream;

public class Persistence {
    private static final String TAG = "HPOD";
    private static final byte VERSION = 4;

    public static void persist(HydrazinePathFinder pathFinder, ObjectOutput out) throws IOException {
        ReaderWriters readerWriters = ReaderWriters.forVersion((byte)4);
        out.writeUTF(TAG);
        out.writeByte(4);
        readerWriters.dpe.writePartialObject(pathFinder.subject(), out);
        pathFinder.writeVersioned((byte)4, readerWriters, out);
    }

    public static HydrazinePathFinder restore(ObjectInput in, IInstanceSpace instanceSpace) throws IOException {
        if (!TAG.equals(in.readUTF())) {
            throw new IOException("Not a valid HPOD file");
        }
        byte ver = in.readByte();
        if (ver > 4) {
            throw new IOException("Unsupported version: " + ver);
        }
        ReaderWriters readerWriters = ReaderWriters.forVersion(ver);
        DummyPathingEntity pathingEntity = readerWriters.dpe.readPartialObject(in);
        HydrazinePathFinder pathFinder = new HydrazinePathFinder(pathingEntity, instanceSpace);
        pathFinder.readVersioned(ver, readerWriters, in);
        return pathFinder;
    }

    public static void persist(HydrazinePathFinder pathFinder, String fileName) throws IOException {
        Persistence.persist(pathFinder, new File(fileName));
    }

    public static HydrazinePathFinder restore(String fileName, IInstanceSpace instanceSpace) throws IOException {
        return Persistence.restore(instanceSpace, new File(fileName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void persist(HydrazinePathFinder pathFinder, File file) throws IOException {
        try (FileOutputStream fileOut = new FileOutputStream(file);
             ObjectOutputStream out = new ObjectOutputStream(fileOut);){
            Persistence.persist(pathFinder, out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HydrazinePathFinder restore(IInstanceSpace instanceSpace, File file) throws IOException {
        try (FileInputStream fileIn = new FileInputStream(file);){
            HydrazinePathFinder hydrazinePathFinder = Persistence.restore(fileIn, instanceSpace);
            return hydrazinePathFinder;
        }
    }

    public static void persist(HydrazinePathFinder pathFinder, OutputStream out) throws IOException {
        Persistence.persist(pathFinder, new ObjectOutputStream(out));
    }

    public static HydrazinePathFinder restore(InputStream in, IInstanceSpace instanceSpace) throws IOException {
        return Persistence.restore(new ObjectInputStream(in), instanceSpace);
    }
}

