/*
 * Decompiled with CFR 0.152.
 */
package com.extollit.misc;

import com.extollit.misc.HSL;
import com.extollit.num.IntRange;

public class RGB {
    private static final IntRange COMPONENT_RANGE = new IntRange(0, 255);
    public static final RGB WHITE = new RGB(1.0f, 1.0f, 1.0f);
    public static final RGB DARK_BLUE = new RGB(0.0f, 0.0f, 0.5f);
    public static final RGB BLUE = new RGB(0.0f, 0.0f, 1.0f);
    public static final RGB GRAY = new RGB(0.5f, 0.5f, 0.5f);
    public static final RGB LIGHT_GRAY = new RGB(0.8f, 0.8f, 0.8f);
    public static final RGB DARK_GRAY = new RGB(0.125f, 0.125f, 0.125f);
    public static final RGB RED = new RGB(1.0f, 0.0f, 0.0f);
    public static final RGB BLACK = new RGB(0.0f, 0.0f, 0.0f);
    public static final RGB YELLOW = new RGB(1.0f, 1.0f, 0.0f);
    public static final RGB GREEN = new RGB(0.0f, 1.0f, 0.0f);
    public static final RGB PURPLE = new RGB(0.5f, 0.0f, 1.0f);
    public short red;
    public short green;
    public short blue;

    public static short toShort(float f) {
        return (short)COMPONENT_RANGE.clamp((short)(f * 255.0f));
    }

    protected static float toFloat(short c) {
        return (float)COMPONENT_RANGE.clamp(c) / 255.0f;
    }

    public RGB(float red, float green, float blue) {
        this.red = RGB.toShort(red);
        this.green = RGB.toShort(green);
        this.blue = RGB.toShort(blue);
    }

    private RGB(short red, short green, short blue) {
        this.red = red;
        this.green = green;
        this.blue = blue;
    }

    public RGB(int integer) {
        this.red = (short)(integer >> 16 & 0xFF);
        this.green = (short)(integer >> 8 & 0xFF);
        this.blue = (short)(integer & 0xFF);
    }

    public static RGB fromHSL(float hue, float sat, float light) {
        float q = (double)light < 0.5 ? light * (1.0f + sat) : light + sat - light * sat;
        float p = 2.0f * light - q;
        return new RGB(RGB.channelFromHSL(p, q, hue + 0.33333334f), RGB.channelFromHSL(p, q, hue), RGB.channelFromHSL(p, q, hue - 0.33333334f));
    }

    private static float channelFromHSL(float p, float q, float t) {
        if (t < 0.0f) {
            t += 1.0f;
        }
        if (t > 1.0f) {
            t -= 1.0f;
        }
        if (t < 0.16666667f) {
            return p + (q - p) * 6.0f * t;
        }
        if (t < 0.5f) {
            return q;
        }
        if (t < 0.6666667f) {
            return p + (q - p) * (0.6666667f - t) * 6.0f;
        }
        return p;
    }

    public HSL toHSL() {
        float min;
        float r = this.fred();
        float g = this.fgreen();
        float b = this.fblue();
        float max = r;
        if (g > max) {
            max = g;
        }
        if (b > max) {
            max = b;
        }
        if (g < (min = r)) {
            min = g;
        }
        if (b < min) {
            min = b;
        }
        float chroma = max - min;
        float hue = 0.0f;
        if (chroma != 0.0f) {
            if (max == r) {
                hue = (g - b) / chroma % 6.0f;
            } else if (max == g) {
                hue = (b - r) / chroma + 2.0f;
            } else if (max == b) {
                hue = (r - g) / chroma + 4.0f;
            }
        }
        float lightness = (max + min) / 2.0f;
        return new HSL(hue, chroma == 0.0f ? 0.0f : chroma / (1.0f - Math.abs(2.0f * lightness - 1.0f)), lightness);
    }

    public float fred() {
        return RGB.toFloat(this.red);
    }

    public float fgreen() {
        return RGB.toFloat(this.green);
    }

    public float fblue() {
        return RGB.toFloat(this.blue);
    }

    public void set(float red, float blue, float green) {
        this.red = RGB.toShort(red);
        this.blue = RGB.toShort(blue);
        this.green = RGB.toShort(green);
    }

    protected static short scale(short color, float f) {
        return (short)COMPONENT_RANGE.clamp((int)((float)color * f));
    }

    protected static short brighten(short color, float f) {
        return (short)COMPONENT_RANGE.clamp((int)((float)color + f * 255.0f));
    }

    public RGB brighten(float f) {
        this.red = RGB.brighten(this.red, f);
        this.green = RGB.brighten(this.green, f);
        this.blue = RGB.brighten(this.blue, f);
        return this;
    }

    public RGB scale(float f) {
        this.red = RGB.scale(this.red, f);
        this.green = RGB.scale(this.green, f);
        this.blue = RGB.scale(this.blue, f);
        return this;
    }

    public RGB brightened(float f) {
        return new RGB(RGB.brighten(this.red, f), RGB.brighten(this.green, f), RGB.brighten(this.blue, f));
    }

    public RGB scaled(float f) {
        return new RGB(RGB.scale(this.red, f), RGB.scale(this.green, f), RGB.scale(this.blue, f));
    }

    public int toInt() {
        return 0xFF000000 | (COMPONENT_RANGE.clamp(this.red) & 0xFF) << 16 | (COMPONENT_RANGE.clamp(this.green) & 0xFF) << 8 | COMPONENT_RANGE.clamp(this.blue) & 0xFF;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RGB)) {
            return false;
        }
        RGB rgb = (RGB)o;
        if (this.red != rgb.red) {
            return false;
        }
        if (this.green != rgb.green) {
            return false;
        }
        return this.blue == rgb.blue;
    }

    public int hashCode() {
        int result = this.red;
        result = 31 * result + this.green;
        result = 31 * result + this.blue;
        return result;
    }

    public String toString() {
        return Integer.toString(this.toInt(), 16);
    }

    public static final RGB blend(RGB a, RGB b, float amount) {
        float inv = 1.0f - amount;
        return new RGB((short)((float)a.red * inv + (float)b.red * amount), (short)((float)a.green * inv + (float)b.green * amount), (short)((float)a.blue * inv + (float)b.blue * amount));
    }
}

