/*
 * Decompiled with CFR 0.152.
 */
package com.extollit.tree.oct;

import com.extollit.linalg.immutable.IntAxisAlignedBox;
import com.extollit.linalg.immutable.Vec3i;
import com.extollit.tree.oct.Helper;
import com.extollit.tree.oct.IOctantOperation;
import com.extollit.tree.oct.OctTree;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

final class Octant<T> {
    private Octant<T>[] children;
    private List<OctTree.Entry<T>> entries;

    Octant() {
    }

    public void operation(IOctantOperation<T> op, Vec3i key, com.extollit.linalg.mutable.Vec3i mp, int scale) {
        byte childIndex = Helper.parity(key, mp);
        this.operation(op, childIndex, mp, scale);
    }

    public void operation(IOctantOperation<T> op, com.extollit.linalg.mutable.Vec3i mp, int scale) {
        this.operation(op, (byte)0, mp, scale);
        this.operation(op, (byte)1, mp, scale);
        this.operation(op, (byte)2, mp, scale);
        this.operation(op, (byte)3, mp, scale);
        this.operation(op, (byte)4, mp, scale);
        this.operation(op, (byte)5, mp, scale);
        this.operation(op, (byte)6, mp, scale);
        this.operation(op, (byte)7, mp, scale);
    }

    public void operation(IOctantOperation<T> op, IntAxisAlignedBox key, com.extollit.linalg.mutable.Vec3i mp, int scale) {
        com.extollit.linalg.mutable.Vec3i p = new com.extollit.linalg.mutable.Vec3i(key.min);
        boolean[] flagged = new boolean[8];
        flagged[Helper.parity((com.extollit.linalg.mutable.Vec3i)p, (com.extollit.linalg.mutable.Vec3i)mp)] = true;
        p.x = key.max.x;
        flagged[Helper.parity((com.extollit.linalg.mutable.Vec3i)p, (com.extollit.linalg.mutable.Vec3i)mp)] = true;
        p.x = key.min.x;
        p.y = key.max.y;
        flagged[Helper.parity((com.extollit.linalg.mutable.Vec3i)p, (com.extollit.linalg.mutable.Vec3i)mp)] = true;
        p.x = key.max.x;
        flagged[Helper.parity((com.extollit.linalg.mutable.Vec3i)p, (com.extollit.linalg.mutable.Vec3i)mp)] = true;
        p.x = key.min.x;
        p.y = key.min.y;
        p.z = key.max.z;
        flagged[Helper.parity((com.extollit.linalg.mutable.Vec3i)p, (com.extollit.linalg.mutable.Vec3i)mp)] = true;
        p.x = key.max.x;
        flagged[Helper.parity((com.extollit.linalg.mutable.Vec3i)p, (com.extollit.linalg.mutable.Vec3i)mp)] = true;
        p.x = key.min.x;
        p.y = key.max.y;
        flagged[Helper.parity((com.extollit.linalg.mutable.Vec3i)p, (com.extollit.linalg.mutable.Vec3i)mp)] = true;
        p.x = key.max.x;
        flagged[Helper.parity((com.extollit.linalg.mutable.Vec3i)p, (com.extollit.linalg.mutable.Vec3i)mp)] = true;
        if (flagged[0]) {
            this.operation(op, (byte)0, mp, scale);
        }
        if (flagged[1]) {
            this.operation(op, (byte)1, mp, scale);
        }
        if (flagged[2]) {
            this.operation(op, (byte)2, mp, scale);
        }
        if (flagged[3]) {
            this.operation(op, (byte)3, mp, scale);
        }
        if (flagged[4]) {
            this.operation(op, (byte)4, mp, scale);
        }
        if (flagged[5]) {
            this.operation(op, (byte)5, mp, scale);
        }
        if (flagged[6]) {
            this.operation(op, (byte)6, mp, scale);
        }
        if (flagged[7]) {
            this.operation(op, (byte)7, mp, scale);
        }
    }

    private void operation(IOctantOperation<T> operation, byte parity, com.extollit.linalg.mutable.Vec3i mp, int scale) {
        int halfScale = scale >> 1;
        int[] offs = new int[]{-halfScale, halfScale};
        int i = parity >> 0 & 1;
        int j = parity >> 1 & 1;
        int k = parity >> 2 & 1;
        mp.x += offs[i];
        mp.y += offs[j];
        mp.z += offs[k];
        operation.child(this, parity, mp, halfScale);
        mp.x -= offs[i];
        mp.y -= offs[j];
        mp.z -= offs[k];
    }

    public Octant<T> autoChild(int parity) {
        if (this.children == null) {
            this.children = new Octant[8];
        }
        if (this.children[parity] == null) {
            this.children[parity] = new Octant<T>();
            return this.children[parity];
        }
        return this.children[parity];
    }

    public Octant<T> child(int parity) {
        return this.children == null ? null : (this.children[parity] == null ? null : this.children[parity]);
    }

    public void add(OctTree.Entry<T> entry2) {
        if (this.entries == null) {
            this.entries = new LinkedList<OctTree.Entry<T>>();
        }
        this.entries.add(entry2);
    }

    public Iterable<OctTree.Entry<T>> entries() {
        return this.entries == null ? Collections.emptyList() : this.entries;
    }
}

