/*
 * Decompiled with CFR 0.152.
 */
package com.typewritermc.roadnetwork.pathfinding;

import com.extollit.gaming.ai.path.model.ColumnarOcclusionFieldList;
import com.extollit.gaming.ai.path.model.IColumnarSpace;
import com.extollit.gaming.ai.path.model.IInstanceSpace;
import com.typewritermc.core.utils.point.Position;
import com.typewritermc.core.utils.point.World;
import com.typewritermc.roadnetwork.pathfinding.PFBlock;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.ChunkSnapshot;
import org.bukkit.Material;
import org.bukkit.block.data.BlockData;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0011H\u0016J\u0006\u0010\u0014\u001a\u00020\u0015J \u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0011H\u0016J\b\u0010\u0017\u001a\u00020\u000bH\u0016J\b\u0010\u0006\u001a\u00020\u0007H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/typewritermc/roadnetwork/pathfinding/PFColumnarSpace;", "Lcom/extollit/gaming/ai/path/model/IColumnarSpace;", "world", "Lcom/typewritermc/core/utils/point/World;", "snapshot", "Lorg/bukkit/ChunkSnapshot;", "instance", "Lcom/extollit/gaming/ai/path/model/IInstanceSpace;", "<init>", "(Lcom/typewritermc/core/utils/point/World;Lorg/bukkit/ChunkSnapshot;Lcom/extollit/gaming/ai/path/model/IInstanceSpace;)V", "occlusionFieldList", "Lcom/extollit/gaming/ai/path/model/ColumnarOcclusionFieldList;", "lastAccess", "", "blockAt", "Lcom/typewritermc/roadnetwork/pathfinding/PFBlock;", "x", "", "y", "z", "refresh", "", "metaDataAt", "occlusionFields", "RoadNetworkExtension"})
public final class PFColumnarSpace
implements IColumnarSpace {
    @NotNull
    private final World world;
    @NotNull
    private final ChunkSnapshot snapshot;
    @NotNull
    private final IInstanceSpace instance;
    @NotNull
    private final ColumnarOcclusionFieldList occlusionFieldList;
    private long lastAccess;

    public PFColumnarSpace(@NotNull World world, @NotNull ChunkSnapshot snapshot, @NotNull IInstanceSpace instance) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)snapshot, (String)"snapshot");
        Intrinsics.checkNotNullParameter((Object)instance, (String)"instance");
        this.world = world;
        this.snapshot = snapshot;
        this.instance = instance;
        this.occlusionFieldList = new ColumnarOcclusionFieldList(this);
        this.lastAccess = System.currentTimeMillis();
    }

    @Override
    @NotNull
    public PFBlock blockAt(int x, int y, int z) {
        this.lastAccess = System.currentTimeMillis();
        Position position = new Position(this.world, (double)x, (double)y, (double)z, 0.0f, 0.0f);
        Material material = this.snapshot.getBlockType(x, y, z);
        Intrinsics.checkNotNullExpressionValue((Object)material, (String)"getBlockType(...)");
        BlockData blockData = this.snapshot.getBlockData(x, y, z);
        Intrinsics.checkNotNullExpressionValue((Object)blockData, (String)"getBlockData(...)");
        return new PFBlock(position, material, blockData);
    }

    public final boolean refresh() {
        return System.currentTimeMillis() - this.lastAccess < 60000L;
    }

    @Override
    public int metaDataAt(int x, int y, int z) {
        return 0;
    }

    @Override
    @NotNull
    public ColumnarOcclusionFieldList occlusionFields() {
        return this.occlusionFieldList;
    }

    @Override
    @NotNull
    public IInstanceSpace instance() {
        return this.instance;
    }
}

