/*
 * Decompiled with CFR 0.152.
 */
package com.typewritermc.basic.entries.audience;

import com.typewritermc.core.entries.Ref;
import com.typewritermc.engine.paper.entry.entries.AudienceFilter;
import com.typewritermc.engine.paper.entry.entries.AudienceFilterEntry;
import com.typewritermc.engine.paper.entry.entries.TickableDisplay;
import com.typewritermc.engine.paper.entry.entries.Var;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b&\u0018\u00002\u00020\u00012\u00020\u0002B%\u0012\u000e\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0004\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u001a\u001a\u00020\u0019H\u0016J\u0010\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u001c\u001a\u00020\u0019H\u0004J\b\u0010\u001d\u001a\u00020\u0019H$R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR \u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001e"}, d2={"Lcom/typewritermc/basic/entries/audience/CappedAudienceFilter;", "Lcom/typewritermc/engine/paper/entry/entries/AudienceFilter;", "Lcom/typewritermc/engine/paper/entry/entries/TickableDisplay;", "ref", "Lcom/typewritermc/core/entries/Ref;", "Lcom/typewritermc/engine/paper/entry/entries/AudienceFilterEntry;", "capacity", "Lcom/typewritermc/engine/paper/entry/entries/Var;", "", "<init>", "(Lcom/typewritermc/core/entries/Ref;Lcom/typewritermc/engine/paper/entry/entries/Var;)V", "getCapacity", "()Lcom/typewritermc/engine/paper/entry/entries/Var;", "candidates", "", "Ljava/util/UUID;", "getCandidates", "()Ljava/util/List;", "setCandidates", "(Ljava/util/List;)V", "filter", "", "player", "Lorg/bukkit/entity/Player;", "onPlayerAdd", "", "tick", "onPlayerRemove", "refreshCandidates", "updateCandidates", "BasicExtension"})
@SourceDebugExtension(value={"SMAP\nCappedAudience.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CappedAudience.kt\ncom/typewritermc/basic/entries/audience/CappedAudienceFilter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,48:1\n1869#2,2:49\n*S KotlinDebug\n*F\n+ 1 CappedAudience.kt\ncom/typewritermc/basic/entries/audience/CappedAudienceFilter\n*L\n44#1:49,2\n*E\n"})
public abstract class CappedAudienceFilter
extends AudienceFilter
implements TickableDisplay {
    @NotNull
    private final Var<Integer> capacity;
    @NotNull
    private List<UUID> candidates;

    public CappedAudienceFilter(@NotNull Ref<? extends AudienceFilterEntry> ref, @NotNull Var<Integer> capacity) {
        Intrinsics.checkNotNullParameter(ref, (String)"ref");
        Intrinsics.checkNotNullParameter(capacity, (String)"capacity");
        super(ref);
        this.capacity = capacity;
        this.candidates = CollectionsKt.emptyList();
    }

    @NotNull
    public final Var<Integer> getCapacity() {
        return this.capacity;
    }

    @NotNull
    protected final List<UUID> getCandidates() {
        return this.candidates;
    }

    protected final void setCandidates(@NotNull List<UUID> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.candidates = list;
    }

    public boolean filter(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return this.candidates.contains(player.getUniqueId());
    }

    public void onPlayerAdd(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        this.refreshCandidates();
        super.onPlayerAdd(player);
    }

    public void tick() {
        List players = this.getConsideredPlayers();
        int targetCapacity = ((Number)Var.get$default(this.capacity, (Player)((Player)CollectionsKt.random((Collection)players, (Random)((Random)Random.Default))), null, (int)2, null)).intValue();
        if (targetCapacity < this.candidates.size()) {
            this.refreshCandidates();
        }
        if (targetCapacity > this.candidates.size() && players.size() > this.candidates.size()) {
            this.refreshCandidates();
        }
    }

    public void onPlayerRemove(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        super.onPlayerRemove(player);
        this.refreshCandidates();
    }

    protected final void refreshCandidates() {
        this.updateCandidates();
        Iterable $this$forEach$iv = this.getConsideredPlayers();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Player it = (Player)element$iv;
            boolean bl = false;
            this.refresh(it);
        }
    }

    protected abstract void updateCandidates();
}

