/*
 * Decompiled with CFR 0.152.
 */
package com.typewritermc.basic.entries.audience;

import com.typewritermc.basic.entries.audience.CappedAudienceFilter;
import com.typewritermc.basic.entries.audience.Ordering;
import com.typewritermc.core.entries.Ref;
import com.typewritermc.engine.paper.entry.entries.AudienceFilterEntry;
import com.typewritermc.engine.paper.entry.entries.ReadableFactEntry;
import com.typewritermc.engine.paper.entry.entries.Var;
import com.typewritermc.engine.paper.facts.FactListenerSubscription;
import com.typewritermc.engine.paper.facts.FactTrackerKt;
import com.typewritermc.engine.paper.facts.FactUpdateContext;
import com.typewritermc.engine.paper.utils.ServerExtensionsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B;\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0003\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u0019\u001a\u00020\u0014H\u0014J\b\u0010\u001a\u001a\u00020\u0014H\u0016R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00070\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00120\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/typewritermc/basic/entries/audience/FactValueCappedAudienceFilter;", "Lcom/typewritermc/basic/entries/audience/CappedAudienceFilter;", "ref", "Lcom/typewritermc/core/entries/Ref;", "Lcom/typewritermc/engine/paper/entry/entries/AudienceFilterEntry;", "capacity", "Lcom/typewritermc/engine/paper/entry/entries/Var;", "", "fact", "Lcom/typewritermc/engine/paper/entry/entries/ReadableFactEntry;", "ordering", "Lcom/typewritermc/basic/entries/audience/Ordering;", "<init>", "(Lcom/typewritermc/core/entries/Ref;Lcom/typewritermc/engine/paper/entry/entries/Var;Lcom/typewritermc/core/entries/Ref;Lcom/typewritermc/basic/entries/audience/Ordering;)V", "factValues", "Ljava/util/concurrent/ConcurrentHashMap;", "Ljava/util/UUID;", "factListeners", "Lcom/typewritermc/engine/paper/facts/FactListenerSubscription;", "onPlayerAdd", "", "player", "Lorg/bukkit/entity/Player;", "onPlayerRemove", "updateFactValue", "updateCandidates", "dispose", "BasicExtension"})
@SourceDebugExtension(value={"SMAP\nFactValueCappedAudience.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FactValueCappedAudience.kt\ncom/typewritermc/basic/entries/audience/FactValueCappedAudienceFilter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,102:1\n1869#2,2:103\n1563#2:105\n1634#2,3:106\n1056#2:109\n1068#2:110\n216#3:111\n217#3:113\n1#4:112\n*S KotlinDebug\n*F\n+ 1 FactValueCappedAudience.kt\ncom/typewritermc/basic/entries/audience/FactValueCappedAudienceFilter\n*L\n81#1:103,2\n84#1:105\n84#1:106,3\n87#1:109\n88#1:110\n96#1:111\n96#1:113\n*E\n"})
public final class FactValueCappedAudienceFilter
extends CappedAudienceFilter {
    @NotNull
    private final Ref<ReadableFactEntry> fact;
    @NotNull
    private final Ordering ordering;
    @NotNull
    private final ConcurrentHashMap<UUID, Integer> factValues;
    @NotNull
    private final ConcurrentHashMap<UUID, FactListenerSubscription> factListeners;

    public FactValueCappedAudienceFilter(@NotNull Ref<? extends AudienceFilterEntry> ref, @NotNull Var<Integer> capacity, @NotNull Ref<ReadableFactEntry> fact, @NotNull Ordering ordering) {
        Intrinsics.checkNotNullParameter(ref, (String)"ref");
        Intrinsics.checkNotNullParameter(capacity, (String)"capacity");
        Intrinsics.checkNotNullParameter(fact, (String)"fact");
        Intrinsics.checkNotNullParameter((Object)((Object)ordering), (String)"ordering");
        super(ref, capacity);
        this.fact = fact;
        this.ordering = ordering;
        this.factValues = new ConcurrentHashMap();
        this.factListeners = new ConcurrentHashMap();
    }

    @Override
    public void onPlayerAdd(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        this.updateFactValue(player);
        ((Map)this.factListeners).put(player.getUniqueId(), FactTrackerKt.listenForFacts((Player)player, (List)CollectionsKt.listOf(this.fact), arg_0 -> FactValueCappedAudienceFilter.onPlayerAdd$lambda$0(this, arg_0)));
        super.onPlayerAdd(player);
    }

    @Override
    public void onPlayerRemove(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        super.onPlayerRemove(player);
        FactListenerSubscription factListenerSubscription = this.factListeners.remove(player.getUniqueId());
        if (factListenerSubscription != null) {
            factListenerSubscription.cancel(player);
        }
        this.factValues.remove(player.getUniqueId());
    }

    private final void updateFactValue(Player player) {
        ReadableFactEntry factEntry = (ReadableFactEntry)this.fact.get();
        Map map2 = this.factValues;
        UUID uUID = player.getUniqueId();
        ReadableFactEntry readableFactEntry = factEntry;
        Integer n = readableFactEntry != null && (readableFactEntry = readableFactEntry.readForPlayersGroup(player)) != null ? readableFactEntry.getValue() : 0;
        map2.put(uUID, n);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void updateCandidates() {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        List players = this.getConsideredPlayers();
        Player player = (Player)CollectionsKt.firstOrNull((List)players);
        if (player == null) {
            return;
        }
        int cap = RangesKt.coerceAtLeast((int)((Number)Var.get$default(this.getCapacity(), (Player)player, null, (int)2, null)).intValue(), (int)0);
        Iterable $this$forEach$iv = this.getConsideredPlayers();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Player it = (Player)element$iv;
            boolean bl = false;
            this.updateFactValue(it);
        }
        $this$forEach$iv = this.getConsideredPlayers();
        FactValueCappedAudienceFilter factValueCappedAudienceFilter = this;
        boolean $i$f$map22 = false;
        Iterator iterator = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Player player2 = (Player)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getUniqueId());
        }
        List $i$f$map22 = (List)destination$iv$iv;
        boolean bl = false;
        factValueCappedAudienceFilter.setCandidates(CollectionsKt.take((Iterable)(switch (WhenMappings.$EnumSwitchMapping$0[this.ordering.ordinal()]) {
            case 1 -> {
                void uuids;
                Iterable $this$sortedBy$iv = (Iterable)uuids;
                boolean $i$f$sortedBy = false;
                yield CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(this){
                    final /* synthetic */ FactValueCappedAudienceFilter this$0;
                    {
                        this.this$0 = factValueCappedAudienceFilter;
                    }

                    public final int compare(T a, T b) {
                        boolean bl;
                        Integer default$iv;
                        boolean bl2;
                        ConcurrentMap $this$getOrPut$iv;
                        UUID it = (UUID)a;
                        boolean bl3 = false;
                        ConcurrentMap concurrentMap = FactValueCappedAudienceFilter.access$getFactValues$p(this.this$0);
                        UUID key$iv = it;
                        boolean $i$f$getOrPut = false;
                        Object object = $this$getOrPut$iv.get(key$iv);
                        if (object == null) {
                            bl2 = false;
                            default$iv = 0;
                            bl = false;
                            object = $this$getOrPut$iv.putIfAbsent(key$iv, default$iv);
                            if (object == null) {
                                object = default$iv;
                            }
                        }
                        it = (UUID)b;
                        Comparable comparable = (Integer)object;
                        bl3 = false;
                        $this$getOrPut$iv = FactValueCappedAudienceFilter.access$getFactValues$p(this.this$0);
                        key$iv = it;
                        $i$f$getOrPut = false;
                        Object object2 = $this$getOrPut$iv.get(key$iv);
                        if (object2 == null) {
                            bl2 = false;
                            default$iv = 0;
                            bl = false;
                            object2 = $this$getOrPut$iv.putIfAbsent(key$iv, default$iv);
                            if (object2 == null) {
                                object2 = default$iv;
                            }
                        }
                        return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)((Integer)object2));
                    }
                });
            }
            case 2 -> {
                void uuids;
                Iterable $this$sortedByDescending$iv = (Iterable)uuids;
                boolean $i$f$sortedByDescending = false;
                yield CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(this){
                    final /* synthetic */ FactValueCappedAudienceFilter this$0;
                    {
                        this.this$0 = factValueCappedAudienceFilter;
                    }

                    public final int compare(T a, T b) {
                        boolean bl;
                        Integer default$iv;
                        boolean bl2;
                        ConcurrentMap $this$getOrPut$iv;
                        UUID it = (UUID)b;
                        boolean bl3 = false;
                        ConcurrentMap concurrentMap = FactValueCappedAudienceFilter.access$getFactValues$p(this.this$0);
                        UUID key$iv = it;
                        boolean $i$f$getOrPut = false;
                        Object object = $this$getOrPut$iv.get(key$iv);
                        if (object == null) {
                            bl2 = false;
                            default$iv = 0;
                            bl = false;
                            object = $this$getOrPut$iv.putIfAbsent(key$iv, default$iv);
                            if (object == null) {
                                object = default$iv;
                            }
                        }
                        it = (UUID)a;
                        Comparable comparable = (Integer)object;
                        bl3 = false;
                        $this$getOrPut$iv = FactValueCappedAudienceFilter.access$getFactValues$p(this.this$0);
                        key$iv = it;
                        $i$f$getOrPut = false;
                        Object object2 = $this$getOrPut$iv.get(key$iv);
                        if (object2 == null) {
                            bl2 = false;
                            default$iv = 0;
                            bl = false;
                            object2 = $this$getOrPut$iv.putIfAbsent(key$iv, default$iv);
                            if (object2 == null) {
                                object2 = default$iv;
                            }
                        }
                        return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)((Integer)object2));
                    }
                });
            }
            default -> throw new NoWhenBranchMatchedException();
        }), (int)cap));
    }

    public void dispose() {
        super.dispose();
        Map $this$forEach$iv = this.factListeners;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Player it;
            Map.Entry element$iv;
            Map.Entry entry2 = element$iv = iterator.next();
            boolean bl = false;
            UUID uuid = (UUID)entry2.getKey();
            FactListenerSubscription subscription = (FactListenerSubscription)entry2.getValue();
            if (ServerExtensionsKt.getServer().getPlayer(uuid) == null) continue;
            boolean bl2 = false;
            subscription.cancel(it);
        }
        this.factListeners.clear();
        this.factValues.clear();
    }

    private static final Unit onPlayerAdd$lambda$0(FactValueCappedAudienceFilter this$0, FactUpdateContext $this$listenForFacts) {
        Intrinsics.checkNotNullParameter((Object)$this$listenForFacts, (String)"$this$listenForFacts");
        this$0.updateFactValue($this$listenForFacts.getPlayer());
        this$0.refreshCandidates();
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ ConcurrentHashMap access$getFactValues$p(FactValueCappedAudienceFilter $this) {
        return $this.factValues;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Ordering.values().length];
            try {
                nArray[Ordering.SMALLEST.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Ordering.LARGEST.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

