/*
 * Decompiled with CFR 0.152.
 */
package com.typewritermc.basic.entries.audience;

import com.mthaler.aparser.arithmetic.Context;
import com.mthaler.aparser.arithmetic.EvalKt;
import com.mthaler.aparser.arithmetic.Expr;
import com.mthaler.aparser.arithmetic.Expression;
import com.mthaler.aparser.arithmetic.TrigonometricUnit;
import com.mthaler.aparser.util.Result;
import com.mthaler.aparser.util.Try;
import com.typewritermc.basic.entries.audience.ExperienceAudienceEntry;
import com.typewritermc.basic.entries.audience.ExperienceLevel;
import com.typewritermc.core.entries.Ref;
import com.typewritermc.engine.paper.TypewriterPaperPluginKt;
import com.typewritermc.engine.paper.entry.audience.PlayerSingleDisplay;
import com.typewritermc.engine.paper.entry.audience.SingleFilter;
import com.typewritermc.engine.paper.entry.entries.TickableDisplay;
import com.typewritermc.engine.paper.entry.entries.Var;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.ClosedFloatingPointRange;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KClass;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003BM\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0018\u0010\u0006\u001a\u0014\u0012\u0010\b\u0001\u0012\f\u0012\u0004\u0012\u00020\u0002\u0012\u0002\b\u00030\b0\u0007\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\n\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u001aH\u0016J\b\u0010\u001c\u001a\u00020\u001aH\u0016J\b\u0010\u001d\u001a\u00020\u001aH\u0016J\b\u0010\u001e\u001a\u00020\u001aH\u0002J\u0010\u0010\u001f\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\r2\u0006\u0010 \u001a\u00020\rH\u0002R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0014\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0015R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/typewritermc/basic/entries/audience/PlayerExpDisplay;", "Lcom/typewritermc/engine/paper/entry/audience/PlayerSingleDisplay;", "Lcom/typewritermc/basic/entries/audience/ExperienceAudienceEntry;", "Lcom/typewritermc/engine/paper/entry/entries/TickableDisplay;", "player", "Lorg/bukkit/entity/Player;", "displayKClass", "Lkotlin/reflect/KClass;", "Lcom/typewritermc/engine/paper/entry/audience/SingleFilter;", "current", "Lcom/typewritermc/core/entries/Ref;", "experience", "Lcom/typewritermc/engine/paper/entry/entries/Var;", "", "levelRequirement", "", "<init>", "(Lorg/bukkit/entity/Player;Lkotlin/reflect/KClass;Lcom/typewritermc/core/entries/Ref;Lcom/typewritermc/engine/paper/entry/entries/Var;Ljava/lang/String;)V", "originalExperienceLevel", "Lcom/typewritermc/basic/entries/audience/ExperienceLevel;", "currentExperience", "Ljava/lang/Integer;", "expression", "Lcom/mthaler/aparser/util/Result;", "Lcom/mthaler/aparser/arithmetic/Expr;", "initialize", "", "setup", "tick", "dispose", "updateLevel", "calculateLevel", "level", "BasicExtension"})
final class PlayerExpDisplay
extends PlayerSingleDisplay<ExperienceAudienceEntry>
implements TickableDisplay {
    @NotNull
    private final Var<Integer> experience;
    @NotNull
    private final String levelRequirement;
    @Nullable
    private ExperienceLevel originalExperienceLevel;
    @Nullable
    private Integer currentExperience;
    @NotNull
    private final Result<Expr> expression;

    public PlayerExpDisplay(@NotNull Player player, @NotNull KClass<? extends SingleFilter<ExperienceAudienceEntry, ?>> displayKClass, @NotNull Ref<ExperienceAudienceEntry> current, @NotNull Var<Integer> experience, @NotNull String levelRequirement) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter(displayKClass, (String)"displayKClass");
        Intrinsics.checkNotNullParameter(current, (String)"current");
        Intrinsics.checkNotNullParameter(experience, (String)"experience");
        Intrinsics.checkNotNullParameter((Object)levelRequirement, (String)"levelRequirement");
        super(player, displayKClass, current);
        this.experience = experience;
        this.levelRequirement = levelRequirement;
        this.expression = Expression.INSTANCE.invoke(this.levelRequirement);
    }

    public void initialize() {
        this.originalExperienceLevel = new ExperienceLevel(this.getPlayer().getExp(), this.getPlayer().getLevel());
        super.initialize();
    }

    public void setup() {
        super.setup();
        this.updateLevel();
    }

    public void tick() {
        this.updateLevel();
    }

    public void dispose() {
        block0: {
            super.dispose();
            ExperienceLevel experienceLevel = this.originalExperienceLevel;
            if (experienceLevel == null) break block0;
            ExperienceLevel old = experienceLevel;
            boolean bl = false;
            this.getPlayer().setExp(old.getExp());
            this.getPlayer().setLevel(old.getLevel());
        }
    }

    private final void updateLevel() {
        int exp;
        Integer n = this.currentExperience;
        if (n != null && (exp = ((Number)Var.get$default(this.experience, (Player)this.getPlayer(), null, (int)2, null)).intValue()) == n) {
            return;
        }
        this.currentExperience = exp;
        ExperienceLevel level = this.calculateLevel(exp);
        this.getPlayer().setExp(level.getExp());
        this.getPlayer().setLevel(level.getLevel());
    }

    private final ExperienceLevel calculateLevel(int experience) {
        int levelRequirement = this.levelRequirement(1);
        if (experience < levelRequirement) {
            float progress = (float)experience / (float)levelRequirement;
            return new ExperienceLevel(((Number)((Object)RangesKt.coerceIn((Comparable)Float.valueOf(progress), (ClosedFloatingPointRange)RangesKt.rangeTo((float)0.0f, (float)1.0f)))).floatValue(), 0);
        }
        int lower = 1;
        int upper = 2;
        while (this.levelRequirement(upper) <= experience) {
            lower = upper;
            upper *= 2;
        }
        while (lower < upper - 1) {
            int mid = (lower + upper) / 2;
            if (this.levelRequirement(mid) <= experience) {
                lower = mid;
                continue;
            }
            upper = mid;
        }
        int currentLevelExp = this.levelRequirement(lower);
        int nextLevelExp = this.levelRequirement(lower + 1);
        float progress = (float)(experience - currentLevelExp) / (float)(nextLevelExp - currentLevelExp);
        return new ExperienceLevel(((Number)((Object)RangesKt.coerceIn((Comparable)Float.valueOf(progress), (ClosedFloatingPointRange)RangesKt.rangeTo((float)0.0f, (float)1.0f)))).floatValue(), RangesKt.coerceAtLeast((int)lower, (int)1));
    }

    private final int levelRequirement(int level) {
        Context context = new Context(TrigonometricUnit.Rad, MapsKt.mapOf((Pair)new Pair((Object)"L", (Object)level)));
        Try<Double> expressionResult = EvalKt.tryEval(this.expression, context);
        if (!(expressionResult instanceof Try.Success)) {
            if (expressionResult instanceof Try.Failure) {
                TypewriterPaperPluginKt.getLogger().warning("Could not evaluate expression '" + this.levelRequirement + "' for player for level " + level);
                return 1;
            }
            throw new NoWhenBranchMatchedException();
        }
        return (int)((Number)((Try.Success)expressionResult).getValue()).doubleValue();
    }
}

