/*
 * Decompiled with CFR 0.152.
 */
package com.typewritermc.basic.entries.dialogue;

import com.typewritermc.basic.entries.dialogue.Filter;
import com.typewritermc.basic.entries.dialogue.FilterInputContextKeys;
import com.typewritermc.basic.entries.dialogue.FilterResult;
import com.typewritermc.basic.entries.dialogue.InputDialogueEntry;
import com.typewritermc.basic.entries.dialogue.InputDialogueEntryKt;
import com.typewritermc.core.entries.Ref;
import com.typewritermc.core.extension.annotations.ContextKeys;
import com.typewritermc.core.extension.annotations.Entry;
import com.typewritermc.core.extension.annotations.Help;
import com.typewritermc.core.interaction.InteractionContext;
import com.typewritermc.core.utils.ResultKt;
import com.typewritermc.engine.paper.entry.Criteria;
import com.typewritermc.engine.paper.entry.Modifier;
import com.typewritermc.engine.paper.entry.TriggerEntryKt;
import com.typewritermc.engine.paper.entry.TriggerableEntry;
import com.typewritermc.engine.paper.entry.dialogue.DialogueMessenger;
import com.typewritermc.engine.paper.entry.entries.ConstVar;
import com.typewritermc.engine.paper.entry.entries.EventTrigger;
import com.typewritermc.engine.paper.entry.entries.SpeakerEntry;
import com.typewritermc.engine.paper.entry.entries.Var;
import com.typewritermc.engine.paper.extensions.placeholderapi.PlaceholderExpansionKt;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

@Entry(name="filter_input_dialogue", description="An input dialogue which excepts a filter", color="#0abab5", icon="fa6-solid:keyboard")
@ContextKeys(klass=FilterInputContextKeys.class)
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0097\u0001\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0006\u0012\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u0012\u000e\b\u0002\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\u000e\u0012\u000e\b\u0002\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u000e\u0012\u000e\b\u0002\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u0006\u0012\u001a\b\u0002\u0010\u0013\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u000b0\u00060\u0014\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u001c\u0010*\u001a\u0006\u0012\u0002\b\u00030+2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0019R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001cR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010!R\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u001cR.\u0010\u0013\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u000b0\u00060\u00148\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b$\u0010%\u001a\u0004\b&\u0010'R \u0010(\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u000b0\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010\u001c\u00a8\u00060"}, d2={"Lcom/typewritermc/basic/entries/dialogue/FilterInputDialogueEntry;", "Lcom/typewritermc/basic/entries/dialogue/InputDialogueEntry;", "id", "", "name", "criteria", "", "Lcom/typewritermc/engine/paper/entry/Criteria;", "modifiers", "Lcom/typewritermc/engine/paper/entry/Modifier;", "speaker", "Lcom/typewritermc/core/entries/Ref;", "Lcom/typewritermc/engine/paper/entry/entries/SpeakerEntry;", "text", "Lcom/typewritermc/engine/paper/entry/entries/Var;", "duration", "Ljava/time/Duration;", "filters", "Lcom/typewritermc/basic/entries/dialogue/Filter;", "incorrectTriggers", "Ljava/util/Optional;", "Lcom/typewritermc/engine/paper/entry/TriggerableEntry;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Ljava/util/List;Lcom/typewritermc/core/entries/Ref;Lcom/typewritermc/engine/paper/entry/entries/Var;Lcom/typewritermc/engine/paper/entry/entries/Var;Ljava/util/List;Ljava/util/Optional;)V", "getId", "()Ljava/lang/String;", "getName", "getCriteria", "()Ljava/util/List;", "getModifiers", "getSpeaker", "()Lcom/typewritermc/core/entries/Ref;", "getText", "()Lcom/typewritermc/engine/paper/entry/entries/Var;", "getDuration", "getFilters", "getIncorrectTriggers$annotations", "()V", "getIncorrectTriggers", "()Ljava/util/Optional;", "triggers", "getTriggers", "messenger", "Lcom/typewritermc/engine/paper/entry/dialogue/DialogueMessenger;", "player", "Lorg/bukkit/entity/Player;", "context", "Lcom/typewritermc/core/interaction/InteractionContext;", "BasicExtension"})
@SourceDebugExtension(value={"SMAP\nInputDialogueEntry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InputDialogueEntry.kt\ncom/typewritermc/basic/entries/dialogue/FilterInputDialogueEntry\n+ 2 EntryReference.kt\ncom/typewritermc/core/entries/EntryReferenceKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,249:1\n6#2:250\n295#3,2:251\n*S KotlinDebug\n*F\n+ 1 InputDialogueEntry.kt\ncom/typewritermc/basic/entries/dialogue/FilterInputDialogueEntry\n*L\n121#1:250\n146#1:251,2\n*E\n"})
public final class FilterInputDialogueEntry
implements InputDialogueEntry {
    @NotNull
    private final String id;
    @NotNull
    private final String name;
    @NotNull
    private final List<Criteria> criteria;
    @NotNull
    private final List<Modifier> modifiers;
    @NotNull
    private final Ref<SpeakerEntry> speaker;
    @NotNull
    private final Var<String> text;
    @NotNull
    private final Var<Duration> duration;
    @NotNull
    private final List<Filter> filters;
    @NotNull
    private final Optional<List<Ref<TriggerableEntry>>> incorrectTriggers;

    public FilterInputDialogueEntry(@NotNull String id, @NotNull String name, @NotNull List<Criteria> criteria, @NotNull List<Modifier> modifiers, @NotNull Ref<SpeakerEntry> speaker, @NotNull Var<String> text, @NotNull Var<Duration> duration, @NotNull List<Filter> filters, @NotNull Optional<List<Ref<TriggerableEntry>>> incorrectTriggers) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(criteria, (String)"criteria");
        Intrinsics.checkNotNullParameter(modifiers, (String)"modifiers");
        Intrinsics.checkNotNullParameter(speaker, (String)"speaker");
        Intrinsics.checkNotNullParameter(text, (String)"text");
        Intrinsics.checkNotNullParameter(duration, (String)"duration");
        Intrinsics.checkNotNullParameter(filters, (String)"filters");
        Intrinsics.checkNotNullParameter(incorrectTriggers, (String)"incorrectTriggers");
        this.id = id;
        this.name = name;
        this.criteria = criteria;
        this.modifiers = modifiers;
        this.speaker = speaker;
        this.text = text;
        this.duration = duration;
        this.filters = filters;
        this.incorrectTriggers = incorrectTriggers;
    }

    public /* synthetic */ FilterInputDialogueEntry(String string, String string2, List list, List list2, Ref ref, Var var, Var var2, List list3, Optional optional2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "";
        }
        if ((n & 2) != 0) {
            string2 = "";
        }
        if ((n & 4) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 8) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        if ((n & 0x10) != 0) {
            boolean $i$f$emptyRef = false;
            ref = new Ref("", Reflection.getOrCreateKotlinClass(SpeakerEntry.class), null, 4, null);
        }
        if ((n & 0x20) != 0) {
            var = (Var)new ConstVar((Object)"");
        }
        if ((n & 0x40) != 0) {
            Duration duration = Duration.ZERO;
            Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ZERO");
            var2 = (Var)new ConstVar((Object)duration);
        }
        if ((n & 0x80) != 0) {
            list3 = CollectionsKt.emptyList();
        }
        if ((n & 0x100) != 0) {
            Optional<List<Ref<TriggerableEntry>>> optional3 = Optional.empty();
            Intrinsics.checkNotNullExpressionValue(optional3, (String)"empty(...)");
            optional2 = optional3;
        }
        this(string, string2, list, list2, (Ref<SpeakerEntry>)ref, (Var<String>)var, (Var<Duration>)var2, list3, optional2);
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public List<Criteria> getCriteria() {
        return this.criteria;
    }

    @NotNull
    public List<Modifier> getModifiers() {
        return this.modifiers;
    }

    @NotNull
    public Ref<SpeakerEntry> getSpeaker() {
        return this.speaker;
    }

    @Override
    @NotNull
    public Var<String> getText() {
        return this.text;
    }

    @Override
    @NotNull
    public Var<Duration> getDuration() {
        return this.duration;
    }

    @NotNull
    public final List<Filter> getFilters() {
        return this.filters;
    }

    @NotNull
    public final Optional<List<Ref<TriggerableEntry>>> getIncorrectTriggers() {
        return this.incorrectTriggers;
    }

    @Help(text="Triggers if none of the filters are matched. If not set, the user must match at a filter.")
    public static /* synthetic */ void getIncorrectTriggers$annotations() {
    }

    @NotNull
    public List<Ref<TriggerableEntry>> getTriggers() {
        return CollectionsKt.emptyList();
    }

    @NotNull
    public DialogueMessenger<?> messenger(@NotNull Player player, @NotNull InteractionContext context) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        FilterInputContextKeys filterInputContextKeys = FilterInputContextKeys.FILTER;
        return InputDialogueEntryKt.access$advancedMessenger(player, context, this, filterInputContextKeys, arg_0 -> FilterInputDialogueEntry.messenger$lambda$0(this, arg_0), FilterInputDialogueEntry::messenger$lambda$1, arg_0 -> FilterInputDialogueEntry.messenger$lambda$3(this, player, arg_0));
    }

    @NotNull
    public Var<String> getSpeakerDisplayName() {
        return InputDialogueEntry.super.getSpeakerDisplayName();
    }

    @NotNull
    public List<EventTrigger> getEventTriggers() {
        return InputDialogueEntry.super.getEventTriggers();
    }

    private static final List messenger$lambda$0(FilterInputDialogueEntry this$0, FilterResult filterResult) {
        if (filterResult == null) {
            List<Ref<TriggerableEntry>> list = this$0.incorrectTriggers.orElse(CollectionsKt.emptyList());
            Intrinsics.checkNotNullExpressionValue(list, (String)"orElse(...)");
            return TriggerEntryKt.getEventTriggers(list);
        }
        Filter filter = filterResult.getFilter();
        if (filter != null) {
            return TriggerEntryKt.getEventTriggers(filter.getTriggers());
        }
        List<Ref<TriggerableEntry>> list = this$0.incorrectTriggers.orElse(CollectionsKt.emptyList());
        Intrinsics.checkNotNullExpressionValue(list, (String)"orElse(...)");
        return TriggerEntryKt.getEventTriggers(list);
    }

    private static final String messenger$lambda$1(FilterResult it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getProvided();
    }

    private static final Result messenger$lambda$3(FilterInputDialogueEntry this$0, Player $player, String input) {
        Object v0;
        block3: {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            Iterable $this$firstOrNull$iv = this$0.filters;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Filter it = (Filter)element$iv;
                boolean bl = false;
                CharSequence charSequence = input;
                if (!new Regex(PlaceholderExpansionKt.parsePlaceholders((String)it.getInput(), (Player)$player)).matches(charSequence)) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        Filter filter = v0;
        if (filter != null) {
            return Result.box-impl((Object)ResultKt.ok((Object)new FilterResult(input, filter)));
        }
        if (this$0.incorrectTriggers.isPresent()) {
            return Result.box-impl((Object)ResultKt.ok((Object)new FilterResult(input, null)));
        }
        return Result.box-impl((Object)ResultKt.failure((String)InputDialogueEntryKt.access$getFilterInputNotMatchedMessage()));
    }

    public FilterInputDialogueEntry() {
        this(null, null, null, null, null, null, null, null, null, 511, null);
    }
}

