/*
 * Decompiled with CFR 0.152.
 */
package com.typewritermc.basic.entries.dialogue.messengers.actionbar;

import com.typewritermc.basic.entries.dialogue.ActionBarDialogueEntry;
import com.typewritermc.basic.entries.dialogue.messengers.actionbar.JavaActionBarDialogueDialogueMessengerKt;
import com.typewritermc.core.interaction.InteractionContext;
import com.typewritermc.engine.paper.entry.dialogue.ConfirmationKeyHandler;
import com.typewritermc.engine.paper.entry.dialogue.ConfirmationKeyKt;
import com.typewritermc.engine.paper.entry.dialogue.DialogueMessenger;
import com.typewritermc.engine.paper.entry.dialogue.MessengerState;
import com.typewritermc.engine.paper.entry.dialogue.TickContext;
import com.typewritermc.engine.paper.entry.dialogue.TypeDurationKt;
import com.typewritermc.engine.paper.entry.dialogue.TypingDurationType;
import com.typewritermc.engine.paper.entry.entries.DialogueEntry;
import com.typewritermc.engine.paper.entry.entries.Var;
import com.typewritermc.engine.paper.extensions.placeholderapi.PlaceholderExpansionKt;
import com.typewritermc.engine.paper.interaction.ActionBarBlockerKt;
import com.typewritermc.engine.paper.interaction.ChatHistory;
import com.typewritermc.engine.paper.interaction.ChatHistoryHandlerKt;
import com.typewritermc.engine.paper.utils.ExtensionsKt;
import com.typewritermc.engine.paper.utils.MiniMessagesKt;
import java.time.Duration;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0002\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u0005\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u001bH\u0016J\b\u0010\u001f\u001a\u00020\u001bH\u0016R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0012\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u00148V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019\u00a8\u0006 "}, d2={"Lcom/typewritermc/basic/entries/dialogue/messengers/actionbar/JavaActionBarDialogueDialogueMessenger;", "Lcom/typewritermc/engine/paper/entry/dialogue/DialogueMessenger;", "Lcom/typewritermc/basic/entries/dialogue/ActionBarDialogueEntry;", "player", "Lorg/bukkit/entity/Player;", "context", "Lcom/typewritermc/core/interaction/InteractionContext;", "entry", "<init>", "(Lorg/bukkit/entity/Player;Lcom/typewritermc/core/interaction/InteractionContext;Lcom/typewritermc/basic/entries/dialogue/ActionBarDialogueEntry;)V", "confirmationKeyHandler", "Lcom/typewritermc/engine/paper/entry/dialogue/ConfirmationKeyHandler;", "speakerDisplayName", "", "text", "typingDuration", "Ljava/time/Duration;", "kotlin.jvm.PlatformType", "playTime", "value", "", "animationComplete", "getAnimationComplete", "()Z", "setAnimationComplete", "(Z)V", "init", "", "tick", "Lcom/typewritermc/engine/paper/entry/dialogue/TickContext;", "end", "dispose", "BasicExtension"})
public final class JavaActionBarDialogueDialogueMessenger
extends DialogueMessenger<ActionBarDialogueEntry> {
    @Nullable
    private ConfirmationKeyHandler confirmationKeyHandler;
    @NotNull
    private String speakerDisplayName;
    @NotNull
    private String text;
    private Duration typingDuration;
    private Duration playTime;

    public JavaActionBarDialogueDialogueMessenger(@NotNull Player player, @NotNull InteractionContext context, @NotNull ActionBarDialogueEntry entry2) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)entry2, (String)"entry");
        super(player, context, (DialogueEntry)entry2);
        this.speakerDisplayName = "";
        this.text = "";
        this.typingDuration = Duration.ZERO;
        this.playTime = Duration.ZERO;
    }

    public boolean getAnimationComplete() {
        return this.playTime.compareTo(this.typingDuration) >= 0;
    }

    public void setAnimationComplete(boolean value) {
        this.playTime = !value ? Duration.ZERO : this.typingDuration;
    }

    public void init() {
        super.init();
        this.speakerDisplayName = PlaceholderExpansionKt.parsePlaceholders((String)((String)Var.get$default(((ActionBarDialogueEntry)this.getEntry()).getSpeakerDisplayName(), (Player)this.getPlayer(), null, (int)2, null)), (Player)this.getPlayer());
        this.text = PlaceholderExpansionKt.parsePlaceholders((String)((String)Var.get$default(((ActionBarDialogueEntry)this.getEntry()).getText(), (Player)this.getPlayer(), null, (int)2, null)), (Player)this.getPlayer());
        this.typingDuration = TypeDurationKt.getTypingDurationType().totalDuration(MiniMessagesKt.stripped((String)this.text), (Duration)Var.get$default(((ActionBarDialogueEntry)this.getEntry()).getDuration(), (Player)this.getPlayer(), null, (int)2, null));
        this.confirmationKeyHandler = ConfirmationKeyKt.getConfirmationKey().handler(this.getPlayer(), () -> JavaActionBarDialogueDialogueMessenger.init$lambda$0(this));
        ChatHistory.resendMessages$default((ChatHistory)ChatHistoryHandlerKt.getChatHistory((Player)this.getPlayer()), (Player)this.getPlayer(), (boolean)false, (int)2, null);
    }

    public void tick(@NotNull TickContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (this.getState() != MessengerState.RUNNING) {
            return;
        }
        this.playTime = this.playTime.plus(context.getDeltaTime());
        String rawText = MiniMessagesKt.stripped((String)this.text);
        TypingDurationType typingDurationType = TypeDurationKt.getTypingDurationType();
        Duration duration = this.playTime;
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"playTime");
        double percentage = typingDurationType.calculatePercentage(duration, (Duration)Var.get$default(((ActionBarDialogueEntry)this.getEntry()).getDuration(), (Player)this.getPlayer(), null, (int)2, null), rawText);
        if (percentage > 1.1) {
            Duration duration2 = this.playTime;
            Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"playTime");
            if (ExtensionsKt.toTicks((Duration)duration2) % (long)40 > 0L) {
                return;
            }
        }
        Component message = MiniMessagesKt.splitPercentage((Component)MiniMessagesKt.asMini((String)this.text), (double)percentage);
        int paddingSize = MiniMessagesKt.stripped((String)this.text).length() - MiniMessagesKt.plainText((Component)message).length();
        String padding = StringsKt.repeat((CharSequence)" ", (int)paddingSize);
        String string = JavaActionBarDialogueDialogueMessengerKt.access$getActionBarFormat();
        TagResolver[] tagResolverArray = new TagResolver[3];
        Intrinsics.checkNotNullExpressionValue((Object)Placeholder.parsed((String)"speaker", (String)this.speakerDisplayName), (String)"parsed(...)");
        Intrinsics.checkNotNullExpressionValue((Object)Placeholder.component((String)"message", (ComponentLike)((ComponentLike)message)), (String)"component(...)");
        Intrinsics.checkNotNullExpressionValue((Object)Placeholder.unparsed((String)"padding", (String)padding), (String)"unparsed(...)");
        Component component = MiniMessagesKt.asMiniWithResolvers((String)string, (TagResolver[])tagResolverArray);
        ActionBarBlockerKt.acceptActionBarMessage((Player)this.getPlayer(), (Component)component);
        this.getPlayer().sendActionBar(component);
    }

    public void end() {
    }

    public void dispose() {
        super.dispose();
        TextComponent textComponent = Component.empty();
        Intrinsics.checkNotNullExpressionValue((Object)textComponent, (String)"empty(...)");
        TextComponent component = textComponent;
        ActionBarBlockerKt.acceptActionBarMessage((Player)this.getPlayer(), (Component)((Component)component));
        this.getPlayer().sendActionBar((Component)component);
        ConfirmationKeyHandler confirmationKeyHandler = this.confirmationKeyHandler;
        if (confirmationKeyHandler != null) {
            confirmationKeyHandler.dispose();
        }
        this.confirmationKeyHandler = null;
    }

    private static final Unit init$lambda$0(JavaActionBarDialogueDialogueMessenger this$0) {
        this$0.completeOrFinish();
        return Unit.INSTANCE;
    }
}

