/*
 * Decompiled with CFR 0.152.
 */
package com.typewritermc.basic.entries.static.factspreset.entries;

import com.typewritermc.basic.entries.static.factspreset.FactsPresetApplier;
import com.typewritermc.basic.entries.static.factspreset.FactsPresetApplierState;
import com.typewritermc.basic.entries.static.factspreset.FactsPresetEntry;
import com.typewritermc.basic.entries.static.factspreset.FactsPresetSerializer;
import com.typewritermc.basic.entries.static.factspreset.entries.StageFactsPresetEntry;
import com.typewritermc.basic.entries.static.factspreset.entries.StageFactsPresetEntryKt;
import com.typewritermc.core.entries.Ref;
import com.typewritermc.core.utils.LoopingKt;
import com.typewritermc.engine.paper.entry.dialogue.ConfirmationKeyHandler;
import com.typewritermc.engine.paper.entry.dialogue.ConfirmationKeyKt;
import com.typewritermc.engine.paper.entry.dialogue.TickContext;
import com.typewritermc.engine.paper.facts.FactsModifier;
import com.typewritermc.engine.paper.interaction.ChatHistory;
import com.typewritermc.engine.paper.interaction.ChatHistoryHandlerKt;
import com.typewritermc.engine.paper.utils.ExtensionsKt;
import com.typewritermc.engine.paper.utils.MiniMessagesKt;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.JoinConfiguration;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0017H\u0002J\u0010\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u001bH\u0003J\u0010\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020\u0017H\u0002J\b\u0010 \u001a\u00020!H\u0002J\b\u0010\"\u001a\u00020\u0017H\u0016R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00120\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006#"}, d2={"Lcom/typewritermc/basic/entries/static/factspreset/entries/StageFactsPresetApplier;", "Lcom/typewritermc/basic/entries/static/factspreset/FactsPresetApplier;", "Lcom/typewritermc/basic/entries/static/factspreset/entries/StageFactsPresetEntry;", "player", "Lorg/bukkit/entity/Player;", "entry", "modifier", "Lcom/typewritermc/engine/paper/facts/FactsModifier;", "serializer", "Lcom/typewritermc/basic/entries/static/factspreset/FactsPresetSerializer;", "<init>", "(Lorg/bukkit/entity/Player;Lcom/typewritermc/basic/entries/static/factspreset/entries/StageFactsPresetEntry;Lcom/typewritermc/engine/paper/facts/FactsModifier;Lcom/typewritermc/basic/entries/static/factspreset/FactsPresetSerializer;)V", "confirmationKeyHandler", "Lcom/typewritermc/engine/paper/entry/dialogue/ConfirmationKeyHandler;", "currentIndex", "", "appliedChildren", "", "Lcom/typewritermc/core/entries/Ref;", "Lcom/typewritermc/basic/entries/static/factspreset/FactsPresetEntry;", "getAppliedChildren", "()Ljava/util/List;", "init", "", "handleConfirmation", "onPlayerItemHeld", "event", "Lorg/bukkit/event/player/PlayerItemHeldEvent;", "tick", "context", "Lcom/typewritermc/engine/paper/entry/dialogue/TickContext;", "displayMessage", "formatOptions", "Lnet/kyori/adventure/text/Component;", "dispose", "BasicExtension"})
public final class StageFactsPresetApplier
extends FactsPresetApplier<StageFactsPresetEntry> {
    @Nullable
    private ConfirmationKeyHandler confirmationKeyHandler;
    private int currentIndex;

    public StageFactsPresetApplier(@NotNull Player player, @NotNull StageFactsPresetEntry entry2, @NotNull FactsModifier modifier, @NotNull FactsPresetSerializer serializer) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)entry2, (String)"entry");
        Intrinsics.checkNotNullParameter((Object)modifier, (String)"modifier");
        Intrinsics.checkNotNullParameter((Object)serializer, (String)"serializer");
        super(player, (FactsPresetEntry)entry2, modifier, serializer);
    }

    @Override
    @NotNull
    public List<Ref<FactsPresetEntry>> getAppliedChildren() {
        return CollectionsKt.take((Iterable)((StageFactsPresetEntry)this.getEntry()).getChildren(), (int)(this.currentIndex + 1));
    }

    @Override
    public void init() {
        Integer deserialization;
        super.init();
        if (((StageFactsPresetEntry)this.getEntry()).getChildren().isEmpty()) {
            this.setState(FactsPresetApplierState.FINISHED);
            return;
        }
        String string = this.getSerializer().pop();
        Integer n = deserialization = string != null ? StringsKt.toIntOrNull((String)string) : null;
        if (deserialization != null) {
            this.currentIndex = deserialization;
            this.setState(FactsPresetApplierState.FINISHED);
            return;
        }
        ChatHistoryHandlerKt.startBlockingMessages((Player)this.getPlayer());
        this.confirmationKeyHandler = ConfirmationKeyKt.getConfirmationKey().handler(this.getPlayer(), () -> StageFactsPresetApplier.init$lambda$0(this));
        this.displayMessage();
    }

    private final void handleConfirmation() {
        if (this.getState() != FactsPresetApplierState.RUNNING) {
            return;
        }
        this.setState(FactsPresetApplierState.FINISHED);
    }

    @EventHandler
    private final void onPlayerItemHeld(PlayerItemHeldEvent event) {
        int newIndex;
        if (!Intrinsics.areEqual((Object)event.getPlayer().getUniqueId(), (Object)this.getPlayer().getUniqueId())) {
            return;
        }
        int curSlot = event.getPreviousSlot();
        int newSlot = event.getNewSlot();
        int dif = LoopingKt.loopingDistance((int)curSlot, (int)newSlot, (int)8);
        int index = this.currentIndex;
        event.setCancelled(true);
        for (newIndex = (index + dif) % ((StageFactsPresetEntry)this.getEntry()).getChildren().size(); newIndex < 0; newIndex += ((StageFactsPresetEntry)this.getEntry()).getChildren().size()) {
        }
        this.currentIndex = newIndex;
        this.displayMessage();
    }

    @Override
    public void tick(@NotNull TickContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super.tick(context);
        if (this.getState() != FactsPresetApplierState.RUNNING) {
            return;
        }
        if (ExtensionsKt.toTicks((Duration)context.getPlayTime()) % (long)100 > 0L) {
            return;
        }
        this.displayMessage();
    }

    private final void displayMessage() {
        String string = StageFactsPresetEntryKt.access$getStageFormat();
        TagResolver[] tagResolverArray = new TagResolver[1];
        Intrinsics.checkNotNullExpressionValue((Object)Placeholder.component((String)"options", (ComponentLike)((ComponentLike)this.formatOptions())), (String)"component(...)");
        Component message = MiniMessagesKt.asMiniWithResolvers((String)string, (TagResolver[])tagResolverArray);
        Component component = ChatHistory.composeDarkMessage$default((ChatHistory)ChatHistoryHandlerKt.getChatHistory((Player)this.getPlayer()), (Component)message, (boolean)false, (int)2, null);
        this.getPlayer().sendMessage(component);
    }

    private final Component formatOptions() {
        List around = LoopingKt.around(((StageFactsPresetEntry)this.getEntry()).getChildren(), (int)this.currentIndex, (int)1, (int)2);
        List lines = new ArrayList();
        int maxOptions = Math.min(4, around.size());
        for (int i = 0; i < maxOptions; ++i) {
            Ref option = (Ref)around.get(i);
            int actualIndex = ((StageFactsPresetEntry)this.getEntry()).getChildren().indexOf(option);
            boolean isCurrent = actualIndex == this.currentIndex;
            boolean isSelected = actualIndex <= this.currentIndex;
            String prefix = isCurrent ? StageFactsPresetEntryKt.access$getStageCurrentPrefix() : (isSelected ? StageFactsPresetEntryKt.access$getStageSelectedPrefix() : (i == 0 && this.currentIndex > 1 && ((StageFactsPresetEntry)this.getEntry()).getChildren().size() > 4 ? StageFactsPresetEntryKt.access$getStageUpPrefix() : (i == 3 && this.currentIndex < ((StageFactsPresetEntry)this.getEntry()).getChildren().size() - 3 && ((StageFactsPresetEntry)this.getEntry()).getChildren().size() > 4 ? StageFactsPresetEntryKt.access$getStageDownPrefix() : StageFactsPresetEntryKt.access$getStageUnselectedPrefix())));
            String format = isCurrent ? StageFactsPresetEntryKt.access$getStageCurrentOption() : (isSelected ? StageFactsPresetEntryKt.access$getStageSelectedOption() : StageFactsPresetEntryKt.access$getStageUnselectedOption());
            Collection collection = lines;
            TagResolver[] tagResolverArray = new TagResolver[2];
            Intrinsics.checkNotNullExpressionValue((Object)Placeholder.parsed((String)"prefix", (String)prefix), (String)"parsed(...)");
            Object object = (FactsPresetEntry)option.get();
            if (object == null || (object = object.getName()) == null || (object = com.typewritermc.core.utils.ExtensionsKt.getFormatted((String)object)) == null) {
                object = "<gray>Unknown";
            }
            Intrinsics.checkNotNullExpressionValue((Object)Placeholder.parsed((String)"option_text", (String)object), (String)"parsed(...)");
            collection.add(MiniMessagesKt.asMiniWithResolvers((String)format, (TagResolver[])tagResolverArray));
        }
        Component component = Component.join((JoinConfiguration)JoinConfiguration.noSeparators(), (Iterable)lines);
        Intrinsics.checkNotNullExpressionValue((Object)component, (String)"join(...)");
        return component;
    }

    @Override
    public void dispose() {
        this.getSerializer().push(String.valueOf(this.currentIndex));
        ConfirmationKeyHandler confirmationKeyHandler = this.confirmationKeyHandler;
        if (confirmationKeyHandler != null) {
            confirmationKeyHandler.dispose();
        }
        ChatHistoryHandlerKt.stopBlockingMessages((Player)this.getPlayer());
        ChatHistory.resendMessages$default((ChatHistory)ChatHistoryHandlerKt.getChatHistory((Player)this.getPlayer()), (Player)this.getPlayer(), (boolean)false, (int)2, null);
        super.dispose();
    }

    private static final Unit init$lambda$0(StageFactsPresetApplier this$0) {
        this$0.handleConfirmation();
        return Unit.INSTANCE;
    }
}

