/*
 * Decompiled with CFR 0.152.
 */
package com.typewritermc.basic.entries.variables;

import com.typewritermc.basic.entries.variables.DurationVariableData;
import com.typewritermc.basic.entries.variables.TemporalUnit;
import com.typewritermc.core.exceptions.ContextDataNotFoundException;
import com.typewritermc.core.extension.annotations.Entry;
import com.typewritermc.core.extension.annotations.GenericConstraint;
import com.typewritermc.core.extension.annotations.VariableData;
import com.typewritermc.engine.paper.entry.entries.VarContext;
import com.typewritermc.engine.paper.entry.entries.VariableEntry;
import com.typewritermc.engine.paper.entry.entries.VariableEntryKt;
import com.typewritermc.engine.paper.utils.ServerExtensionsKt;
import java.time.Duration;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Entry(name="duration_variable", description="Converts a numeric value and unit into a Duration", color="#4CAF50", icon="material-symbols:timer-rounded")
@GenericConstraint(type=Duration.class)
@VariableData(type=DurationVariableData.class)
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u001b\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J%\u0010\n\u001a\u0002H\u000b\"\b\b\u0000\u0010\u000b*\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u000eH\u0016\u00a2\u0006\u0002\u0010\u000fR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0010"}, d2={"Lcom/typewritermc/basic/entries/variables/DurationVariable;", "Lcom/typewritermc/engine/paper/entry/entries/VariableEntry;", "id", "", "name", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getId", "()Ljava/lang/String;", "getName", "get", "T", "", "context", "Lcom/typewritermc/engine/paper/entry/entries/VarContext;", "(Lcom/typewritermc/engine/paper/entry/entries/VarContext;)Ljava/lang/Object;", "BasicExtension"})
@SourceDebugExtension(value={"SMAP\nDurationVariable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DurationVariable.kt\ncom/typewritermc/basic/entries/variables/DurationVariable\n+ 2 VariableEntry.kt\ncom/typewritermc/engine/paper/entry/entries/VariableEntryKt\n*L\n1#1,58:1\n39#2:59\n*S KotlinDebug\n*F\n+ 1 DurationVariable.kt\ncom/typewritermc/basic/entries/variables/DurationVariable\n*L\n26#1:59\n*E\n"})
public final class DurationVariable
implements VariableEntry {
    @NotNull
    private final String id;
    @NotNull
    private final String name;

    public DurationVariable(@NotNull String id, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.id = id;
        this.name = name;
    }

    public /* synthetic */ DurationVariable(String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "";
        }
        if ((n & 2) != 0) {
            string2 = "";
        }
        this(string, string2);
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public <T> T get(@NotNull VarContext<T> context) {
        Duration duration;
        Intrinsics.checkNotNullParameter(context, (String)"context");
        VarContext<T> $this$getData$iv = context;
        boolean $i$f$getData = false;
        DurationVariableData durationVariableData = (DurationVariableData)$this$getData$iv.getData(DurationVariableData.class);
        if (durationVariableData == null) {
            throw new ContextDataNotFoundException(context.getKlass(), (Object)context.getData(), this.getId());
        }
        DurationVariableData data = durationVariableData;
        int amount = ((Number)data.getAmount().get(context.getPlayer(), context.getInteractionContext())).intValue();
        switch (WhenMappings.$EnumSwitchMapping$0[data.getUnit().ordinal()]) {
            case 1: {
                Duration duration2 = Duration.ofMillis(amount);
                duration = duration2;
                Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofMillis(...)");
                break;
            }
            case 2: {
                Duration duration3 = Duration.ofSeconds(amount);
                duration = duration3;
                Intrinsics.checkNotNullExpressionValue((Object)duration3, (String)"ofSeconds(...)");
                break;
            }
            case 3: {
                Duration duration4 = Duration.ofMinutes(amount);
                duration = duration4;
                Intrinsics.checkNotNullExpressionValue((Object)duration4, (String)"ofMinutes(...)");
                break;
            }
            case 4: {
                Duration duration5 = Duration.ofHours(amount);
                duration = duration5;
                Intrinsics.checkNotNullExpressionValue((Object)duration5, (String)"ofHours(...)");
                break;
            }
            case 5: {
                Duration duration6 = Duration.ofDays(amount);
                duration = duration6;
                Intrinsics.checkNotNullExpressionValue((Object)duration6, (String)"ofDays(...)");
                break;
            }
            case 6: {
                Duration duration7 = Duration.ofMillis((long)amount * ServerExtensionsKt.getTICK_MS());
                duration = duration7;
                Intrinsics.checkNotNullExpressionValue((Object)duration7, (String)"ofMillis(...)");
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        Duration duration8 = duration;
        return (T)VariableEntryKt.cast(context, (Object)duration8);
    }

    public DurationVariable() {
        this(null, null, 3, null);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TemporalUnit.values().length];
            try {
                nArray[TemporalUnit.MILLISECONDS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TemporalUnit.SECONDS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TemporalUnit.MINUTES.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TemporalUnit.HOURS.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TemporalUnit.DAYS.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TemporalUnit.TICKS.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

