/*
 * Decompiled with CFR 0.152.
 */
package com.typewritermc.basic.entries.variables;

import com.typewritermc.basic.entries.variables.OriginPositionVariableData;
import com.typewritermc.core.exceptions.ContextDataNotFoundException;
import com.typewritermc.core.extension.annotations.Entry;
import com.typewritermc.core.extension.annotations.GenericConstraint;
import com.typewritermc.core.extension.annotations.VariableData;
import com.typewritermc.core.utils.point.Coordinate;
import com.typewritermc.core.utils.point.Position;
import com.typewritermc.core.utils.point.Vector;
import com.typewritermc.engine.paper.entry.entries.VarContext;
import com.typewritermc.engine.paper.entry.entries.VariableEntry;
import com.typewritermc.engine.paper.entry.entries.VariableEntryKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

@Entry(name="origin_position_variable", description="Rotates the position around an origin", color="#4CAF50", icon="solar:map-point-wave-bold")
@GenericConstraint.Container(value={@GenericConstraint(type=Position.class), @GenericConstraint(type=Coordinate.class), @GenericConstraint(type=Vector.class)})
@VariableData(type=OriginPositionVariableData.class)
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u001b\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J%\u0010\n\u001a\u0002H\u000b\"\b\b\u0000\u0010\u000b*\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u000eH\u0016\u00a2\u0006\u0002\u0010\u000fJ\u0014\u0010\u0010\u001a\u00020\u0011*\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0014\u0010\u0014\u001a\u00020\u0011*\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0013H\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0016"}, d2={"Lcom/typewritermc/basic/entries/variables/OriginPositionVariable;", "Lcom/typewritermc/engine/paper/entry/entries/VariableEntry;", "id", "", "name", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getId", "()Ljava/lang/String;", "getName", "get", "T", "", "context", "Lcom/typewritermc/engine/paper/entry/entries/VarContext;", "(Lcom/typewritermc/engine/paper/entry/entries/VarContext;)Ljava/lang/Object;", "rotateAroundY", "Lcom/typewritermc/core/utils/point/Vector;", "yawDegrees", "", "rotateAroundX", "pitchDegrees", "BasicExtension"})
@SourceDebugExtension(value={"SMAP\nOriginPositionVariable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OriginPositionVariable.kt\ncom/typewritermc/basic/entries/variables/OriginPositionVariable\n+ 2 VariableEntry.kt\ncom/typewritermc/engine/paper/entry/entries/VariableEntryKt\n*L\n1#1,108:1\n39#2:109\n*S KotlinDebug\n*F\n+ 1 OriginPositionVariable.kt\ncom/typewritermc/basic/entries/variables/OriginPositionVariable\n*L\n40#1:109\n*E\n"})
public final class OriginPositionVariable
implements VariableEntry {
    @NotNull
    private final String id;
    @NotNull
    private final String name;

    public OriginPositionVariable(@NotNull String id, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.id = id;
        this.name = name;
    }

    public /* synthetic */ OriginPositionVariable(String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "";
        }
        if ((n & 2) != 0) {
            string2 = "";
        }
        this(string, string2);
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public <T> T get(@NotNull VarContext<T> context) {
        Intrinsics.checkNotNullParameter(context, (String)"context");
        Player player = context.getPlayer();
        VarContext<T> $this$getData$iv = context;
        boolean $i$f$getData = false;
        OriginPositionVariableData originPositionVariableData = (OriginPositionVariableData)$this$getData$iv.getData(OriginPositionVariableData.class);
        if (originPositionVariableData == null) {
            throw new ContextDataNotFoundException(context.getKlass(), (Object)context.getData(), null, 4, null);
        }
        OriginPositionVariableData data = originPositionVariableData;
        Position origin = (Position)data.getOrigin().get(player, context.getInteractionContext());
        Coordinate relative = (Coordinate)data.getRelative().get(player, context.getInteractionContext());
        Vector rotatedVector = new Vector(relative.getX(), relative.getY(), relative.getZ());
        if (data.getRotationAxis().getYaw()) {
            rotatedVector = this.rotateAroundY(rotatedVector, origin.getYaw());
        }
        if (data.getRotationAxis().getPitch()) {
            rotatedVector = this.rotateAroundX(rotatedVector, origin.getPitch());
        }
        Position finalPosition = new Position(origin.getWorld(), origin.getX() + rotatedVector.getX(), origin.getY() + rotatedVector.getY(), origin.getZ() + rotatedVector.getZ(), (data.getRotationAxis().getYaw() ? origin.getYaw() : 0.0f) + relative.getYaw(), (data.getRotationAxis().getPitch() ? origin.getPitch() : 0.0f) + relative.getPitch());
        Object object = VariableEntryKt.safeCast(context, (Object)finalPosition);
        if (object == null) {
            throw new IllegalStateException("Could not cast position to " + context.getKlass() + ", OriginPositionVariable is only compatible with Position/Coordinate/Vector fields");
        }
        return (T)object;
    }

    private final Vector rotateAroundY(Vector $this$rotateAroundY, float yawDegrees) {
        double yawRadians = Math.toRadians(yawDegrees);
        double cos = Math.cos(yawRadians);
        double sin = Math.sin(yawRadians);
        return new Vector($this$rotateAroundY.getX() * cos - $this$rotateAroundY.getZ() * sin, $this$rotateAroundY.getY(), $this$rotateAroundY.getX() * sin + $this$rotateAroundY.getZ() * cos);
    }

    private final Vector rotateAroundX(Vector $this$rotateAroundX, float pitchDegrees) {
        double pitchRadians = Math.toRadians(pitchDegrees);
        double cos = Math.cos(pitchRadians);
        double sin = Math.sin(pitchRadians);
        return new Vector($this$rotateAroundX.getX(), $this$rotateAroundX.getY() * cos - $this$rotateAroundX.getZ() * sin, $this$rotateAroundX.getY() * sin + $this$rotateAroundX.getZ() * cos);
    }

    public OriginPositionVariable() {
        this(null, null, 3, null);
    }
}

