/*
 * Decompiled with CFR 0.152.
 */
package com.typewritermc.entity.entries.activity;

import com.typewritermc.core.entries.Ref;
import com.typewritermc.core.extension.annotations.Default;
import com.typewritermc.core.extension.annotations.Entry;
import com.typewritermc.core.extension.annotations.Help;
import com.typewritermc.engine.paper.entry.entity.ActivityContext;
import com.typewritermc.engine.paper.entry.entity.EntityActivity;
import com.typewritermc.engine.paper.entry.entity.IndividualActivityContext;
import com.typewritermc.engine.paper.entry.entity.PositionProperty;
import com.typewritermc.engine.paper.entry.entity.SharedActivityContext;
import com.typewritermc.engine.paper.entry.entries.EntityActivityEntry;
import com.typewritermc.engine.paper.entry.entries.GenericEntityActivityEntry;
import com.typewritermc.entity.entries.activity.AmbientSound;
import com.typewritermc.entity.entries.activity.AmbientSoundActivity;
import java.time.Duration;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Entry(name="ambient_sound_activity", description="Play an ambient sound for an entity", color="#3366CC", icon="mingcute:shuffle-2-fill")
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001BM\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0010\b\u0002\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\f\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020 H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\"\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018R\u0019\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006!"}, d2={"Lcom/typewritermc/entity/entries/activity/AmbientSoundActivityEntry;", "Lcom/typewritermc/engine/paper/entry/entries/GenericEntityActivityEntry;", "id", "", "name", "sounds", "", "Lcom/typewritermc/entity/entries/activity/AmbientSound;", "delay", "Lkotlin/ranges/ClosedRange;", "Ljava/time/Duration;", "activity", "Lcom/typewritermc/core/entries/Ref;", "Lcom/typewritermc/engine/paper/entry/entries/EntityActivityEntry;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Lkotlin/ranges/ClosedRange;Lcom/typewritermc/core/entries/Ref;)V", "getId", "()Ljava/lang/String;", "getName", "getSounds", "()Ljava/util/List;", "getDelay$annotations", "()V", "getDelay", "()Lkotlin/ranges/ClosedRange;", "getActivity", "()Lcom/typewritermc/core/entries/Ref;", "create", "Lcom/typewritermc/engine/paper/entry/entity/EntityActivity;", "Lcom/typewritermc/engine/paper/entry/entity/ActivityContext;", "context", "currentLocation", "Lcom/typewritermc/engine/paper/entry/entity/PositionProperty;", "EntityExtension"})
@SourceDebugExtension(value={"SMAP\nAmbientSoundActivity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AmbientSoundActivity.kt\ncom/typewritermc/entity/entries/activity/AmbientSoundActivityEntry\n+ 2 EntryReference.kt\ncom/typewritermc/core/entries/EntryReferenceKt\n*L\n1#1,90:1\n6#2:91\n*S KotlinDebug\n*F\n+ 1 AmbientSoundActivity.kt\ncom/typewritermc/entity/entries/activity/AmbientSoundActivityEntry\n*L\n40#1:91\n*E\n"})
public final class AmbientSoundActivityEntry
implements GenericEntityActivityEntry {
    @NotNull
    private final String id;
    @NotNull
    private final String name;
    @NotNull
    private final List<AmbientSound> sounds;
    @NotNull
    private final ClosedRange<Duration> delay;
    @NotNull
    private final Ref<? extends EntityActivityEntry> activity;

    public AmbientSoundActivityEntry(@NotNull String id, @NotNull String name, @NotNull List<AmbientSound> sounds, @NotNull ClosedRange<Duration> delay, @NotNull Ref<? extends EntityActivityEntry> activity) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(sounds, (String)"sounds");
        Intrinsics.checkNotNullParameter(delay, (String)"delay");
        Intrinsics.checkNotNullParameter(activity, (String)"activity");
        this.id = id;
        this.name = name;
        this.sounds = sounds;
        this.delay = delay;
        this.activity = activity;
    }

    public /* synthetic */ AmbientSoundActivityEntry(String string, String string2, List list, ClosedRange closedRange, Ref ref, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "";
        }
        if ((n & 2) != 0) {
            string2 = "";
        }
        if ((n & 4) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 8) != 0) {
            Comparable comparable = Duration.ZERO;
            Duration duration = Duration.ZERO;
            Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ZERO");
            closedRange = RangesKt.rangeTo((Comparable)comparable, (Comparable)duration);
        }
        if ((n & 0x10) != 0) {
            boolean $i$f$emptyRef = false;
            ref = new Ref("", Reflection.getOrCreateKotlinClass(EntityActivityEntry.class), null, 4, null);
        }
        this(string, string2, list, (ClosedRange<Duration>)closedRange, (Ref<? extends EntityActivityEntry>)ref);
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public final List<AmbientSound> getSounds() {
        return this.sounds;
    }

    @NotNull
    public final ClosedRange<Duration> getDelay() {
        return this.delay;
    }

    @Help(text="How long to wait before playing the next sound")
    @Default(json="{\"start\": 2000, \"end\": 5000}")
    public static /* synthetic */ void getDelay$annotations() {
    }

    @NotNull
    public final Ref<? extends EntityActivityEntry> getActivity() {
        return this.activity;
    }

    @NotNull
    public EntityActivity<ActivityContext> create(@NotNull ActivityContext context, @NotNull PositionProperty currentLocation) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)currentLocation, (String)"currentLocation");
        return (EntityActivity)new AmbientSoundActivity(this.sounds, this.delay, this.activity, currentLocation);
    }

    @NotNull
    public EntityActivity<SharedActivityContext> create(@NotNull SharedActivityContext context, @NotNull PositionProperty currentLocation) {
        return super.create(context, currentLocation);
    }

    @NotNull
    public EntityActivity<IndividualActivityContext> create(@NotNull IndividualActivityContext context, @NotNull PositionProperty currentLocation) {
        return super.create(context, currentLocation);
    }

    public AmbientSoundActivityEntry() {
        this(null, null, null, null, null, 31, null);
    }
}

