/*
 * Decompiled with CFR 0.152.
 */
package com.typewritermc.entity.entries.activity;

import com.typewritermc.core.entries.Ref;
import com.typewritermc.core.extension.annotations.Default;
import com.typewritermc.core.extension.annotations.Entry;
import com.typewritermc.core.extension.annotations.Help;
import com.typewritermc.core.extension.annotations.Min;
import com.typewritermc.engine.paper.entry.entity.ActivityContext;
import com.typewritermc.engine.paper.entry.entity.ActivityCreator;
import com.typewritermc.engine.paper.entry.entity.EntityActivity;
import com.typewritermc.engine.paper.entry.entity.IdleActivity;
import com.typewritermc.engine.paper.entry.entity.IndividualActivityContext;
import com.typewritermc.engine.paper.entry.entity.PositionProperty;
import com.typewritermc.engine.paper.entry.entity.SharedActivityContext;
import com.typewritermc.engine.paper.entry.entries.ConstVar;
import com.typewritermc.engine.paper.entry.entries.EntityActivityEntry;
import com.typewritermc.engine.paper.entry.entries.GenericEntityActivityEntry;
import com.typewritermc.engine.paper.entry.entries.Var;
import com.typewritermc.entity.entries.activity.BobbingActivity;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Entry(name="bobbing_activity", description="Makes the entity bob up and down, like a floating item.", color="#1E88E5", icon="fa6-solid:arrows-up-down")
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001BM\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0010\b\u0002\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n\u00a2\u0006\u0004\b\f\u0010\rJ\u001e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\"\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u0013\u0010\u0014R\"\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0015\u0010\u0012\u001a\u0004\b\u0016\u0010\u0014R$\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0017\u0010\u0012\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006 "}, d2={"Lcom/typewritermc/entity/entries/activity/BobbingActivityEntry;", "Lcom/typewritermc/engine/paper/entry/entries/GenericEntityActivityEntry;", "id", "", "name", "speed", "Lcom/typewritermc/engine/paper/entry/entries/Var;", "", "amplitude", "childActivity", "Lcom/typewritermc/core/entries/Ref;", "Lcom/typewritermc/engine/paper/entry/entries/EntityActivityEntry;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Lcom/typewritermc/engine/paper/entry/entries/Var;Lcom/typewritermc/engine/paper/entry/entries/Var;Lcom/typewritermc/core/entries/Ref;)V", "getId", "()Ljava/lang/String;", "getName", "getSpeed$annotations", "()V", "getSpeed", "()Lcom/typewritermc/engine/paper/entry/entries/Var;", "getAmplitude$annotations", "getAmplitude", "getChildActivity$annotations", "getChildActivity", "()Lcom/typewritermc/core/entries/Ref;", "create", "Lcom/typewritermc/engine/paper/entry/entity/EntityActivity;", "Lcom/typewritermc/engine/paper/entry/entity/ActivityContext;", "context", "currentLocation", "Lcom/typewritermc/engine/paper/entry/entity/PositionProperty;", "EntityExtension"})
@SourceDebugExtension(value={"SMAP\nBobbingActivity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BobbingActivity.kt\ncom/typewritermc/entity/entries/activity/BobbingActivityEntry\n+ 2 EntryReference.kt\ncom/typewritermc/core/entries/EntryReferenceKt\n*L\n1#1,92:1\n6#2:93\n*S KotlinDebug\n*F\n+ 1 BobbingActivity.kt\ncom/typewritermc/entity/entries/activity/BobbingActivityEntry\n*L\n43#1:93\n*E\n"})
public final class BobbingActivityEntry
implements GenericEntityActivityEntry {
    @NotNull
    private final String id;
    @NotNull
    private final String name;
    @NotNull
    private final Var<Float> speed;
    @NotNull
    private final Var<Float> amplitude;
    @NotNull
    private final Ref<? extends EntityActivityEntry> childActivity;

    public BobbingActivityEntry(@NotNull String id, @NotNull String name, @NotNull Var<Float> speed, @NotNull Var<Float> amplitude, @NotNull Ref<? extends EntityActivityEntry> childActivity) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(speed, (String)"speed");
        Intrinsics.checkNotNullParameter(amplitude, (String)"amplitude");
        Intrinsics.checkNotNullParameter(childActivity, (String)"childActivity");
        this.id = id;
        this.name = name;
        this.speed = speed;
        this.amplitude = amplitude;
        this.childActivity = childActivity;
    }

    public /* synthetic */ BobbingActivityEntry(String string, String string2, Var var, Var var2, Ref ref, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "";
        }
        if ((n & 2) != 0) {
            string2 = "";
        }
        if ((n & 4) != 0) {
            var = (Var)new ConstVar((Object)Float.valueOf(1.0f));
        }
        if ((n & 8) != 0) {
            var2 = (Var)new ConstVar((Object)Float.valueOf(0.5f));
        }
        if ((n & 0x10) != 0) {
            boolean $i$f$emptyRef = false;
            ref = new Ref("", Reflection.getOrCreateKotlinClass(EntityActivityEntry.class), null, 4, null);
        }
        this(string, string2, (Var<Float>)var, (Var<Float>)var2, (Ref<? extends EntityActivityEntry>)ref);
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public final Var<Float> getSpeed() {
        return this.speed;
    }

    @Help(text="The speed of the bobbing motion in cycles per second. Higher values mean faster bobbing.")
    @Default(json="1.0")
    @Min(value=0)
    public static /* synthetic */ void getSpeed$annotations() {
    }

    @NotNull
    public final Var<Float> getAmplitude() {
        return this.amplitude;
    }

    @Help(text="The amplitude of the bobbing motion in blocks. For example, an amplitude of 0.5 means it will move 0.25 blocks up and 0.25 blocks down from its starting point.")
    @Default(json="0.5")
    public static /* synthetic */ void getAmplitude$annotations() {
    }

    @NotNull
    public final Ref<? extends EntityActivityEntry> getChildActivity() {
        return this.childActivity;
    }

    @Help(text="The activity that supplies the base position. If not set, the entity will bob in place around its initial position.")
    public static /* synthetic */ void getChildActivity$annotations() {
    }

    @NotNull
    public EntityActivity<ActivityContext> create(@NotNull ActivityContext context, @NotNull PositionProperty currentLocation) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)currentLocation, (String)"currentLocation");
        EntityActivityEntry entityActivityEntry = (EntityActivityEntry)this.childActivity.get();
        if (entityActivityEntry == null || (entityActivityEntry = ((ActivityCreator)entityActivityEntry).create(context, currentLocation)) == null) {
            entityActivityEntry = (EntityActivity)new IdleActivity(currentLocation);
        }
        EntityActivityEntry baseActivity = entityActivityEntry;
        return new BobbingActivity(this.speed, this.amplitude, (EntityActivity<ActivityContext>)baseActivity);
    }

    @NotNull
    public EntityActivity<SharedActivityContext> create(@NotNull SharedActivityContext context, @NotNull PositionProperty currentLocation) {
        return super.create(context, currentLocation);
    }

    @NotNull
    public EntityActivity<IndividualActivityContext> create(@NotNull IndividualActivityContext context, @NotNull PositionProperty currentLocation) {
        return super.create(context, currentLocation);
    }

    public BobbingActivityEntry() {
        this(null, null, null, null, null, 31, null);
    }
}

