/*
 * Decompiled with CFR 0.152.
 */
package com.typewritermc.entity.entries.activity;

import com.github.retrooper.packetevents.protocol.particle.Particle;
import com.github.retrooper.packetevents.protocol.particle.data.ParticleData;
import com.github.retrooper.packetevents.protocol.particle.data.ParticleDustData;
import com.github.retrooper.packetevents.protocol.particle.type.ParticleTypes;
import com.github.retrooper.packetevents.util.Vector3d;
import com.github.retrooper.packetevents.util.Vector3f;
import com.github.retrooper.packetevents.wrapper.PacketWrapper;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerParticle;
import com.typewritermc.core.utils.point.Vector;
import com.typewritermc.engine.paper.entry.entity.ActivityContext;
import com.typewritermc.engine.paper.entry.entity.EntityState;
import com.typewritermc.engine.paper.entry.entity.GenericEntityActivity;
import com.typewritermc.engine.paper.entry.entity.PositionProperty;
import com.typewritermc.engine.paper.entry.entity.TickResult;
import com.typewritermc.engine.paper.entry.entries.EntityProperty;
import com.typewritermc.engine.paper.extensions.packetevents.PlayerPacketsKt;
import com.typewritermc.engine.paper.utils.Color;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u001a\u0010\u0002\u001a\u00020\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0019"}, d2={"Lcom/typewritermc/entity/entries/activity/EyeHeightDebugActivity;", "Lcom/typewritermc/engine/paper/entry/entity/GenericEntityActivity;", "currentPosition", "Lcom/typewritermc/engine/paper/entry/entity/PositionProperty;", "directionOffset", "Lcom/typewritermc/core/utils/point/Vector;", "color", "Lcom/typewritermc/engine/paper/utils/Color;", "<init>", "(Lcom/typewritermc/engine/paper/entry/entity/PositionProperty;Lcom/typewritermc/core/utils/point/Vector;Lcom/typewritermc/engine/paper/utils/Color;)V", "getCurrentPosition", "()Lcom/typewritermc/engine/paper/entry/entity/PositionProperty;", "setCurrentPosition", "(Lcom/typewritermc/engine/paper/entry/entity/PositionProperty;)V", "getDirectionOffset", "()Lcom/typewritermc/core/utils/point/Vector;", "getColor", "()Lcom/typewritermc/engine/paper/utils/Color;", "initialize", "", "context", "Lcom/typewritermc/engine/paper/entry/entity/ActivityContext;", "tick", "Lcom/typewritermc/engine/paper/entry/entity/TickResult;", "dispose", "EntityExtension"})
@SourceDebugExtension(value={"SMAP\nEyeHeightDebugActivity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EyeHeightDebugActivity.kt\ncom/typewritermc/entity/entries/activity/EyeHeightDebugActivity\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,94:1\n1869#2,2:95\n*S KotlinDebug\n*F\n+ 1 EyeHeightDebugActivity.kt\ncom/typewritermc/entity/entries/activity/EyeHeightDebugActivity\n*L\n87#1:95,2\n*E\n"})
public final class EyeHeightDebugActivity
implements GenericEntityActivity {
    @NotNull
    private PositionProperty currentPosition;
    @NotNull
    private final Vector directionOffset;
    @NotNull
    private final Color color;

    public EyeHeightDebugActivity(@NotNull PositionProperty currentPosition, @NotNull Vector directionOffset, @NotNull Color color) {
        Intrinsics.checkNotNullParameter((Object)currentPosition, (String)"currentPosition");
        Intrinsics.checkNotNullParameter((Object)directionOffset, (String)"directionOffset");
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        this.currentPosition = currentPosition;
        this.directionOffset = directionOffset;
        this.color = color;
    }

    @NotNull
    public PositionProperty getCurrentPosition() {
        return this.currentPosition;
    }

    public void setCurrentPosition(@NotNull PositionProperty positionProperty) {
        Intrinsics.checkNotNullParameter((Object)positionProperty, (String)"<set-?>");
        this.currentPosition = positionProperty;
    }

    @NotNull
    public final Vector getDirectionOffset() {
        return this.directionOffset;
    }

    @NotNull
    public final Color getColor() {
        return this.color;
    }

    public void initialize(@NotNull ActivityContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
    }

    @NotNull
    public TickResult tick(@NotNull ActivityContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        PositionProperty pos = this.getCurrentPosition();
        EntityState state = context.getEntityState();
        double eyeHeight = state.getEyeHeight();
        double yawRad = Math.toRadians(pos.getYaw());
        double pitchRad = Math.toRadians(pos.getPitch());
        Vector direction = new Vector(-Math.sin(yawRad) * Math.cos(pitchRad), -Math.sin(pitchRad), Math.cos(yawRad) * Math.cos(pitchRad));
        Vector3d eyePosition = new Vector3d(pos.getX() + direction.getX() * this.directionOffset.getX(), pos.getY() + eyeHeight * this.directionOffset.getY(), pos.getZ() + direction.getZ() * this.directionOffset.getZ());
        WrapperPlayServerParticle particlePacket = new WrapperPlayServerParticle(new Particle(ParticleTypes.DUST, (ParticleData)new ParticleDustData(0.3f, this.color.toPacketColor())), false, eyePosition, new Vector3f(0.0f, 0.0f, 0.0f), 0.0f, 1);
        Iterable $this$forEach$iv = context.getViewers();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Player p0 = (Player)element$iv;
            boolean bl = false;
            PlayerPacketsKt.sendPacketTo((PacketWrapper)((PacketWrapper)particlePacket), (Player)p0);
        }
        return TickResult.CONSUMED;
    }

    public void dispose(@NotNull ActivityContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
    }

    @NotNull
    public List<EntityProperty> getCurrentProperties() {
        return super.getCurrentProperties();
    }
}

