/*
 * Decompiled with CFR 0.152.
 */
package com.typewritermc.entity.entries.activity;

import com.typewritermc.core.entries.Entry;
import com.typewritermc.core.entries.LibraryKt;
import com.typewritermc.core.entries.Ref;
import com.typewritermc.engine.paper.entry.dialogue.DialogueInteractionKt;
import com.typewritermc.engine.paper.entry.entity.ActivityContext;
import com.typewritermc.engine.paper.entry.entity.PositionProperty;
import com.typewritermc.engine.paper.entry.entity.SingleChildActivity;
import com.typewritermc.engine.paper.entry.entries.DialogueEntry;
import com.typewritermc.engine.paper.entry.entries.EntityActivityEntry;
import com.typewritermc.engine.paper.entry.entries.EntityInstanceEntry;
import com.typewritermc.engine.paper.utils.ExtensionsKt;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0015B?\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u000e\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\b\u0012\u000e\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\b\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0018\u0010\u0013\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\b2\u0006\u0010\u0014\u001a\u00020\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000f\u001a\u0012\u0012\u0004\u0012\u00020\u0011\u0012\b\u0012\u00060\u0012R\u00020\u00000\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/typewritermc/entity/entries/activity/InDialogueActivity;", "Lcom/typewritermc/engine/paper/entry/entity/SingleChildActivity;", "Lcom/typewritermc/engine/paper/entry/entity/ActivityContext;", "dialogueIdleDuration", "Ljava/time/Duration;", "priority", "", "talkingActivity", "Lcom/typewritermc/core/entries/Ref;", "Lcom/typewritermc/engine/paper/entry/entries/EntityActivityEntry;", "idleActivity", "startLocation", "Lcom/typewritermc/engine/paper/entry/entity/PositionProperty;", "<init>", "(Ljava/time/Duration;ILcom/typewritermc/core/entries/Ref;Lcom/typewritermc/core/entries/Ref;Lcom/typewritermc/engine/paper/entry/entity/PositionProperty;)V", "trackers", "", "Ljava/util/UUID;", "Lcom/typewritermc/entity/entries/activity/InDialogueActivity$PlayerDialogueTracker;", "currentChild", "context", "PlayerDialogueTracker", "EntityExtension"})
@SourceDebugExtension(value={"SMAP\nInDialogueActivity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InDialogueActivity.kt\ncom/typewritermc/entity/entries/activity/InDialogueActivity\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,123:1\n774#2:124\n865#2:125\n1761#2,3:126\n866#2:129\n1869#2,2:130\n2746#2,3:135\n188#3,3:132\n*S KotlinDebug\n*F\n+ 1 InDialogueActivity.kt\ncom/typewritermc/entity/entries/activity/InDialogueActivity\n*L\n81#1:124\n81#1:125\n82#1:126,3\n81#1:129\n93#1:130,2\n87#1:135,3\n97#1:132,3\n*E\n"})
public final class InDialogueActivity
extends SingleChildActivity<ActivityContext> {
    @NotNull
    private final Duration dialogueIdleDuration;
    private final int priority;
    @NotNull
    private final Ref<? extends EntityActivityEntry> talkingActivity;
    @NotNull
    private final Ref<? extends EntityActivityEntry> idleActivity;
    @NotNull
    private final Map<UUID, PlayerDialogueTracker> trackers;

    public InDialogueActivity(@NotNull Duration dialogueIdleDuration, int priority, @NotNull Ref<? extends EntityActivityEntry> talkingActivity, @NotNull Ref<? extends EntityActivityEntry> idleActivity, @NotNull PositionProperty startLocation) {
        Intrinsics.checkNotNullParameter((Object)dialogueIdleDuration, (String)"dialogueIdleDuration");
        Intrinsics.checkNotNullParameter(talkingActivity, (String)"talkingActivity");
        Intrinsics.checkNotNullParameter(idleActivity, (String)"idleActivity");
        Intrinsics.checkNotNullParameter((Object)startLocation, (String)"startLocation");
        super(startLocation);
        this.dialogueIdleDuration = dialogueIdleDuration;
        this.priority = priority;
        this.talkingActivity = talkingActivity;
        this.idleActivity = idleActivity;
        this.trackers = new LinkedHashMap();
    }

    @NotNull
    public Ref<? extends EntityActivityEntry> currentChild(@NotNull ActivityContext context) {
        boolean bl;
        block11: {
            Iterator $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            EntityInstanceEntry entityInstanceEntry = (EntityInstanceEntry)context.getInstanceRef().get();
            Ref ref = (Ref)ExtensionsKt.logErrorIfNull((Object)(entityInstanceEntry != null ? entityInstanceEntry.getDefinition() : null), (String)"Could not find definition, this should not happen. Please report this on the TypeWriter Discord!");
            if (ref == null) {
                return this.idleActivity;
            }
            Ref definition = ref;
            Iterable $this$filter$iv = context.getViewers();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            Object object = $this$filterTo$iv$iv.iterator();
            while (object.hasNext()) {
                boolean bl2;
                Object element$iv$iv;
                block10: {
                    element$iv$iv = object.next();
                    Player viewer = (Player)element$iv$iv;
                    boolean bl3 = false;
                    Iterable $this$any$iv = DialogueInteractionKt.getSpeakersInDialogue((Player)viewer);
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl2 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            Ref it = (Ref)element$iv;
                            boolean bl4 = false;
                            if (!(Intrinsics.areEqual((Object)it, (Object)definition) || Intrinsics.areEqual((Object)it, (Object)context.getInstanceRef()))) continue;
                            bl2 = true;
                            break block10;
                        }
                        bl2 = false;
                    }
                }
                if (!bl2) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List inDialogue = (List)destination$iv$iv;
            this.trackers.keySet().removeIf(arg_0 -> InDialogueActivity.currentChild$lambda$4(arg_0 -> InDialogueActivity.currentChild$lambda$3(inDialogue, arg_0), arg_0));
            if (inDialogue.isEmpty()) {
                return this.idleActivity;
            }
            Iterable $this$forEach$iv = inDialogue;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Player player = (Player)element$iv;
                boolean bl5 = false;
                this.trackers.computeIfAbsent(player.getUniqueId(), arg_0 -> InDialogueActivity.currentChild$lambda$7$lambda$6(arg_0 -> InDialogueActivity.currentChild$lambda$7$lambda$5(this, player, arg_0), arg_0)).update(player);
            }
            Map<UUID, PlayerDialogueTracker> $this$any$iv = this.trackers;
            boolean $i$f$any = false;
            if ($this$any$iv.isEmpty()) {
                bl = false;
            } else {
                for (Map.Entry<UUID, PlayerDialogueTracker> element$iv : $this$any$iv.entrySet()) {
                    object = element$iv;
                    boolean bl6 = false;
                    PlayerDialogueTracker tracker = (PlayerDialogueTracker)object.getValue();
                    if (!tracker.isActive(this.dialogueIdleDuration)) continue;
                    bl = true;
                    break block11;
                }
                bl = false;
            }
        }
        boolean isTalking = bl;
        return isTalking ? this.talkingActivity : this.idleActivity;
    }

    private static final boolean currentChild$lambda$3(List $inDialogue, UUID uuid) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
            Iterable $this$none$iv = $inDialogue;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    Player it = (Player)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getUniqueId(), (Object)uuid)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    private static final boolean currentChild$lambda$4(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final PlayerDialogueTracker currentChild$lambda$7$lambda$5(InDialogueActivity this$0, Player $player, UUID it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new PlayerDialogueTracker(this$0, DialogueInteractionKt.getCurrentDialogue((Player)$player), 0L, 2, null);
    }

    private static final PlayerDialogueTracker currentChild$lambda$7$lambda$6(Function1 $tmp0, Object p0) {
        return (PlayerDialogueTracker)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u001b\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017R\u001c\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0018"}, d2={"Lcom/typewritermc/entity/entries/activity/InDialogueActivity$PlayerDialogueTracker;", "", "dialogue", "Lcom/typewritermc/engine/paper/entry/entries/DialogueEntry;", "lastInteraction", "", "<init>", "(Lcom/typewritermc/entity/entries/activity/InDialogueActivity;Lcom/typewritermc/engine/paper/entry/entries/DialogueEntry;J)V", "getDialogue", "()Lcom/typewritermc/engine/paper/entry/entries/DialogueEntry;", "setDialogue", "(Lcom/typewritermc/engine/paper/entry/entries/DialogueEntry;)V", "getLastInteraction", "()J", "setLastInteraction", "(J)V", "update", "", "player", "Lorg/bukkit/entity/Player;", "isActive", "", "maxIdleDuration", "Ljava/time/Duration;", "EntityExtension"})
    private final class PlayerDialogueTracker {
        @Nullable
        private DialogueEntry dialogue;
        private long lastInteraction;
        final /* synthetic */ InDialogueActivity this$0;

        public PlayerDialogueTracker(@Nullable InDialogueActivity this$0, DialogueEntry dialogue, long lastInteraction) {
            this.this$0 = this$0;
            this.dialogue = dialogue;
            this.lastInteraction = lastInteraction;
        }

        public /* synthetic */ PlayerDialogueTracker(InDialogueActivity inDialogueActivity, DialogueEntry dialogueEntry, long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                l = System.currentTimeMillis();
            }
            this(inDialogueActivity, dialogueEntry, l);
        }

        @Nullable
        public final DialogueEntry getDialogue() {
            return this.dialogue;
        }

        public final void setDialogue(@Nullable DialogueEntry dialogueEntry) {
            this.dialogue = dialogueEntry;
        }

        public final long getLastInteraction() {
            return this.lastInteraction;
        }

        public final void setLastInteraction(long l) {
            this.lastInteraction = l;
        }

        public final void update(@NotNull Player player) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            DialogueEntry currentDialogue = DialogueInteractionKt.getCurrentDialogue((Player)player);
            DialogueEntry dialogueEntry = this.dialogue;
            DialogueEntry dialogueEntry2 = currentDialogue;
            if (Intrinsics.areEqual((Object)(dialogueEntry != null ? dialogueEntry.getId() : null), (Object)(dialogueEntry2 != null ? dialogueEntry2.getId() : null))) {
                return;
            }
            this.lastInteraction = System.currentTimeMillis();
            this.dialogue = currentDialogue;
        }

        public final boolean isActive(@NotNull Duration maxIdleDuration) {
            Intrinsics.checkNotNullParameter((Object)maxIdleDuration, (String)"maxIdleDuration");
            if (maxIdleDuration.isZero()) {
                return true;
            }
            DialogueEntry dialogueEntry = this.dialogue;
            if (dialogueEntry == null) {
                return false;
            }
            DialogueEntry dialogue = dialogueEntry;
            if (LibraryKt.getPriority((Entry)((Entry)dialogue)) > this.this$0.priority) {
                return true;
            }
            return System.currentTimeMillis() - this.lastInteraction < maxIdleDuration.toMillis();
        }
    }
}

