/*
 * Decompiled with CFR 0.152.
 */
package com.typewritermc.entity.entries.activity;

import com.typewritermc.core.utils.point.Point;
import com.typewritermc.core.utils.point.Vector;
import com.typewritermc.core.utils.point.VectorKt;
import com.typewritermc.engine.paper.entry.entity.ActivityContext;
import com.typewritermc.engine.paper.entry.entity.EntityActivity;
import com.typewritermc.engine.paper.entry.entity.PositionProperty;
import com.typewritermc.engine.paper.entry.entity.PositionPropertyKt;
import com.typewritermc.engine.paper.entry.entity.TickResult;
import com.typewritermc.engine.paper.entry.entries.EntityProperty;
import com.typewritermc.engine.paper.utils.ExtensionsKt;
import com.typewritermc.entity.entries.activity.LookCloseActivityKt;
import com.typewritermc.entity.entries.activity.LookDirection;
import com.typewritermc.entity.entries.activity.Velocity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0017B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0002H\u0016J\u0016\u0010\u0013\u001a\b\u0018\u00010\bR\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0002H\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u0002H\u0016J\u0010\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0018\u00010\bR\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u00020\u0004X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0006\u00a8\u0006\u0018"}, d2={"Lcom/typewritermc/entity/entries/activity/LookCloseActivity;", "Lcom/typewritermc/engine/paper/entry/entity/EntityActivity;", "Lcom/typewritermc/engine/paper/entry/entity/ActivityContext;", "startPosition", "Lcom/typewritermc/engine/paper/entry/entity/PositionProperty;", "<init>", "(Lcom/typewritermc/engine/paper/entry/entity/PositionProperty;)V", "target", "Lcom/typewritermc/entity/entries/activity/LookCloseActivity$Target;", "yawVelocity", "Lcom/typewritermc/entity/entries/activity/Velocity;", "pitchVelocity", "currentPosition", "getCurrentPosition", "()Lcom/typewritermc/engine/paper/entry/entity/PositionProperty;", "setCurrentPosition", "initialize", "", "context", "findNewTarget", "tick", "Lcom/typewritermc/engine/paper/entry/entity/TickResult;", "dispose", "Target", "EntityExtension"})
@SourceDebugExtension(value={"SMAP\nLookCloseActivity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LookCloseActivity.kt\ncom/typewritermc/entity/entries/activity/LookCloseActivity\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,226:1\n774#2:227\n865#2,2:228\n2423#2,14:230\n*S KotlinDebug\n*F\n+ 1 LookCloseActivity.kt\ncom/typewritermc/entity/entries/activity/LookCloseActivity\n*L\n56#1:227\n56#1:228,2\n57#1:230,14\n*E\n"})
public final class LookCloseActivity
implements EntityActivity<ActivityContext> {
    @NotNull
    private final PositionProperty startPosition;
    @Nullable
    private Target target;
    @NotNull
    private final Velocity yawVelocity;
    @NotNull
    private final Velocity pitchVelocity;
    @NotNull
    private PositionProperty currentPosition;

    public LookCloseActivity(@NotNull PositionProperty startPosition) {
        Intrinsics.checkNotNullParameter((Object)startPosition, (String)"startPosition");
        this.startPosition = startPosition;
        this.yawVelocity = new Velocity(0.0f);
        this.pitchVelocity = new Velocity(0.0f);
        this.currentPosition = this.startPosition;
    }

    @NotNull
    public PositionProperty getCurrentPosition() {
        return this.currentPosition;
    }

    public void setCurrentPosition(@NotNull PositionProperty positionProperty) {
        Intrinsics.checkNotNullParameter((Object)positionProperty, (String)"<set-?>");
        this.currentPosition = positionProperty;
    }

    public void initialize(@NotNull ActivityContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
    }

    /*
     * WARNING - void declaration
     */
    private final Target findNewTarget(ActivityContext context) {
        Object v0;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = context.getViewers();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Player it = (Player)element$iv$iv;
            boolean bl = false;
            if (!ExtensionsKt.isLookable((Player)it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$minByOrNull$iv = (List)destination$iv$iv;
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = minElem$iv;
            } else {
                Player it = (Player)minElem$iv;
                boolean bl = false;
                PositionProperty positionProperty = this.getCurrentPosition();
                Location location = it.getLocation();
                Intrinsics.checkNotNullExpressionValue((Object)location, (String)"getLocation(...)");
                Double d = positionProperty.distanceSqrt(location);
                double minValue$iv = d != null ? d : Double.POSITIVE_INFINITY;
                do {
                    double v$iv;
                    Object e$iv = iterator$iv.next();
                    Player it2 = (Player)e$iv;
                    $i$a$-minByOrNull-LookCloseActivity$findNewTarget$closestTarget$2 = false;
                    PositionProperty positionProperty2 = this.getCurrentPosition();
                    Location location2 = it2.getLocation();
                    Intrinsics.checkNotNullExpressionValue((Object)location2, (String)"getLocation(...)");
                    Double d2 = positionProperty2.distanceSqrt(location2);
                    double d3 = v$iv = d2 != null ? d2 : Double.POSITIVE_INFINITY;
                    if (Double.compare(minValue$iv, v$iv) <= 0) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = minElem$iv;
            }
        }
        Player closestTarget = v0;
        if (closestTarget == null) {
            return null;
        }
        PositionProperty positionProperty = this.getCurrentPosition();
        Location location = closestTarget.getLocation();
        Intrinsics.checkNotNullExpressionValue((Object)location, (String)"getLocation(...)");
        Double distance = positionProperty.distanceSqrt(location);
        if (distance == null || distance > LookCloseActivityKt.access$getPlayerLookCloseRange() * LookCloseActivityKt.access$getPlayerLookCloseRange()) {
            return null;
        }
        return new Target(this, closestTarget, 0L, 2, null);
    }

    @NotNull
    public TickResult tick(@NotNull ActivityContext context) {
        Target target;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!context.isViewed()) {
            this.target = null;
            return TickResult.CONSUMED;
        }
        Target target2 = this.target;
        boolean bl = target2 != null ? target2.getShouldRefresh() : false;
        if (bl) {
            this.target = null;
        }
        if ((target = this.target) == null) {
            target = this.findNewTarget(context);
        }
        if (target == null) {
            float targetYaw = this.startPosition.getYaw();
            float targetPitch = this.startPosition.getPitch();
            Pair<Float, Float> pair = LookCloseActivityKt.updateLookDirection(new LookDirection(this.getCurrentPosition().getYaw(), this.getCurrentPosition().getPitch()), new LookDirection(targetYaw, targetPitch), this.yawVelocity, this.pitchVelocity, LookCloseActivityKt.access$getPlayerLookCloseSmoothingTime());
            float yaw = ((Number)pair.component1()).floatValue();
            float pitch = ((Number)pair.component2()).floatValue();
            this.setCurrentPosition(new PositionProperty(this.getCurrentPosition().getWorld(), this.getCurrentPosition().getX(), this.getCurrentPosition().getY(), this.getCurrentPosition().getZ(), yaw, pitch));
            return TickResult.IGNORED;
        }
        this.target = target;
        PositionProperty npcEyePosition = (PositionProperty)Point.add$default((Point)((Point)this.getCurrentPosition()), (double)0.0, (double)context.getEntityState().getEyeHeight(), (double)0.0, (int)5, null);
        Vector direction = ((Vector)VectorKt.toVector((Point)((Point)target.getEyePosition())).minus((Point)npcEyePosition)).normalize();
        float targetYaw = LookCloseActivityKt.getLookYaw(direction.getX(), direction.getZ());
        float targetPitch = LookCloseActivityKt.getLookPitch(direction.getX(), direction.getY(), direction.getZ());
        Pair pair = LookCloseActivityKt.updateLookDirection$default(new LookDirection(this.getCurrentPosition().getYaw(), this.getCurrentPosition().getPitch()), new LookDirection(targetYaw, targetPitch), this.yawVelocity, this.pitchVelocity, 0.0f, 16, null);
        float yaw = ((Number)pair.component1()).floatValue();
        float pitch = ((Number)pair.component2()).floatValue();
        this.setCurrentPosition(new PositionProperty(this.getCurrentPosition().getWorld(), this.getCurrentPosition().getX(), this.getCurrentPosition().getY(), this.getCurrentPosition().getZ(), yaw, pitch));
        return TickResult.CONSUMED;
    }

    public void dispose(@NotNull ActivityContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.target = null;
        this.yawVelocity.setValue(0.0f);
        this.pitchVelocity.setValue(0.0f);
    }

    @NotNull
    public List<EntityProperty> getCurrentProperties() {
        return super.getCurrentProperties();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0011\u00a8\u0006\u0014"}, d2={"Lcom/typewritermc/entity/entries/activity/LookCloseActivity$Target;", "", "player", "Lorg/bukkit/entity/Player;", "lookupTime", "", "<init>", "(Lcom/typewritermc/entity/entries/activity/LookCloseActivity;Lorg/bukkit/entity/Player;J)V", "getPlayer", "()Lorg/bukkit/entity/Player;", "shouldRefresh", "", "getShouldRefresh", "()Z", "position", "Lcom/typewritermc/engine/paper/entry/entity/PositionProperty;", "getPosition", "()Lcom/typewritermc/engine/paper/entry/entity/PositionProperty;", "eyePosition", "getEyePosition", "EntityExtension"})
    public final class Target {
        @NotNull
        private final Player player;
        private final long lookupTime;
        final /* synthetic */ LookCloseActivity this$0;

        public Target(@NotNull LookCloseActivity this$0, Player player, long lookupTime) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            this.this$0 = this$0;
            this.player = player;
            this.lookupTime = lookupTime;
        }

        public /* synthetic */ Target(LookCloseActivity lookCloseActivity, Player player, long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                l = System.currentTimeMillis();
            }
            this(lookCloseActivity, player, l);
        }

        @NotNull
        public final Player getPlayer() {
            return this.player;
        }

        public final boolean getShouldRefresh() {
            if (!this.player.isValid()) {
                return true;
            }
            if (!Intrinsics.areEqual((Object)this.player.getLocation().getWorld().getUID().toString(), (Object)this.getPosition().getWorld().getIdentifier())) {
                return true;
            }
            PositionProperty positionProperty = this.getPosition();
            Location location = this.player.getLocation();
            Intrinsics.checkNotNullExpressionValue((Object)location, (String)"getLocation(...)");
            if (positionProperty.distanceSquared((Point)PositionPropertyKt.toProperty((Location)location)) > LookCloseActivityKt.access$getPlayerLookCloseRange() * LookCloseActivityKt.access$getPlayerLookCloseRange()) {
                return true;
            }
            return System.currentTimeMillis() - this.lookupTime > 1000L;
        }

        @NotNull
        public final PositionProperty getPosition() {
            Location location = this.player.getLocation();
            Intrinsics.checkNotNullExpressionValue((Object)location, (String)"getLocation(...)");
            return PositionPropertyKt.toProperty((Location)location);
        }

        @NotNull
        public final PositionProperty getEyePosition() {
            Location location = this.player.getEyeLocation();
            Intrinsics.checkNotNullExpressionValue((Object)location, (String)"getEyeLocation(...)");
            return PositionPropertyKt.toProperty((Location)location);
        }
    }
}

