/*
 * Decompiled with CFR 0.152.
 */
package com.typewritermc.entity.entries.activity;

import com.typewritermc.core.entries.Ref;
import com.typewritermc.core.utils.point.Point;
import com.typewritermc.core.utils.point.PositionKt;
import com.typewritermc.engine.paper.entry.entity.ActivityContext;
import com.typewritermc.engine.paper.entry.entity.PositionProperty;
import com.typewritermc.engine.paper.entry.entity.PositionPropertyKt;
import com.typewritermc.engine.paper.entry.entity.SingleChildActivity;
import com.typewritermc.engine.paper.entry.entries.EntityActivityEntry;
import com.typewritermc.engine.paper.utils.ExtensionsKt;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0016BG\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u000e\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\t\u0012\u000e\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\t\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0018\u0010\u0014\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\t2\u0006\u0010\u0015\u001a\u00020\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/typewritermc/entity/entries/activity/PlayerCloseByActivity;", "Lcom/typewritermc/engine/paper/entry/entity/SingleChildActivity;", "Lcom/typewritermc/engine/paper/entry/entity/ActivityContext;", "deactivationRange", "", "activationRange", "maxIdleDuration", "Ljava/time/Duration;", "closeByActivity", "Lcom/typewritermc/core/entries/Ref;", "Lcom/typewritermc/engine/paper/entry/entries/EntityActivityEntry;", "idleActivity", "startLocation", "Lcom/typewritermc/engine/paper/entry/entity/PositionProperty;", "<init>", "(DDLjava/time/Duration;Lcom/typewritermc/core/entries/Ref;Lcom/typewritermc/core/entries/Ref;Lcom/typewritermc/engine/paper/entry/entity/PositionProperty;)V", "trackers", "", "Ljava/util/UUID;", "Lcom/typewritermc/entity/entries/activity/PlayerCloseByActivity$PlayerLocationTracker;", "currentChild", "context", "PlayerLocationTracker", "EntityExtension"})
@SourceDebugExtension(value={"SMAP\nPlayerCloseByActivity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlayerCloseByActivity.kt\ncom/typewritermc/entity/entries/activity/PlayerCloseByActivity\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,155:1\n774#2:156\n865#2,2:157\n774#2:159\n865#2,2:160\n1869#2,2:162\n2746#2,3:167\n188#3,3:164\n*S KotlinDebug\n*F\n+ 1 PlayerCloseByActivity.kt\ncom/typewritermc/entity/entries/activity/PlayerCloseByActivity\n*L\n93#1:156\n93#1:157,2\n94#1:159\n94#1:160,2\n101#1:162,2\n99#1:167,3\n111#1:164,3\n*E\n"})
public final class PlayerCloseByActivity
extends SingleChildActivity<ActivityContext> {
    private final double deactivationRange;
    private final double activationRange;
    @NotNull
    private final Duration maxIdleDuration;
    @NotNull
    private final Ref<? extends EntityActivityEntry> closeByActivity;
    @NotNull
    private final Ref<? extends EntityActivityEntry> idleActivity;
    @NotNull
    private Map<UUID, PlayerLocationTracker> trackers;

    public PlayerCloseByActivity(double deactivationRange, double activationRange, @NotNull Duration maxIdleDuration, @NotNull Ref<? extends EntityActivityEntry> closeByActivity, @NotNull Ref<? extends EntityActivityEntry> idleActivity, @NotNull PositionProperty startLocation) {
        Intrinsics.checkNotNullParameter((Object)maxIdleDuration, (String)"maxIdleDuration");
        Intrinsics.checkNotNullParameter(closeByActivity, (String)"closeByActivity");
        Intrinsics.checkNotNullParameter(idleActivity, (String)"idleActivity");
        Intrinsics.checkNotNullParameter((Object)startLocation, (String)"startLocation");
        super(startLocation);
        this.deactivationRange = deactivationRange;
        this.activationRange = activationRange;
        this.maxIdleDuration = maxIdleDuration;
        this.closeByActivity = closeByActivity;
        this.idleActivity = idleActivity;
        this.trackers = new LinkedHashMap();
    }

    @NotNull
    public Ref<? extends EntityActivityEntry> currentChild(@NotNull ActivityContext context) {
        boolean bl;
        block6: {
            Player it;
            Object element$iv$iv;
            Iterable $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Iterable $this$filter$iv = context.getViewers();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            Iterator iterator = $this$filterTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                element$iv$iv = iterator.next();
                it = (Player)element$iv$iv;
                boolean bl2 = false;
                if (!ExtensionsKt.isLookable((Player)it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            $i$f$filter = false;
            $this$filterTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            iterator = $this$filterTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                element$iv$iv = iterator.next();
                it = (Player)element$iv$iv;
                boolean bl3 = false;
                Location location = it.getLocation();
                Intrinsics.checkNotNullExpressionValue((Object)location, (String)"getLocation(...)");
                Double d = PositionKt.distanceSqrt((Point)((Point)PositionPropertyKt.toProperty((Location)location)), (Point)((Point)this.getCurrentPosition()));
                boolean bl4 = (d != null ? d : Double.MAX_VALUE) < this.deactivationRange * this.deactivationRange;
                if (!bl4) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List closeByPlayers = (List)destination$iv$iv;
            CollectionsKt.removeAll((Iterable)this.trackers.keySet(), arg_0 -> PlayerCloseByActivity.currentChild$lambda$3(closeByPlayers, arg_0));
            Iterable $this$forEach$iv = closeByPlayers;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Player player = (Player)element$iv;
                boolean bl5 = false;
                Location location = player.getLocation();
                Intrinsics.checkNotNullExpressionValue((Object)location, (String)"getLocation(...)");
                this.trackers.computeIfAbsent(player.getUniqueId(), arg_0 -> PlayerCloseByActivity.currentChild$lambda$6$lambda$5(arg_0 -> PlayerCloseByActivity.currentChild$lambda$6$lambda$4(player, arg_0), arg_0)).update(PositionPropertyKt.toProperty((Location)location)).updateActivated(this.getCurrentPosition(), this.activationRange);
            }
            Map<UUID, PlayerLocationTracker> $this$any$iv = this.trackers;
            boolean $i$f$any = false;
            if ($this$any$iv.isEmpty()) {
                bl = false;
            } else {
                Iterator<Map.Entry<UUID, PlayerLocationTracker>> iterator2 = $this$any$iv.entrySet().iterator();
                while (iterator2.hasNext()) {
                    Map.Entry<UUID, PlayerLocationTracker> element$iv;
                    Map.Entry<UUID, PlayerLocationTracker> it2 = element$iv = iterator2.next();
                    boolean bl6 = false;
                    if (!it2.getValue().isActive(this.maxIdleDuration)) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        boolean isActive = bl;
        return isActive ? this.closeByActivity : this.idleActivity;
    }

    private static final boolean currentChild$lambda$3(List $closeByPlayers, UUID uuid) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
            Iterable $this$none$iv = $closeByPlayers;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    Player it = (Player)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getUniqueId(), (Object)uuid)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    private static final PlayerLocationTracker currentChild$lambda$6$lambda$4(Player $player, UUID it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Location location = $player.getLocation();
        Intrinsics.checkNotNullExpressionValue((Object)location, (String)"getLocation(...)");
        return new PlayerLocationTracker(PositionPropertyKt.toProperty((Location)location), null, false, 6, null);
    }

    private static final PlayerLocationTracker currentChild$lambda$6$lambda$5(Function1 $tmp0, Object p0) {
        return (PlayerLocationTracker)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0012\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0003J\u0016\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u000e\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u001dR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001f"}, d2={"Lcom/typewritermc/entity/entries/activity/PlayerCloseByActivity$PlayerLocationTracker;", "", "location", "Lcom/typewritermc/engine/paper/entry/entity/PositionProperty;", "lastSeen", "Ljava/time/Instant;", "activated", "", "<init>", "(Lcom/typewritermc/engine/paper/entry/entity/PositionProperty;Ljava/time/Instant;Z)V", "getLocation", "()Lcom/typewritermc/engine/paper/entry/entity/PositionProperty;", "setLocation", "(Lcom/typewritermc/engine/paper/entry/entity/PositionProperty;)V", "getLastSeen", "()Ljava/time/Instant;", "setLastSeen", "(Ljava/time/Instant;)V", "getActivated", "()Z", "setActivated", "(Z)V", "update", "updateActivated", "entityPosition", "activationRange", "", "isTimedOut", "maxIdleDuration", "Ljava/time/Duration;", "isActive", "EntityExtension"})
    private static final class PlayerLocationTracker {
        @NotNull
        private PositionProperty location;
        @NotNull
        private Instant lastSeen;
        private boolean activated;

        public PlayerLocationTracker(@NotNull PositionProperty location, @NotNull Instant lastSeen, boolean activated) {
            Intrinsics.checkNotNullParameter((Object)location, (String)"location");
            Intrinsics.checkNotNullParameter((Object)lastSeen, (String)"lastSeen");
            this.location = location;
            this.lastSeen = lastSeen;
            this.activated = activated;
        }

        public /* synthetic */ PlayerLocationTracker(PositionProperty positionProperty, Instant instant, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                Instant instant2 = Instant.now();
                Intrinsics.checkNotNullExpressionValue((Object)instant2, (String)"now(...)");
                instant = instant2;
            }
            if ((n & 4) != 0) {
                bl = false;
            }
            this(positionProperty, instant, bl);
        }

        @NotNull
        public final PositionProperty getLocation() {
            return this.location;
        }

        public final void setLocation(@NotNull PositionProperty positionProperty) {
            Intrinsics.checkNotNullParameter((Object)positionProperty, (String)"<set-?>");
            this.location = positionProperty;
        }

        @NotNull
        public final Instant getLastSeen() {
            return this.lastSeen;
        }

        public final void setLastSeen(@NotNull Instant instant) {
            Intrinsics.checkNotNullParameter((Object)instant, (String)"<set-?>");
            this.lastSeen = instant;
        }

        public final boolean getActivated() {
            return this.activated;
        }

        public final void setActivated(boolean bl) {
            this.activated = bl;
        }

        @NotNull
        public final PlayerLocationTracker update(@NotNull PositionProperty location) {
            Intrinsics.checkNotNullParameter((Object)location, (String)"location");
            Double d = PositionKt.distanceSqrt((Point)((Point)this.location), (Point)((Point)location));
            double d2 = d != null ? d : Double.MAX_VALUE;
            if (d2 < 0.1) {
                return this;
            }
            this.location = location;
            Instant instant = Instant.now();
            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(...)");
            this.lastSeen = instant;
            return this;
        }

        @NotNull
        public final PlayerLocationTracker updateActivated(@NotNull PositionProperty entityPosition, double activationRange) {
            double distanceSq;
            Intrinsics.checkNotNullParameter((Object)entityPosition, (String)"entityPosition");
            Double d = PositionKt.distanceSqrt((Point)((Point)this.location), (Point)((Point)entityPosition));
            double d2 = distanceSq = d != null ? d : Double.MAX_VALUE;
            if (!this.activated && distanceSq < activationRange * activationRange) {
                this.activated = true;
            }
            return this;
        }

        private final boolean isTimedOut(Duration maxIdleDuration) {
            if (maxIdleDuration.isZero()) {
                return false;
            }
            return Duration.between(this.lastSeen, Instant.now()).compareTo(maxIdleDuration) > 0;
        }

        public final boolean isActive(@NotNull Duration maxIdleDuration) {
            Intrinsics.checkNotNullParameter((Object)maxIdleDuration, (String)"maxIdleDuration");
            if (this.isTimedOut(maxIdleDuration)) {
                return false;
            }
            return this.activated;
        }
    }
}

