/*
 * Decompiled with CFR 0.152.
 */
package com.typewritermc.entity.entries.activity;

import com.typewritermc.core.entries.Ref;
import com.typewritermc.core.utils.point.World;
import com.typewritermc.engine.paper.entry.entity.ActivityContext;
import com.typewritermc.engine.paper.entry.entity.ActivityCreator;
import com.typewritermc.engine.paper.entry.entity.EntityActivity;
import com.typewritermc.engine.paper.entry.entity.IdleActivity;
import com.typewritermc.engine.paper.entry.entity.IndividualActivityContext;
import com.typewritermc.engine.paper.entry.entity.IndividualEntityActivity;
import com.typewritermc.engine.paper.entry.entity.PositionProperty;
import com.typewritermc.engine.paper.entry.entity.TickResult;
import com.typewritermc.engine.paper.entry.entries.EntityActivityEntry;
import com.typewritermc.engine.paper.entry.entries.EntityProperty;
import com.typewritermc.engine.paper.utils.PointKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001f\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000bH\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\u000bH\u0016J\u0010\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000bH\u0016R\u0016\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u000b0\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001c"}, d2={"Lcom/typewritermc/entity/entries/activity/PlayerWorldActivity;", "Lcom/typewritermc/engine/paper/entry/entity/IndividualEntityActivity;", "child", "Lcom/typewritermc/core/entries/Ref;", "Lcom/typewritermc/engine/paper/entry/entries/EntityActivityEntry;", "startPosition", "Lcom/typewritermc/engine/paper/entry/entity/PositionProperty;", "<init>", "(Lcom/typewritermc/core/entries/Ref;Lcom/typewritermc/engine/paper/entry/entity/PositionProperty;)V", "childActivity", "Lcom/typewritermc/engine/paper/entry/entity/EntityActivity;", "Lcom/typewritermc/engine/paper/entry/entity/IndividualActivityContext;", "world", "Lcom/typewritermc/core/utils/point/World;", "initialize", "", "context", "tick", "Lcom/typewritermc/engine/paper/entry/entity/TickResult;", "dispose", "currentPosition", "getCurrentPosition", "()Lcom/typewritermc/engine/paper/entry/entity/PositionProperty;", "currentProperties", "", "Lcom/typewritermc/engine/paper/entry/entries/EntityProperty;", "getCurrentProperties", "()Ljava/util/List;", "EntityExtension"})
public final class PlayerWorldActivity
implements IndividualEntityActivity {
    @NotNull
    private final Ref<? extends EntityActivityEntry> child;
    @NotNull
    private EntityActivity<? super IndividualActivityContext> childActivity;
    @NotNull
    private World world;

    public PlayerWorldActivity(@NotNull Ref<? extends EntityActivityEntry> child, @NotNull PositionProperty startPosition) {
        Intrinsics.checkNotNullParameter(child, (String)"child");
        Intrinsics.checkNotNullParameter((Object)startPosition, (String)"startPosition");
        this.child = child;
        this.childActivity = (EntityActivity)new IdleActivity(startPosition);
        this.world = startPosition.getWorld();
    }

    public void initialize(@NotNull IndividualActivityContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.world = PointKt.getPosition((Player)context.getViewer()).getWorld();
        EntityActivityEntry entityActivityEntry = (EntityActivityEntry)this.child.get();
        if (entityActivityEntry == null || (entityActivityEntry = ((ActivityCreator)entityActivityEntry).create((ActivityContext)context, this.getCurrentPosition())) == null) {
            entityActivityEntry = (EntityActivity)new IdleActivity(this.getCurrentPosition());
        }
        this.childActivity = entityActivityEntry;
        this.childActivity.initialize((ActivityContext)context);
    }

    @NotNull
    public TickResult tick(@NotNull IndividualActivityContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        World playerWorld = PointKt.getPosition((Player)context.getViewer()).getWorld();
        if (!Intrinsics.areEqual((Object)playerWorld, (Object)this.world)) {
            this.childActivity.dispose((ActivityContext)context);
            this.world = playerWorld;
            EntityActivityEntry entityActivityEntry = (EntityActivityEntry)this.child.get();
            if (entityActivityEntry == null || (entityActivityEntry = ((ActivityCreator)entityActivityEntry).create((ActivityContext)context, this.getCurrentPosition())) == null) {
                entityActivityEntry = (EntityActivity)new IdleActivity(this.getCurrentPosition());
            }
            this.childActivity = entityActivityEntry;
            this.childActivity.initialize((ActivityContext)context);
        }
        return this.childActivity.tick((ActivityContext)context);
    }

    public void dispose(@NotNull IndividualActivityContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        PositionProperty oldPosition = this.getCurrentPosition();
        this.childActivity.dispose((ActivityContext)context);
        this.childActivity = (EntityActivity)new IdleActivity(oldPosition);
    }

    @NotNull
    public PositionProperty getCurrentPosition() {
        return this.childActivity.getCurrentPosition().withWorld(this.world);
    }

    @NotNull
    public List<EntityProperty> getCurrentProperties() {
        return this.childActivity.getCurrentProperties();
    }
}

