/*
 * Decompiled with CFR 0.152.
 */
package com.typewritermc.entity.entries.activity;

import com.typewritermc.core.entries.Ref;
import com.typewritermc.core.utils.point.Point;
import com.typewritermc.core.utils.point.Position;
import com.typewritermc.core.utils.point.PositionKt;
import com.typewritermc.engine.paper.entry.entity.ActivityContext;
import com.typewritermc.engine.paper.entry.entity.ActivityCreator;
import com.typewritermc.engine.paper.entry.entity.EntityActivity;
import com.typewritermc.engine.paper.entry.entity.GenericEntityActivity;
import com.typewritermc.engine.paper.entry.entity.IdleActivity;
import com.typewritermc.engine.paper.entry.entity.PositionProperty;
import com.typewritermc.engine.paper.entry.entity.TickResult;
import com.typewritermc.engine.paper.entry.entries.EntityActivityEntry;
import com.typewritermc.engine.paper.entry.entries.EntityProperty;
import com.typewritermc.entity.entries.activity.NavigationActivity;
import com.typewritermc.entity.entries.activity.TargetLocationActivityKt;
import com.typewritermc.roadnetwork.RoadNetwork;
import com.typewritermc.roadnetwork.RoadNetworkEntry;
import com.typewritermc.roadnetwork.gps.GPS;
import com.typewritermc.roadnetwork.gps.PointToPointGPS;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0003 !\"B5\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u000e\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0003\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0011H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0014\u001a\u00020\u0011H\u0016J\u0010\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0011H\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006#"}, d2={"Lcom/typewritermc/entity/entries/activity/TargetLocationActivity;", "Lcom/typewritermc/engine/paper/entry/entity/GenericEntityActivity;", "network", "Lcom/typewritermc/core/entries/Ref;", "Lcom/typewritermc/roadnetwork/RoadNetworkEntry;", "targetPosition", "Lcom/typewritermc/core/utils/point/Position;", "idleActivity", "Lcom/typewritermc/engine/paper/entry/entries/EntityActivityEntry;", "startPosition", "Lcom/typewritermc/engine/paper/entry/entity/PositionProperty;", "<init>", "(Lcom/typewritermc/core/entries/Ref;Lcom/typewritermc/core/utils/point/Position;Lcom/typewritermc/core/entries/Ref;Lcom/typewritermc/engine/paper/entry/entity/PositionProperty;)V", "state", "Lcom/typewritermc/entity/entries/activity/TargetLocationActivity$State;", "currentActivity", "Lcom/typewritermc/engine/paper/entry/entity/EntityActivity;", "Lcom/typewritermc/engine/paper/entry/entity/ActivityContext;", "initialize", "", "context", "tick", "Lcom/typewritermc/engine/paper/entry/entity/TickResult;", "dispose", "currentPosition", "getCurrentPosition", "()Lcom/typewritermc/engine/paper/entry/entity/PositionProperty;", "currentProperties", "", "Lcom/typewritermc/engine/paper/entry/entries/EntityProperty;", "getCurrentProperties", "()Ljava/util/List;", "State", "IdleState", "NavigatingState", "EntityExtension"})
public final class TargetLocationActivity
implements GenericEntityActivity {
    @NotNull
    private final Ref<RoadNetworkEntry> network;
    @NotNull
    private final Position targetPosition;
    @NotNull
    private final Ref<? extends EntityActivityEntry> idleActivity;
    @NotNull
    private State state;
    @NotNull
    private EntityActivity<ActivityContext> currentActivity;

    public TargetLocationActivity(@NotNull Ref<RoadNetworkEntry> network, @NotNull Position targetPosition, @NotNull Ref<? extends EntityActivityEntry> idleActivity, @NotNull PositionProperty startPosition) {
        Intrinsics.checkNotNullParameter(network, (String)"network");
        Intrinsics.checkNotNullParameter((Object)targetPosition, (String)"targetPosition");
        Intrinsics.checkNotNullParameter(idleActivity, (String)"idleActivity");
        Intrinsics.checkNotNullParameter((Object)startPosition, (String)"startPosition");
        this.network = network;
        this.targetPosition = targetPosition;
        this.idleActivity = idleActivity;
        this.state = new IdleState();
        this.currentActivity = (EntityActivity)new IdleActivity(startPosition);
    }

    public void initialize(@NotNull ActivityContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!this.state.isValid()) {
            this.state = this.state.nextState();
        }
        this.currentActivity = this.state.createActivity(context, this.getCurrentPosition());
        this.currentActivity.initialize(context);
    }

    @NotNull
    public TickResult tick(@NotNull ActivityContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!this.state.isValid()) {
            this.currentActivity.dispose(context);
            this.state = this.state.nextState();
            this.currentActivity = this.state.createActivity(context, this.getCurrentPosition());
            this.currentActivity.initialize(context);
        }
        return this.currentActivity.tick(context);
    }

    public void dispose(@NotNull ActivityContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        PositionProperty oldPosition = this.getCurrentPosition();
        this.currentActivity.dispose(context);
        this.currentActivity = (EntityActivity)new IdleActivity(oldPosition);
    }

    @NotNull
    public PositionProperty getCurrentPosition() {
        return this.currentActivity.getCurrentPosition();
    }

    @NotNull
    public List<EntityProperty> getCurrentProperties() {
        return this.currentActivity.getCurrentProperties();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0007\u001a\u00020\u0001H\u0016J\u001e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0006\u00a8\u0006\u000e"}, d2={"Lcom/typewritermc/entity/entries/activity/TargetLocationActivity$IdleState;", "Lcom/typewritermc/entity/entries/activity/TargetLocationActivity$State;", "<init>", "(Lcom/typewritermc/entity/entries/activity/TargetLocationActivity;)V", "isValid", "", "()Z", "nextState", "createActivity", "Lcom/typewritermc/engine/paper/entry/entity/EntityActivity;", "Lcom/typewritermc/engine/paper/entry/entity/ActivityContext;", "context", "currentLocation", "Lcom/typewritermc/engine/paper/entry/entity/PositionProperty;", "EntityExtension"})
    private final class IdleState
    implements State {
        @Override
        public boolean isValid() {
            Double d = PositionKt.distanceSqrt((Point)((Point)TargetLocationActivity.this.getCurrentPosition()), (Point)((Point)TargetLocationActivity.this.targetPosition));
            if (d == null) {
                return false;
            }
            double distance = d;
            return distance <= TargetLocationActivityKt.access$getLocationActivityRange() * TargetLocationActivityKt.access$getLocationActivityRange();
        }

        @Override
        @NotNull
        public State nextState() {
            return new NavigatingState();
        }

        @Override
        @NotNull
        public EntityActivity<ActivityContext> createActivity(@NotNull ActivityContext context, @NotNull PositionProperty currentLocation) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)currentLocation, (String)"currentLocation");
            EntityActivityEntry entityActivityEntry = (EntityActivityEntry)TargetLocationActivity.this.idleActivity.get();
            return (entityActivityEntry != null ? (ActivityCreator)entityActivityEntry : (ActivityCreator)IdleActivity.Companion).create(context, currentLocation);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0007\u001a\u00020\u0001H\u0016J\u001e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0006\u00a8\u0006\u000e"}, d2={"Lcom/typewritermc/entity/entries/activity/TargetLocationActivity$NavigatingState;", "Lcom/typewritermc/entity/entries/activity/TargetLocationActivity$State;", "<init>", "(Lcom/typewritermc/entity/entries/activity/TargetLocationActivity;)V", "isValid", "", "()Z", "nextState", "createActivity", "Lcom/typewritermc/engine/paper/entry/entity/EntityActivity;", "Lcom/typewritermc/engine/paper/entry/entity/ActivityContext;", "context", "currentLocation", "Lcom/typewritermc/engine/paper/entry/entity/PositionProperty;", "EntityExtension"})
    private final class NavigatingState
    implements State {
        @Override
        public boolean isValid() {
            Double d = PositionKt.distanceSqrt((Point)((Point)TargetLocationActivity.this.getCurrentPosition()), (Point)((Point)TargetLocationActivity.this.targetPosition));
            if (d == null) {
                return true;
            }
            double distance = d;
            return distance > TargetLocationActivityKt.access$getLocationActivityRange() * TargetLocationActivityKt.access$getLocationActivityRange();
        }

        @Override
        @NotNull
        public State nextState() {
            return new IdleState();
        }

        @Override
        @NotNull
        public EntityActivity<ActivityContext> createActivity(@NotNull ActivityContext context, @NotNull PositionProperty currentLocation) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)currentLocation, (String)"currentLocation");
            return (EntityActivity)new NavigationActivity((GPS)new PointToPointGPS(TargetLocationActivity.this.network, (Function2)new Function2<RoadNetwork, Continuation<? super Position>, Object>(currentLocation, null){
                int label;
                final /* synthetic */ PositionProperty $currentLocation;
                {
                    this.$currentLocation = $currentLocation;
                    super(2, $completion);
                }

                public final Object invokeSuspend(Object $result) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            return this.$currentLocation.toPosition();
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(RoadNetwork p1, Continuation<? super Position> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }, (Function2)new Function2<RoadNetwork, Continuation<? super Position>, Object>(TargetLocationActivity.this, null){
                int label;
                final /* synthetic */ TargetLocationActivity this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                public final Object invokeSuspend(Object $result) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            return TargetLocationActivity.access$getTargetPosition$p(this.this$0);
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(RoadNetwork p1, Continuation<? super Position> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), currentLocation);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\bb\u0018\u00002\u00020\u0001J\b\u0010\u0005\u001a\u00020\u0000H&J\u001e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH&R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0004\u00a8\u0006\f\u00c0\u0006\u0003"}, d2={"Lcom/typewritermc/entity/entries/activity/TargetLocationActivity$State;", "", "isValid", "", "()Z", "nextState", "createActivity", "Lcom/typewritermc/engine/paper/entry/entity/EntityActivity;", "Lcom/typewritermc/engine/paper/entry/entity/ActivityContext;", "context", "currentLocation", "Lcom/typewritermc/engine/paper/entry/entity/PositionProperty;", "EntityExtension"})
    private static interface State {
        public boolean isValid();

        @NotNull
        public State nextState();

        @NotNull
        public EntityActivity<ActivityContext> createActivity(@NotNull ActivityContext var1, @NotNull PositionProperty var2);
    }
}

