/*
 * Decompiled with CFR 0.152.
 */
package com.typewritermc.entity.entries.audience;

import com.typewritermc.core.entries.Ref;
import com.typewritermc.core.utils.point.Position;
import com.typewritermc.engine.paper.entry.entity.ActivityContext;
import com.typewritermc.engine.paper.entry.entity.IndividualActivityContext;
import com.typewritermc.engine.paper.entry.entity.PositionPropertyKt;
import com.typewritermc.engine.paper.entry.entries.EntityInstanceEntry;
import com.typewritermc.entity.entries.activity.NavigationActivityTaskState;
import com.typewritermc.roadnetwork.RoadNetworkEntry;
import com.typewritermc.roadnetwork.entries.PathStream;
import com.typewritermc.roadnetwork.entries.PathStreamDisplay;
import com.typewritermc.roadnetwork.gps.GPSEdge;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.RangesKt;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001BA\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0003\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\b\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020#H\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u0017@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006$"}, d2={"Lcom/typewritermc/entity/entries/audience/PathFindingPathStream;", "Lcom/typewritermc/roadnetwork/entries/PathStream;", "displays", "", "Lcom/typewritermc/roadnetwork/entries/PathStreamDisplay;", "player", "Lorg/bukkit/entity/Player;", "roadNetwork", "Lcom/typewritermc/core/entries/Ref;", "Lcom/typewritermc/roadnetwork/RoadNetworkEntry;", "edges", "Lcom/typewritermc/roadnetwork/gps/GPSEdge;", "speed", "", "<init>", "(Ljava/util/List;Lorg/bukkit/entity/Player;Lcom/typewritermc/core/entries/Ref;Ljava/util/List;D)V", "getPlayer", "()Lorg/bukkit/entity/Player;", "getRoadNetwork", "()Lcom/typewritermc/core/entries/Ref;", "navigator", "Lcom/typewritermc/entity/entries/activity/NavigationActivityTaskState$Walking;", "value", "", "currentEdgeIndex", "setCurrentEdgeIndex", "(I)V", "currentEdge", "getCurrentEdge", "()Lcom/typewritermc/roadnetwork/gps/GPSEdge;", "forwardPath", "Lcom/typewritermc/core/utils/point/Position;", "shouldContinue", "", "dispose", "", "EntityExtension"})
@SourceDebugExtension(value={"SMAP\nPathFindingPathStream.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PathFindingPathStream.kt\ncom/typewritermc/entity/entries/audience/PathFindingPathStream\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 EntryReference.kt\ncom/typewritermc/core/entries/EntryReferenceKt\n*L\n1#1,113:1\n1#2:114\n6#3:115\n*S KotlinDebug\n*F\n+ 1 PathFindingPathStream.kt\ncom/typewritermc/entity/entries/audience/PathFindingPathStream\n*L\n89#1:115\n*E\n"})
public final class PathFindingPathStream
extends PathStream {
    @NotNull
    private final Player player;
    @NotNull
    private final Ref<RoadNetworkEntry> roadNetwork;
    @NotNull
    private final List<GPSEdge> edges;
    private final double speed;
    @NotNull
    private NavigationActivityTaskState.Walking navigator;
    private int currentEdgeIndex;

    public PathFindingPathStream(@NotNull List<? extends PathStreamDisplay> displays, @NotNull Player player, @NotNull Ref<RoadNetworkEntry> roadNetwork, @NotNull List<GPSEdge> edges, double speed) {
        Intrinsics.checkNotNullParameter(displays, (String)"displays");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter(roadNetwork, (String)"roadNetwork");
        Intrinsics.checkNotNullParameter(edges, (String)"edges");
        super(displays);
        this.player = player;
        this.roadNetwork = roadNetwork;
        this.edges = edges;
        this.speed = speed;
        if (!(!((Collection)this.edges).isEmpty())) {
            boolean bl = false;
            String string = "There must be at least 1 edge for the entity to walk";
            throw new IllegalArgumentException(string.toString());
        }
        this.navigator = new NavigationActivityTaskState.Walking(this.roadNetwork, this.getCurrentEdge(), PositionPropertyKt.toProperty((Position)this.getCurrentEdge().getStart()), (float)this.speed, 0);
    }

    @NotNull
    public final Player getPlayer() {
        return this.player;
    }

    @NotNull
    public final Ref<RoadNetworkEntry> getRoadNetwork() {
        return this.roadNetwork;
    }

    private final void setCurrentEdgeIndex(int value) {
        this.currentEdgeIndex = value;
        this.setStartTime(System.currentTimeMillis());
    }

    private final GPSEdge getCurrentEdge() {
        return this.edges.get(RangesKt.coerceIn((int)this.currentEdgeIndex, (ClosedRange)((ClosedRange)RangesKt.until((int)0, (int)this.edges.size()))));
    }

    @NotNull
    public Position forwardPath() {
        if (!(this.currentEdgeIndex < this.edges.size())) {
            boolean bl = false;
            String string = "No more edges to walk on";
            throw new IllegalArgumentException(string.toString());
        }
        boolean $i$f$emptyRef = false;
        this.navigator.tick((ActivityContext)new IndividualActivityContext(new Ref("", Reflection.getOrCreateKotlinClass(EntityInstanceEntry.class), null, 4, null), this.player, true, null, 8, null));
        Position position = this.navigator.position().toPosition();
        if (!this.navigator.isComplete()) {
            return position;
        }
        int n = this.currentEdgeIndex;
        this.setCurrentEdgeIndex(n + 1);
        if (!this.shouldContinue()) {
            return position;
        }
        this.navigator = new NavigationActivityTaskState.Walking(this.roadNetwork, this.getCurrentEdge(), PositionPropertyKt.toProperty((Position)position), (float)this.speed, 0);
        return position;
    }

    public boolean shouldContinue() {
        return this.currentEdgeIndex < this.edges.size();
    }

    public void dispose() {
        super.dispose();
        this.navigator.dispose();
    }
}

