/*
 * Decompiled with CFR 0.152.
 */
package com.typewritermc.entity.entries.entity;

import com.github.retrooper.packetevents.protocol.entity.type.EntityType;
import com.typewritermc.core.utils.point.Point;
import com.typewritermc.engine.paper.entry.entity.EntityState;
import com.typewritermc.engine.paper.entry.entity.FakeEntity;
import com.typewritermc.engine.paper.entry.entity.PositionProperty;
import com.typewritermc.engine.paper.entry.entries.EntityProperty;
import com.typewritermc.engine.paper.utils.EntityExtensionsKt;
import com.typewritermc.engine.paper.utils.PointKt;
import com.typewritermc.entity.entries.entity.custom.EntityTypePropertyKt;
import java.util.List;
import java.util.UUID;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.tofaa.entitylib.EntityLib;
import me.tofaa.entitylib.meta.EntityMeta;
import me.tofaa.entitylib.meta.projectile.ThrownExpBottleMeta;
import me.tofaa.entitylib.meta.types.LivingEntityMeta;
import me.tofaa.entitylib.wrapper.WrapperEntity;
import me.tofaa.entitylib.wrapper.WrapperExperienceOrbEntity;
import me.tofaa.entitylib.wrapper.WrapperLivingEntity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0016J\u0010\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u001cH&J\u0010\u0010\u001f\u001a\u00020\u00192\u0006\u0010 \u001a\u00020!H\u0016J\u0010\u0010\"\u001a\u00020\u00192\u0006\u0010\n\u001a\u00020\u0001H\u0016J\u0010\u0010#\u001a\u00020\u00192\u0006\u0010\n\u001a\u00020\u0001H\u0016J\u0011\u0010$\u001a\u00020%2\u0006\u0010\u0010\u001a\u00020\u0011H\u0096\u0002J\b\u0010&\u001a\u00020\u0019H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001b\u0010\n\u001a\u00020\u000b8DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0010\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006'"}, d2={"Lcom/typewritermc/entity/entries/entity/WrapperFakeEntity;", "Lcom/typewritermc/engine/paper/entry/entity/FakeEntity;", "type", "Lcom/github/retrooper/packetevents/protocol/entity/type/EntityType;", "player", "Lorg/bukkit/entity/Player;", "<init>", "(Lcom/github/retrooper/packetevents/protocol/entity/type/EntityType;Lorg/bukkit/entity/Player;)V", "getType", "()Lcom/github/retrooper/packetevents/protocol/entity/type/EntityType;", "entity", "Lme/tofaa/entitylib/wrapper/WrapperEntity;", "getEntity", "()Lme/tofaa/entitylib/wrapper/WrapperEntity;", "entity$delegate", "Lkotlin/Lazy;", "entityId", "", "getEntityId", "()I", "state", "Lcom/typewritermc/engine/paper/entry/entity/EntityState;", "getState", "()Lcom/typewritermc/engine/paper/entry/entity/EntityState;", "applyProperties", "", "properties", "", "Lcom/typewritermc/engine/paper/entry/entries/EntityProperty;", "applyProperty", "property", "spawn", "location", "Lcom/typewritermc/engine/paper/entry/entity/PositionProperty;", "addPassenger", "removePassenger", "contains", "", "dispose", "EntityExtension"})
@SourceDebugExtension(value={"SMAP\nWrapperFakeEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WrapperFakeEntity.kt\ncom/typewritermc/entity/entries/entity/WrapperFakeEntity\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,82:1\n1869#2,2:83\n*S KotlinDebug\n*F\n+ 1 WrapperFakeEntity.kt\ncom/typewritermc/entity/entries/entity/WrapperFakeEntity\n*L\n43#1:83,2\n*E\n"})
public abstract class WrapperFakeEntity
extends FakeEntity {
    @NotNull
    private final EntityType type;
    @NotNull
    private final Lazy entity$delegate;

    public WrapperFakeEntity(@NotNull EntityType type, @NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        super(player);
        this.type = type;
        this.entity$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, () -> WrapperFakeEntity.entity_delegate$lambda$0(this));
    }

    @NotNull
    public final EntityType getType() {
        return this.type;
    }

    @NotNull
    protected final WrapperEntity getEntity() {
        Lazy lazy = this.entity$delegate;
        return (WrapperEntity)lazy.getValue();
    }

    public int getEntityId() {
        return this.getEntity().getEntityId();
    }

    @NotNull
    public EntityState getState() {
        return EntityTypePropertyKt.state(this.type, this.getProperties());
    }

    public void applyProperties(@NotNull List<? extends EntityProperty> properties) {
        Intrinsics.checkNotNullParameter(properties, (String)"properties");
        this.getEntity().getEntityMeta().setNotifyAboutChanges(false);
        Iterable $this$forEach$iv = properties;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EntityProperty it = (EntityProperty)element$iv;
            boolean bl = false;
            if (it instanceof PositionProperty) {
                EntityExtensionsKt.move((WrapperEntity)this.getEntity(), (PositionProperty)((PositionProperty)it));
                continue;
            }
            this.applyProperty(it);
        }
        this.getEntity().getEntityMeta().setNotifyAboutChanges(true);
    }

    public abstract void applyProperty(@NotNull EntityProperty var1);

    public void spawn(@NotNull PositionProperty location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        this.getEntity().spawn(PointKt.toPacketLocation((Point)((Point)location)));
        this.getEntity().addViewer(this.getPlayer().getUniqueId());
        super.spawn(location);
    }

    public void addPassenger(@NotNull FakeEntity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        if (entity.getEntityId() == this.getEntityId()) {
            return;
        }
        if (this.getEntity().hasPassenger(entity.getEntityId())) {
            return;
        }
        this.getEntity().addPassenger(entity.getEntityId());
    }

    public void removePassenger(@NotNull FakeEntity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        if (entity.getEntityId() == this.getEntityId()) {
            return;
        }
        if (!this.getEntity().hasPassenger(entity.getEntityId())) {
            return;
        }
        this.getEntity().removePassenger(entity.getEntityId());
    }

    public boolean contains(int entityId) {
        return entityId == this.getEntity().getEntityId();
    }

    public void dispose() {
        super.dispose();
        this.getEntity().despawn();
        this.getEntity().remove();
    }

    private static final WrapperEntity entity_delegate$lambda$0(WrapperFakeEntity this$0) {
        EntityMeta metaData;
        UUID uUID = EntityLib.getPlatform().getEntityUuidProvider().provide(this$0.type);
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"provide(...)");
        UUID uuid = uUID;
        int entityId = EntityLib.getPlatform().getEntityIdProvider().provide(uuid, this$0.type);
        EntityMeta entityMeta = EntityMeta.createMeta((int)entityId, (EntityType)this$0.type);
        Intrinsics.checkNotNullExpressionValue((Object)entityMeta, (String)"createMeta(...)");
        EntityMeta entityMeta2 = metaData = entityMeta;
        return entityMeta2 instanceof LivingEntityMeta ? (WrapperEntity)new WrapperLivingEntity(entityId, uuid, this$0.type, metaData) : (entityMeta2 instanceof ThrownExpBottleMeta ? (WrapperEntity)new WrapperExperienceOrbEntity(entityId, uuid, this$0.type, metaData) : new WrapperEntity(entityId, uuid, this$0.type, metaData));
    }
}

