/*
 * Decompiled with CFR 0.152.
 */
package com.typewritermc.entity.entries.entity.minecraft;

import com.github.retrooper.packetevents.protocol.entity.pose.EntityPose;
import com.github.retrooper.packetevents.protocol.entity.type.EntityType;
import com.github.retrooper.packetevents.protocol.entity.type.EntityTypes;
import com.github.retrooper.packetevents.protocol.player.TextureProperty;
import com.github.retrooper.packetevents.protocol.player.UserProfile;
import com.github.retrooper.packetevents.wrapper.PacketWrapper;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerTeams;
import com.typewritermc.core.utils.point.Point;
import com.typewritermc.engine.paper.entry.entity.EntityState;
import com.typewritermc.engine.paper.entry.entity.FakeEntity;
import com.typewritermc.engine.paper.entry.entity.PositionProperty;
import com.typewritermc.engine.paper.entry.entity.SkinProperty;
import com.typewritermc.engine.paper.entry.entries.EntityProperty;
import com.typewritermc.engine.paper.entry.entries.Var;
import com.typewritermc.engine.paper.extensions.packetevents.PlayerPacketsKt;
import com.typewritermc.engine.paper.utils.EntityExtensionsKt;
import com.typewritermc.engine.paper.utils.MiniMessagesKt;
import com.typewritermc.engine.paper.utils.PointKt;
import com.typewritermc.entity.entries.data.minecraft.GenericDataKt;
import com.typewritermc.entity.entries.data.minecraft.PoseProperty;
import com.typewritermc.entity.entries.data.minecraft.living.LivingDataKt;
import com.typewritermc.entity.entries.entity.custom.EntityTypePropertyKt;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import me.tofaa.entitylib.EntityLib;
import me.tofaa.entitylib.meta.EntityMeta;
import me.tofaa.entitylib.meta.types.PlayerMeta;
import me.tofaa.entitylib.wrapper.WrapperEntity;
import me.tofaa.entitylib.wrapper.WrapperPlayer;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0016\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0016J\u0010\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u000b\u001a\u00020\u0001H\u0016J\u0010\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u000b\u001a\u00020\u0001H\u0016J\u0011\u0010\u001f\u001a\u00020 2\u0006\u0010\r\u001a\u00020\u000eH\u0096\u0002J\b\u0010!\u001a\u00020\u0016H\u0016J\u0014\u0010\"\u001a\u00020\u00162\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0002J\b\u0010#\u001a\u00020\u0016H\u0002R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006$"}, d2={"Lcom/typewritermc/entity/entries/entity/minecraft/PlayerEntity;", "Lcom/typewritermc/engine/paper/entry/entity/FakeEntity;", "player", "Lorg/bukkit/entity/Player;", "displayName", "Lcom/typewritermc/engine/paper/entry/entries/Var;", "", "<init>", "(Lorg/bukkit/entity/Player;Lcom/typewritermc/engine/paper/entry/entries/Var;)V", "sitEntity", "Lme/tofaa/entitylib/wrapper/WrapperEntity;", "entity", "Lme/tofaa/entitylib/wrapper/WrapperPlayer;", "entityId", "", "getEntityId", "()I", "state", "Lcom/typewritermc/engine/paper/entry/entity/EntityState;", "getState", "()Lcom/typewritermc/engine/paper/entry/entity/EntityState;", "applyProperties", "", "properties", "", "Lcom/typewritermc/engine/paper/entry/entries/EntityProperty;", "spawn", "location", "Lcom/typewritermc/engine/paper/entry/entity/PositionProperty;", "addPassenger", "removePassenger", "contains", "", "dispose", "sit", "unsit", "EntityExtension"})
@SourceDebugExtension(value={"SMAP\nPlayerEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlayerEntity.kt\ncom/typewritermc/entity/entries/entity/minecraft/PlayerEntity\n+ 2 PlayerPackets.kt\ncom/typewritermc/engine/paper/extensions/packetevents/PlayerPacketsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 FakeEntity.kt\ncom/typewritermc/engine/paper/entry/entity/FakeEntity\n*L\n1#1,219:1\n48#2,11:220\n1869#3,2:231\n55#4:233\n*S KotlinDebug\n*F\n+ 1 PlayerEntity.kt\ncom/typewritermc/entity/entries/entity/minecraft/PlayerEntity\n*L\n95#1:220,11\n107#1:231,2\n199#1:233\n*E\n"})
public final class PlayerEntity
extends FakeEntity {
    @Nullable
    private WrapperEntity sitEntity;
    @NotNull
    private WrapperPlayer entity;

    public PlayerEntity(@NotNull Player player, @NotNull Var<String> displayName) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter(displayName, (String)"displayName");
        super(player);
        UUID uuid = UUID.randomUUID();
        int entityId = 0;
        do {
            entityId = EntityLib.getPlatform().getEntityIdProvider().provide(uuid, EntityTypes.PLAYER);
        } while (EntityLib.getApi().getEntity(entityId) != null);
        this.entity = new WrapperPlayer(new UserProfile(uuid, "\u2063" + StringsKt.replace$default((String)MiniMessagesKt.stripped((String)((String)Var.get$default(displayName, (Player)player, null, (int)2, null))), (String)" ", (String)"_", (boolean)false, (int)4, null)), entityId);
        this.entity.setInTablist(false);
        WrapperEntity $this$meta_u24default$iv = (WrapperEntity)this.entity;
        boolean preventNotification$iv = false;
        boolean $i$f$meta = false;
        EntityMeta entityMeta = $this$meta_u24default$iv.getEntityMeta();
        Intrinsics.checkNotNullExpressionValue((Object)entityMeta, (String)"getEntityMeta(...)");
        EntityMeta meta$iv = entityMeta;
        if (meta$iv instanceof PlayerMeta) {
            meta$iv.setNotifyAboutChanges(false);
            PlayerMeta $this$_init__u24lambda_u240 = (PlayerMeta)meta$iv;
            boolean bl = false;
            $this$_init__u24lambda_u240.setCapeEnabled(true);
            $this$_init__u24lambda_u240.setHatEnabled(true);
            $this$_init__u24lambda_u240.setJacketEnabled(true);
            $this$_init__u24lambda_u240.setLeftSleeveEnabled(true);
            $this$_init__u24lambda_u240.setRightSleeveEnabled(true);
            $this$_init__u24lambda_u240.setLeftLegEnabled(true);
            $this$_init__u24lambda_u240.setRightLegEnabled(true);
            meta$iv.setNotifyAboutChanges(true);
        }
    }

    public int getEntityId() {
        return this.entity.getEntityId();
    }

    @NotNull
    public EntityState getState() {
        EntityType entityType = this.entity.getEntityType();
        Intrinsics.checkNotNullExpressionValue((Object)entityType, (String)"getEntityType(...)");
        return EntityTypePropertyKt.state(entityType, this.getProperties());
    }

    public void applyProperties(@NotNull List<? extends EntityProperty> properties) {
        Intrinsics.checkNotNullParameter(properties, (String)"properties");
        Iterable $this$forEach$iv = properties;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EntityProperty property = (EntityProperty)element$iv;
            boolean bl = false;
            EntityProperty entityProperty = property;
            if (entityProperty instanceof PositionProperty) {
                WrapperEntity wrapperEntity = this.sitEntity;
                boolean bl2 = wrapperEntity != null ? wrapperEntity.isSpawned() : false;
                if (bl2) {
                    WrapperEntity wrapperEntity2 = this.sitEntity;
                    if (wrapperEntity2 != null) {
                        EntityExtensionsKt.move((WrapperEntity)wrapperEntity2, (PositionProperty)((PositionProperty)property));
                    }
                }
                EntityExtensionsKt.move((WrapperEntity)((WrapperEntity)this.entity), (PositionProperty)((PositionProperty)property));
            } else if (entityProperty instanceof SkinProperty) {
                this.entity.setTextureProperties(CollectionsKt.listOf((Object)new TextureProperty("textures", ((SkinProperty)property).getTexture(), ((SkinProperty)property).getSignature())));
            } else if (entityProperty instanceof PoseProperty) {
                if (((PoseProperty)property).getPose() == EntityPose.SITTING) {
                    PlayerEntity.sit$default(this, null, 1, null);
                } else {
                    this.unsit();
                }
            }
            if (GenericDataKt.applyGenericEntityData((WrapperEntity)this.entity, property) || LivingDataKt.applyLivingEntityData((WrapperEntity)this.entity, property)) continue;
        }
    }

    public void spawn(@NotNull PositionProperty location) {
        Object[] objectArray;
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        if (this.sitEntity != null) {
            WrapperEntity wrapperEntity = this.sitEntity;
            if (wrapperEntity != null) {
                wrapperEntity.spawn(PointKt.toPacketLocation((Point)((Point)location)));
            }
            WrapperEntity wrapperEntity2 = this.sitEntity;
            if (wrapperEntity2 != null) {
                wrapperEntity2.addViewer(this.getPlayer().getUniqueId());
            }
        }
        this.entity.spawn(PointKt.toPacketLocation((Point)((Point)location)));
        this.entity.addViewer(this.getPlayer().getUniqueId());
        WrapperEntity wrapperEntity = this.sitEntity;
        if (wrapperEntity != null) {
            objectArray = new WrapperEntity[]{this.entity};
            wrapperEntity.addPassengers(objectArray);
        }
        WrapperPlayServerTeams.ScoreBoardTeamInfo info = new WrapperPlayServerTeams.ScoreBoardTeamInfo((Component)Component.empty(), null, null, WrapperPlayServerTeams.NameTagVisibility.NEVER, WrapperPlayServerTeams.CollisionRule.NEVER, NamedTextColor.WHITE, WrapperPlayServerTeams.OptionData.NONE);
        String string = "typewriter-" + this.getEntityId();
        objectArray = new String[1];
        String string2 = this.entity.getUsername();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getUsername(...)");
        objectArray[0] = StringsKt.take((String)string2, (int)16);
        PlayerPacketsKt.sendPacketTo((PacketWrapper)((PacketWrapper)new WrapperPlayServerTeams(string, WrapperPlayServerTeams.TeamMode.CREATE, info, (String[])objectArray)), (Player)this.getPlayer());
        super.spawn(location);
    }

    public void addPassenger(@NotNull FakeEntity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        if (entity.getEntityId() == this.getEntityId()) {
            return;
        }
        if (this.entity.hasPassenger(entity.getEntityId())) {
            return;
        }
        this.entity.addPassenger(entity.getEntityId());
    }

    public void removePassenger(@NotNull FakeEntity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        if (entity.getEntityId() == this.getEntityId()) {
            return;
        }
        if (!this.entity.hasPassenger(entity.getEntityId())) {
            return;
        }
        this.entity.removePassenger(entity.getEntityId());
    }

    public boolean contains(int entityId) {
        WrapperEntity wrapperEntity = this.sitEntity;
        if (wrapperEntity != null) {
            WrapperEntity it = wrapperEntity;
            boolean bl = false;
            if (it.getEntityId() == entityId) {
                return true;
            }
        }
        return this.getEntityId() == entityId;
    }

    public void dispose() {
        PlayerPacketsKt.sendPacketTo((PacketWrapper)((PacketWrapper)new WrapperPlayServerTeams("typewriter-" + this.getEntityId(), WrapperPlayServerTeams.TeamMode.REMOVE, Optional.empty(), new String[0])), (Player)this.getPlayer());
        this.entity.despawn();
        this.entity.remove();
        WrapperEntity wrapperEntity = this.sitEntity;
        if (wrapperEntity != null) {
            wrapperEntity.despawn();
        }
        WrapperEntity wrapperEntity2 = this.sitEntity;
        if (wrapperEntity2 != null) {
            wrapperEntity2.remove();
        }
        this.sitEntity = null;
    }

    private final void sit(PositionProperty location) {
        block6: {
            PositionProperty positionProperty = location;
            if (positionProperty == null) {
                FakeEntity this_$iv = this;
                boolean $i$f$property = false;
                positionProperty = (PositionProperty)this_$iv.property(Reflection.getOrCreateKotlinClass(PositionProperty.class));
                if (positionProperty == null) {
                    return;
                }
            }
            PositionProperty loc = positionProperty;
            if (this.sitEntity != null) {
                return;
            }
            WrapperEntity wrapperEntity = this.sitEntity = new WrapperEntity(EntityTypes.BLOCK_DISPLAY);
            if (wrapperEntity != null) {
                wrapperEntity.spawn(PointKt.toPacketLocation((Point)((Point)loc)));
            }
            WrapperEntity wrapperEntity2 = this.sitEntity;
            if (wrapperEntity2 != null) {
                wrapperEntity2.addViewer(this.getPlayer().getUniqueId());
            }
            if (!this.entity.isSpawned()) break block6;
            WrapperEntity wrapperEntity3 = this.sitEntity;
            if (wrapperEntity3 != null) {
                WrapperEntity[] wrapperEntityArray = new WrapperEntity[]{this.entity};
                wrapperEntity3.addPassengers(wrapperEntityArray);
            }
        }
    }

    static /* synthetic */ void sit$default(PlayerEntity playerEntity, PositionProperty positionProperty, int n, Object object) {
        if ((n & 1) != 0) {
            positionProperty = null;
        }
        playerEntity.sit(positionProperty);
    }

    private final void unsit() {
        WrapperEntity wrapperEntity = this.sitEntity;
        if (wrapperEntity == null) {
            return;
        }
        WrapperEntity entity = wrapperEntity;
        if (entity.hasPassenger((WrapperEntity)this.entity)) {
            WrapperEntity[] wrapperEntityArray = new WrapperEntity[]{this.entity};
            entity.removePassengers(wrapperEntityArray);
        }
        entity.removeViewer(this.getPlayer().getUniqueId());
        entity.despawn();
        entity.remove();
        this.sitEntity = null;
    }
}

