/*
 * Decompiled with CFR 0.152.
 */
package com.typewritermc.entity.entries.quest;

import com.typewritermc.core.entries.Query;
import com.typewritermc.core.entries.Ref;
import com.typewritermc.core.extension.annotations.Entry;
import com.typewritermc.core.extension.annotations.Help;
import com.typewritermc.core.utils.point.Position;
import com.typewritermc.engine.paper.entry.AudienceManagerKt;
import com.typewritermc.engine.paper.entry.Criteria;
import com.typewritermc.engine.paper.entry.PlaceholderParser;
import com.typewritermc.engine.paper.entry.entity.AudienceEntityDisplay;
import com.typewritermc.engine.paper.entry.entries.AudienceEntry;
import com.typewritermc.engine.paper.entry.entries.AudienceFilter;
import com.typewritermc.engine.paper.entry.entries.ConstVar;
import com.typewritermc.engine.paper.entry.entries.EntityDefinitionEntry;
import com.typewritermc.engine.paper.entry.entries.EntityInstanceEntry;
import com.typewritermc.engine.paper.entry.entries.SpeakerEntry;
import com.typewritermc.engine.paper.entry.entries.Var;
import com.typewritermc.engine.paper.entry.entries.VariableEntryKt;
import com.typewritermc.entity.entries.quest.InteractEntityObjectiveKt;
import com.typewritermc.quest.LocatableObjective;
import com.typewritermc.quest.QuestEntry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Entry(name="interact_entity_objective", description="Interact with an entity", color="#8A2BE2", icon="ph:hand-tap-fill")
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u008b\u0001\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\u0016\b\u0002\u0010\u0005\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\b0\u00070\u0006\u0012\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007\u0012\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0006\u0012\u0010\b\u0002\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\u0007\u0012\u0014\b\u0002\u0010\u000f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00110\u0010\u0012\u000e\b\u0002\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u0010\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0018\u0010-\u001a\b\u0012\u0004\u0012\u00020.0\u00062\b\u0010/\u001a\u0004\u0018\u000100H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0017R\"\u0010\u0005\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\b0\u00070\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001aR$\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\u00078\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u001e\u0010\u001f\u001a\u0004\b \u0010\u001cR(\u0010\u000f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00110\u00108\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b!\u0010\u001f\u001a\u0004\b\"\u0010#R\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010#R\u001a\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00030\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R!\u0010(\u001a\b\u0012\u0004\u0012\u00020)0\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b+\u0010,\u001a\u0004\b*\u0010\u001a\u00a8\u00061"}, d2={"Lcom/typewritermc/entity/entries/quest/InteractEntityObjective;", "Lcom/typewritermc/quest/LocatableObjective;", "id", "", "name", "children", "", "Lcom/typewritermc/core/entries/Ref;", "Lcom/typewritermc/engine/paper/entry/entries/AudienceEntry;", "quest", "Lcom/typewritermc/quest/QuestEntry;", "criteria", "Lcom/typewritermc/engine/paper/entry/Criteria;", "entity", "Lcom/typewritermc/engine/paper/entry/entries/EntityDefinitionEntry;", "overrideDisplay", "Ljava/util/Optional;", "Lcom/typewritermc/engine/paper/entry/entries/Var;", "priorityOverride", "", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Lcom/typewritermc/core/entries/Ref;Ljava/util/List;Lcom/typewritermc/core/entries/Ref;Ljava/util/Optional;Ljava/util/Optional;)V", "getId", "()Ljava/lang/String;", "getName", "getChildren", "()Ljava/util/List;", "getQuest", "()Lcom/typewritermc/core/entries/Ref;", "getCriteria", "getEntity$annotations", "()V", "getEntity", "getOverrideDisplay$annotations", "getOverrideDisplay", "()Ljava/util/Optional;", "getPriorityOverride", "display", "getDisplay", "()Lcom/typewritermc/engine/paper/entry/entries/Var;", "displays", "Lcom/typewritermc/engine/paper/entry/entity/AudienceEntityDisplay;", "getDisplays", "displays$delegate", "Lkotlin/Lazy;", "positions", "Lcom/typewritermc/core/utils/point/Position;", "player", "Lorg/bukkit/entity/Player;", "EntityExtension"})
@SourceDebugExtension(value={"SMAP\nInteractEntityObjective.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InteractEntityObjective.kt\ncom/typewritermc/entity/entries/quest/InteractEntityObjective\n+ 2 EntryReference.kt\ncom/typewritermc/core/entries/EntryReferenceKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 AudienceManager.kt\ncom/typewritermc/engine/paper/entry/AudienceManagerKt\n+ 6 Query.kt\ncom/typewritermc/core/entries/Query$Companion\n*L\n1#1,56:1\n6#2:57\n6#2:58\n8#2:75\n774#3:59\n865#3,2:60\n1617#3,9:62\n1869#3:71\n1870#3:73\n1626#3:74\n1#4:72\n206#5:76\n100#6:77\n*S KotlinDebug\n*F\n+ 1 InteractEntityObjective.kt\ncom/typewritermc/entity/entries/quest/InteractEntityObjective\n*L\n32#1:57\n35#1:58\n47#1:75\n53#1:59\n53#1:60,2\n54#1:62,9\n54#1:71\n54#1:73\n54#1:74\n54#1:72\n47#1:76\n46#1:77\n*E\n"})
public final class InteractEntityObjective
implements LocatableObjective {
    @NotNull
    private final String id;
    @NotNull
    private final String name;
    @NotNull
    private final List<Ref<? extends AudienceEntry>> children;
    @NotNull
    private final Ref<QuestEntry> quest;
    @NotNull
    private final List<Criteria> criteria;
    @NotNull
    private final Ref<? extends EntityDefinitionEntry> entity;
    @NotNull
    private final Optional<Var<String>> overrideDisplay;
    @NotNull
    private final Optional<Integer> priorityOverride;
    @NotNull
    private final Lazy displays$delegate;

    public InteractEntityObjective(@NotNull String id, @NotNull String name, @NotNull List<? extends Ref<? extends AudienceEntry>> children, @NotNull Ref<QuestEntry> quest, @NotNull List<Criteria> criteria, @NotNull Ref<? extends EntityDefinitionEntry> entity, @NotNull Optional<Var<String>> overrideDisplay, @NotNull Optional<Integer> priorityOverride) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(children, (String)"children");
        Intrinsics.checkNotNullParameter(quest, (String)"quest");
        Intrinsics.checkNotNullParameter(criteria, (String)"criteria");
        Intrinsics.checkNotNullParameter(entity, (String)"entity");
        Intrinsics.checkNotNullParameter(overrideDisplay, (String)"overrideDisplay");
        Intrinsics.checkNotNullParameter(priorityOverride, (String)"priorityOverride");
        this.id = id;
        this.name = name;
        this.children = children;
        this.quest = quest;
        this.criteria = criteria;
        this.entity = entity;
        this.overrideDisplay = overrideDisplay;
        this.priorityOverride = priorityOverride;
        this.displays$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, () -> InteractEntityObjective.displays_delegate$lambda$4(this));
    }

    public /* synthetic */ InteractEntityObjective(String string, String string2, List list, Ref ref, List list2, Ref ref2, Optional optional, Optional optional2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        boolean $i$f$emptyRef;
        if ((n & 1) != 0) {
            string = "";
        }
        if ((n & 2) != 0) {
            string2 = "";
        }
        if ((n & 4) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 8) != 0) {
            $i$f$emptyRef = false;
            ref = new Ref("", Reflection.getOrCreateKotlinClass(QuestEntry.class), null, 4, null);
        }
        if ((n & 0x10) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        if ((n & 0x20) != 0) {
            $i$f$emptyRef = false;
            ref2 = new Ref("", Reflection.getOrCreateKotlinClass(EntityDefinitionEntry.class), null, 4, null);
        }
        if ((n & 0x40) != 0) {
            Optional<Var<String>> optional3 = Optional.empty();
            Intrinsics.checkNotNullExpressionValue(optional3, (String)"empty(...)");
            optional = optional3;
        }
        if ((n & 0x80) != 0) {
            Optional<Integer> optional4 = Optional.empty();
            Intrinsics.checkNotNullExpressionValue(optional4, (String)"empty(...)");
            optional2 = optional4;
        }
        this(string, string2, list, (Ref<QuestEntry>)ref, list2, (Ref<? extends EntityDefinitionEntry>)ref2, optional, optional2);
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public List<Ref<? extends AudienceEntry>> getChildren() {
        return this.children;
    }

    @NotNull
    public Ref<QuestEntry> getQuest() {
        return this.quest;
    }

    @NotNull
    public List<Criteria> getCriteria() {
        return this.criteria;
    }

    @NotNull
    public final Ref<? extends EntityDefinitionEntry> getEntity() {
        return this.entity;
    }

    @Help(text="The entity that the player needs to interact with.")
    public static /* synthetic */ void getEntity$annotations() {
    }

    @NotNull
    public final Optional<Var<String>> getOverrideDisplay() {
        return this.overrideDisplay;
    }

    @Help(text="The objective display that will be shown to the player. Use &lt;entity&gt; to replace the entity name.")
    public static /* synthetic */ void getOverrideDisplay$annotations() {
    }

    @NotNull
    public Optional<Integer> getPriorityOverride() {
        return this.priorityOverride;
    }

    @NotNull
    public Var<String> getDisplay() {
        Var var = this.overrideDisplay.orElseGet(InteractEntityObjective::_get_display_$lambda$0);
        Intrinsics.checkNotNullExpressionValue((Object)var, (String)"orElseGet(...)");
        return VariableEntryKt.map((Var)var, (arg_0, arg_1) -> InteractEntityObjective._get_display_$lambda$1(this, arg_0, arg_1));
    }

    private final List<AudienceEntityDisplay> getDisplays() {
        Lazy lazy = this.displays$delegate;
        return (List)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<Position> positions(@Nullable Player player) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        if (player == null) {
            return CollectionsKt.emptyList();
        }
        Iterable $this$filter$iv = this.getDisplays();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            AudienceEntityDisplay it = (AudienceEntityDisplay)element$iv$iv;
            boolean bl = false;
            UUID uUID = player.getUniqueId();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUniqueId(...)");
            if (!it.canView(uUID)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Position it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            AudienceEntityDisplay it = (AudienceEntityDisplay)element$iv$iv;
            boolean bl2 = false;
            UUID uUID = player.getUniqueId();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUniqueId(...)");
            if (it.position(uUID) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public PlaceholderParser parser() {
        return super.parser();
    }

    @Nullable
    public Object display(@NotNull Continuation<? super AudienceFilter> $completion) {
        return super.display($completion);
    }

    @NotNull
    public String display(@Nullable Player player) {
        return super.display(player);
    }

    private static final Var _get_display_$lambda$0() {
        return (Var)new ConstVar((Object)InteractEntityObjectiveKt.access$getDisplayTemplate());
    }

    private static final String _get_display_$lambda$1(InteractEntityObjective this$0, Player player, String value) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Object object = (EntityDefinitionEntry)this$0.entity.get();
        if (object == null || (object = ((SpeakerEntry)object).getDisplayName()) == null || (object = (String)Var.get$default((Var)object, (Player)player, null, (int)2, null)) == null) {
            object = "";
        }
        return StringsKt.replace$default((String)value, (String)"<entity>", (String)object, (boolean)false, (int)4, null);
    }

    private static final boolean displays_delegate$lambda$4$lambda$2(InteractEntityObjective this$0, EntityInstanceEntry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getDefinition(), this$0.entity);
    }

    private static final AudienceEntityDisplay displays_delegate$lambda$4$lambda$3(EntityInstanceEntry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        com.typewritermc.core.entries.Entry $this$ref$iv = (com.typewritermc.core.entries.Entry)it;
        boolean $i$f$ref = false;
        Ref $this$findDisplay$iv = new Ref($this$ref$iv.getId(), Reflection.getOrCreateKotlinClass(EntityInstanceEntry.class), $this$ref$iv);
        boolean $i$f$findDisplay = false;
        return (AudienceEntityDisplay)AudienceManagerKt.findDisplay((Ref)$this$findDisplay$iv, (KClass)Reflection.getOrCreateKotlinClass(AudienceEntityDisplay.class));
    }

    /*
     * WARNING - void declaration
     */
    private static final List displays_delegate$lambda$4(InteractEntityObjective this$0) {
        void this_$iv;
        Query.Companion companion = Query.Companion;
        Function1 filter$iv = arg_0 -> InteractEntityObjective.displays_delegate$lambda$4$lambda$2(this$0, arg_0);
        boolean $i$f$findWhere = false;
        return SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)this_$iv.findWhere(Reflection.getOrCreateKotlinClass(EntityInstanceEntry.class), filter$iv), InteractEntityObjective::displays_delegate$lambda$4$lambda$3));
    }

    public InteractEntityObjective() {
        this(null, null, null, null, null, null, null, null, 255, null);
    }
}

