/*
 * Decompiled with CFR 0.152.
 */
package com.typewritermc.quest;

import com.typewritermc.core.entries.Entry;
import com.typewritermc.core.entries.LibraryKt;
import com.typewritermc.core.entries.Ref;
import com.typewritermc.engine.paper.entry.BaseEntryKt;
import com.typewritermc.engine.paper.entry.Criteria;
import com.typewritermc.engine.paper.entry.entries.AudienceFilter;
import com.typewritermc.engine.paper.facts.FactListenerSubscription;
import com.typewritermc.engine.paper.facts.FactTrackerKt;
import com.typewritermc.engine.paper.facts.FactUpdateContext;
import com.typewritermc.engine.paper.utils.ServerExtensionsKt;
import com.typewritermc.quest.ObjectiveEntry;
import com.typewritermc.quest.QuestEntry;
import com.typewritermc.quest.QuestEntryKt;
import com.typewritermc.quest.QuestTrackerKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B#\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0019\u001a\u00020\u0013H\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/typewritermc/quest/ObjectiveAudienceFilter;", "Lcom/typewritermc/engine/paper/entry/entries/AudienceFilter;", "objective", "Lcom/typewritermc/core/entries/Ref;", "Lcom/typewritermc/quest/ObjectiveEntry;", "criteria", "", "Lcom/typewritermc/engine/paper/entry/Criteria;", "<init>", "(Lcom/typewritermc/core/entries/Ref;Ljava/util/List;)V", "factWatcherSubscriptions", "Ljava/util/concurrent/ConcurrentHashMap;", "Ljava/util/UUID;", "Lcom/typewritermc/engine/paper/facts/FactListenerSubscription;", "filter", "", "player", "Lorg/bukkit/entity/Player;", "onPlayerAdd", "", "onFactChange", "context", "Lcom/typewritermc/engine/paper/facts/FactUpdateContext;", "onPlayerRemove", "onPlayerFilterAdded", "dispose", "QuestExtension"})
@SourceDebugExtension(value={"SMAP\nQuestEntry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QuestEntry.kt\ncom/typewritermc/quest/ObjectiveAudienceFilter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,192:1\n1#2:193\n216#3,2:194\n1563#4:196\n1634#4,3:197\n*S KotlinDebug\n*F\n+ 1 QuestEntry.kt\ncom/typewritermc/quest/ObjectiveAudienceFilter\n*L\n155#1:194,2\n115#1:196\n115#1:197,3\n*E\n"})
public final class ObjectiveAudienceFilter
extends AudienceFilter {
    @NotNull
    private final Ref<ObjectiveEntry> objective;
    @NotNull
    private final List<Criteria> criteria;
    @NotNull
    private final ConcurrentHashMap<UUID, FactListenerSubscription> factWatcherSubscriptions;

    public ObjectiveAudienceFilter(@NotNull Ref<ObjectiveEntry> objective, @NotNull List<Criteria> criteria) {
        Intrinsics.checkNotNullParameter(objective, (String)"objective");
        Intrinsics.checkNotNullParameter(criteria, (String)"criteria");
        super(objective);
        this.objective = objective;
        this.criteria = criteria;
        this.factWatcherSubscriptions = new ConcurrentHashMap();
    }

    public boolean filter(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return BaseEntryKt.matches$default((Iterable)this.criteria, (Player)player, null, (int)2, null);
    }

    public void onPlayerAdd(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        this.factWatcherSubscriptions.compute(player.getUniqueId(), (arg_0, arg_1) -> ObjectiveAudienceFilter.onPlayerAdd$lambda$2((arg_0, arg_1) -> ObjectiveAudienceFilter.onPlayerAdd$lambda$1(player, this, arg_0, arg_1), arg_0, arg_1));
        super.onPlayerAdd(player);
    }

    private final void onFactChange(FactUpdateContext context) {
        this.refresh(context.getPlayer());
    }

    public void onPlayerRemove(@NotNull Player player) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            super.onPlayerRemove(player);
            FactListenerSubscription factListenerSubscription = this.factWatcherSubscriptions.remove(player.getUniqueId());
            if (factListenerSubscription == null) break block0;
            factListenerSubscription.cancel(player);
        }
    }

    public void onPlayerFilterAdded(@NotNull Player player) {
        int highestObjectivePriority;
        Comparable comparable;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        super.onPlayerFilterAdded(player);
        Ref<QuestEntry> ref = (Ref<QuestEntry>)this.objective.get();
        if (ref == null || (ref = ref.getQuest()) == null) {
            return;
        }
        Ref<QuestEntry> quest = ref;
        if (!QuestTrackerKt.isQuestActive(player, quest)) {
            return;
        }
        if (QuestTrackerKt.trackedQuest(player) == null) {
            QuestTrackerKt.trackQuest(player, quest);
            return;
        }
        Iterator iterator = QuestEntryKt.trackedShowingObjectives(player).iterator();
        if (!iterator.hasNext()) {
            comparable = null;
        } else {
            ObjectiveEntry it = (ObjectiveEntry)iterator.next();
            boolean bl = false;
            Comparable comparable2 = Integer.valueOf(LibraryKt.getPriority((Entry)((Entry)it)));
            while (iterator.hasNext()) {
                ObjectiveEntry it2 = (ObjectiveEntry)iterator.next();
                $i$a$-maxOfOrNull-ObjectiveAudienceFilter$onPlayerFilterAdded$highestObjectivePriority$1 = false;
                Comparable comparable3 = Integer.valueOf(LibraryKt.getPriority((Entry)((Entry)it2)));
                if (comparable2.compareTo(comparable3) >= 0) continue;
                comparable2 = comparable3;
            }
            comparable = comparable2;
        }
        Integer n = (Integer)comparable;
        int n2 = highestObjectivePriority = n != null ? n : 0;
        if (LibraryKt.getPriority(this.objective) < highestObjectivePriority) {
            return;
        }
        QuestTrackerKt.trackQuest(player, quest);
    }

    public void dispose() {
        super.dispose();
        Map $this$forEach$iv = this.factWatcherSubscriptions;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Player player;
            Map.Entry element$iv;
            Map.Entry entry2 = element$iv = iterator.next();
            boolean bl = false;
            UUID playerId = (UUID)entry2.getKey();
            FactListenerSubscription subscription = (FactListenerSubscription)entry2.getValue();
            if (ServerExtensionsKt.getServer().getPlayer(playerId) == null) continue;
            subscription.cancel(player);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final FactListenerSubscription onPlayerAdd$lambda$1(Player $player, ObjectiveAudienceFilter this$0, UUID uUID, FactListenerSubscription subscription) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)uUID, (String)"<unused var>");
        FactListenerSubscription factListenerSubscription = subscription;
        if (factListenerSubscription != null) {
            factListenerSubscription.cancel($player);
        }
        Iterable iterable = this$0.criteria;
        Player player = $player;
        boolean $i$f$map = false;
        void var6_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Criteria criteria = (Criteria)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getFact());
        }
        return FactTrackerKt.listenForFacts((Player)player, (List)((List)destination$iv$iv), (Function1)((Function1)new Function1<FactUpdateContext, Unit>((Object)this$0){

            public final void invoke(FactUpdateContext p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                ObjectiveAudienceFilter.access$onFactChange((ObjectiveAudienceFilter)((Object)this.receiver), p0);
            }
        }));
    }

    private static final FactListenerSubscription onPlayerAdd$lambda$2(Function2 $tmp0, Object p0, Object p1) {
        return (FactListenerSubscription)$tmp0.invoke(p0, p1);
    }

    public static final /* synthetic */ void access$onFactChange(ObjectiveAudienceFilter $this, FactUpdateContext context) {
        $this.onFactChange(context);
    }
}

