/*
 * Decompiled with CFR 0.152.
 */
package com.typewritermc.quest.entries.audience;

import com.typewritermc.core.entries.Ref;
import com.typewritermc.core.extension.annotations.Entry;
import com.typewritermc.core.extension.annotations.Help;
import com.typewritermc.engine.paper.entry.BaseEntryKt;
import com.typewritermc.engine.paper.entry.Criteria;
import com.typewritermc.engine.paper.entry.PlaceholderParser;
import com.typewritermc.engine.paper.entry.entries.AudienceEntry;
import com.typewritermc.engine.paper.entry.entries.AudienceFilter;
import com.typewritermc.engine.paper.entry.entries.ConstVar;
import com.typewritermc.engine.paper.entry.entries.Var;
import com.typewritermc.engine.paper.entry.entries.VariableEntryKt;
import com.typewritermc.engine.paper.extensions.placeholderapi.PlaceholderExpansionKt;
import com.typewritermc.engine.paper.utils.MiniMessagesKt;
import com.typewritermc.quest.ObjectiveEntry;
import com.typewritermc.quest.QuestEntry;
import com.typewritermc.quest.QuestEntryKt;
import com.typewritermc.quest.entries.audience.CompletableObjectiveKt;
import java.util.List;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Entry(name="completable_objective", description="An objective that can show a completed stage", color="#8A2BE2", icon="fluent:clipboard-checkmark-16-filled")
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0083\u0001\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0016\b\u0002\u0010\b\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\n0\u00060\t\u0012\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\t\u0012\u000e\b\u0002\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\t\u0012\u000e\b\u0002\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00030\u000f\u0012\u000e\b\u0002\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0012\u0010\u000e\u001a\u00020\u00032\b\u0010'\u001a\u0004\u0018\u00010(H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0016R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\"\u0010\b\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\n0\u00060\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\"\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\t8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001e\u0010\u001bR\"\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\t8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u001f\u0010\u001d\u001a\u0004\b \u0010\u001bR\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00030\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u001a\u0010%\u001a\b\u0012\u0004\u0012\u00020\f0\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010\u001b\u00a8\u0006)"}, d2={"Lcom/typewritermc/quest/entries/audience/CompletableObjective;", "Lcom/typewritermc/quest/ObjectiveEntry;", "id", "", "name", "quest", "Lcom/typewritermc/core/entries/Ref;", "Lcom/typewritermc/quest/QuestEntry;", "children", "", "Lcom/typewritermc/engine/paper/entry/entries/AudienceEntry;", "showCriteria", "Lcom/typewritermc/engine/paper/entry/Criteria;", "completedCriteria", "display", "Lcom/typewritermc/engine/paper/entry/entries/Var;", "priorityOverride", "Ljava/util/Optional;", "", "<init>", "(Ljava/lang/String;Ljava/lang/String;Lcom/typewritermc/core/entries/Ref;Ljava/util/List;Ljava/util/List;Ljava/util/List;Lcom/typewritermc/engine/paper/entry/entries/Var;Ljava/util/Optional;)V", "getId", "()Ljava/lang/String;", "getName", "getQuest", "()Lcom/typewritermc/core/entries/Ref;", "getChildren", "()Ljava/util/List;", "getShowCriteria$annotations", "()V", "getShowCriteria", "getCompletedCriteria$annotations", "getCompletedCriteria", "getDisplay", "()Lcom/typewritermc/engine/paper/entry/entries/Var;", "getPriorityOverride", "()Ljava/util/Optional;", "criteria", "getCriteria", "player", "Lorg/bukkit/entity/Player;", "QuestExtension"})
@SourceDebugExtension(value={"SMAP\nCompletableObjective.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompletableObjective.kt\ncom/typewritermc/quest/entries/audience/CompletableObjective\n+ 2 EntryReference.kt\ncom/typewritermc/core/entries/EntryReferenceKt\n*L\n1#1,68:1\n6#2:69\n*S KotlinDebug\n*F\n+ 1 CompletableObjective.kt\ncom/typewritermc/quest/entries/audience/CompletableObjective\n*L\n48#1:69\n*E\n"})
public final class CompletableObjective
implements ObjectiveEntry {
    @NotNull
    private final String id;
    @NotNull
    private final String name;
    @NotNull
    private final Ref<QuestEntry> quest;
    @NotNull
    private final List<Ref<? extends AudienceEntry>> children;
    @NotNull
    private final List<Criteria> showCriteria;
    @NotNull
    private final List<Criteria> completedCriteria;
    @NotNull
    private final Var<String> display;
    @NotNull
    private final Optional<Integer> priorityOverride;

    public CompletableObjective(@NotNull String id, @NotNull String name, @NotNull Ref<QuestEntry> quest, @NotNull List<? extends Ref<? extends AudienceEntry>> children, @NotNull List<Criteria> showCriteria, @NotNull List<Criteria> completedCriteria, @NotNull Var<String> display2, @NotNull Optional<Integer> priorityOverride) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(quest, (String)"quest");
        Intrinsics.checkNotNullParameter(children, (String)"children");
        Intrinsics.checkNotNullParameter(showCriteria, (String)"showCriteria");
        Intrinsics.checkNotNullParameter(completedCriteria, (String)"completedCriteria");
        Intrinsics.checkNotNullParameter(display2, (String)"display");
        Intrinsics.checkNotNullParameter(priorityOverride, (String)"priorityOverride");
        this.id = id;
        this.name = name;
        this.quest = quest;
        this.children = children;
        this.showCriteria = showCriteria;
        this.completedCriteria = completedCriteria;
        this.display = display2;
        this.priorityOverride = priorityOverride;
    }

    public /* synthetic */ CompletableObjective(String string, String string2, Ref ref, List list, List list2, List list3, Var var, Optional optional, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "";
        }
        if ((n & 2) != 0) {
            string2 = "";
        }
        if ((n & 4) != 0) {
            boolean $i$f$emptyRef = false;
            ref = new Ref("", Reflection.getOrCreateKotlinClass(QuestEntry.class), null, 4, null);
        }
        if ((n & 8) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 0x10) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        if ((n & 0x20) != 0) {
            list3 = CollectionsKt.emptyList();
        }
        if ((n & 0x40) != 0) {
            var = (Var)new ConstVar((Object)"");
        }
        if ((n & 0x80) != 0) {
            Optional<Integer> optional2 = Optional.empty();
            Intrinsics.checkNotNullExpressionValue(optional2, (String)"empty(...)");
            optional = optional2;
        }
        this(string, string2, (Ref<QuestEntry>)ref, list, list2, list3, (Var<String>)var, optional);
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public Ref<QuestEntry> getQuest() {
        return this.quest;
    }

    @NotNull
    public List<Ref<? extends AudienceEntry>> getChildren() {
        return this.children;
    }

    @NotNull
    public final List<Criteria> getShowCriteria() {
        return this.showCriteria;
    }

    @Help(text="The criteria need to be met for the objective to be able to be shown.")
    public static /* synthetic */ void getShowCriteria$annotations() {
    }

    @NotNull
    public final List<Criteria> getCompletedCriteria() {
        return this.completedCriteria;
    }

    @Help(text="The criteria to display the objective as completed.")
    public static /* synthetic */ void getCompletedCriteria$annotations() {
    }

    @Override
    @NotNull
    public Var<String> getDisplay() {
        return this.display;
    }

    @NotNull
    public Optional<Integer> getPriorityOverride() {
        return this.priorityOverride;
    }

    @Override
    @NotNull
    public List<Criteria> getCriteria() {
        return this.showCriteria;
    }

    @Override
    @NotNull
    public String display(@Nullable Player player) {
        String text;
        String string = player == null ? QuestEntryKt.getInactiveObjectiveDisplay() : (text = BaseEntryKt.matches$default((Iterable)this.completedCriteria, (Player)player, null, (int)2, null) ? CompletableObjectiveKt.access$getCompletedObjectiveDisplay() : (BaseEntryKt.matches$default((Iterable)this.showCriteria, (Player)player, null, (int)2, null) ? QuestEntryKt.getShowingObjectiveDisplay() : QuestEntryKt.getInactiveObjectiveDisplay()));
        String string2 = (String)VariableEntryKt.get$default(this.getDisplay(), (Player)player, null, (int)2, null);
        if (string2 == null) {
            string2 = "";
        }
        return PlaceholderExpansionKt.parsePlaceholders((String)MiniMessagesKt.replaceTagPlaceholders((String)text, (String)"display", (String)string2), (Player)player);
    }

    @Override
    @Nullable
    public Object display(@NotNull Continuation<? super AudienceFilter> $completion) {
        return ObjectiveEntry.super.display($completion);
    }

    @Override
    @NotNull
    public PlaceholderParser parser() {
        return ObjectiveEntry.super.parser();
    }

    public CompletableObjective() {
        this(null, null, null, null, null, null, null, null, 255, null);
    }
}

