/*
 * Decompiled with CFR 0.152.
 */
package com.extollit.collect;

import java.text.MessageFormat;

public class IntList {
    private static final int GROW = 10;
    private int[] array;
    private int size;

    public IntList() {
        this(10);
    }

    public IntList(int reserved) {
        this(new int[reserved]);
    }

    public IntList(int[] array) {
        this.array = array;
        this.size = array.length;
    }

    private void growBy(int grow) {
        int[] newArray = new int[this.array.length + grow];
        System.arraycopy(this.array, 0, newArray, 0, this.size);
        this.array = newArray;
    }

    public void insert(int value, int i) {
        if (this.size >= this.array.length) {
            this.growBy(10);
        }
        System.arraycopy(this.array, i, this.array, i + 1, this.size++);
        this.array[i] = value;
    }

    public int at(int i, int value) {
        this.boundsCheck(i);
        int value0 = this.array[i];
        this.array[i] = value;
        return value0;
    }

    public void add(int i) {
        if (this.size >= this.array.length) {
            this.growBy(10);
        }
        this.array[this.size++] = i;
    }

    public int removeAt(int i) {
        this.boundsCheck(i);
        int result = this.array[i];
        System.arraycopy(this.array, i + 1, this.array, i, this.size-- - (i + 1));
        return result;
    }

    private void boundsCheck(int i) {
        if (i < 0 || i >= this.size) {
            throw new IndexOutOfBoundsException(MessageFormat.format("{0} is out of bounds, size is {1}", i, this.size));
        }
    }

    public final int size() {
        return this.size;
    }

    public final int at(int i) {
        this.boundsCheck(i);
        return this.array[i];
    }

    public void clear() {
        this.size = 0;
    }

    public boolean empty() {
        return this.size == 0;
    }

    public void remove(int data) {
        for (int c = 0; c < this.size; ++c) {
            if (this.array[c] != data) continue;
            this.removeAt(c);
            break;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        int size = this.size;
        sb.append(size);
        sb.append(" ~ ");
        sb.append('[');
        for (int c = 0; c < size; ++c) {
            sb.append(this.at(c));
            sb.append(", ");
        }
        if (size > 0) {
            sb.delete(sb.length() - 2, sb.length());
        }
        sb.append(']');
        return sb.toString();
    }
}

