/*
 * Decompiled with CFR 0.152.
 */
package com.extollit.collect;

import com.extollit.collect.IOption;
import com.extollit.misc.Either;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

class LazyOption<T>
extends AbstractCollection<T>
implements IOption<T> {
    private Either<T, Iterator<T>> object;

    public LazyOption(Iterator<T> iterator) {
        this.object = Either.right(iterator);
    }

    @Override
    public final T get() {
        if (this.object != null && this.object.right != null) {
            this.object = ((Iterator)this.object.right).hasNext() ? Either.left(((Iterator)this.object.right).next()) : Either.left(null);
        }
        return this.object == null ? null : (T)this.object.left;
    }

    @Override
    public final int size() {
        return this.isEmpty() ? 0 : 1;
    }

    @Override
    public final boolean isEmpty() {
        return this.get() == null;
    }

    @Override
    public boolean contains(Object o) {
        return !this.isEmpty() && this.get().equals(o);
    }

    @Override
    public final IOption<T> or(IOption<T> other) {
        return this.isEmpty() ? other : this;
    }

    @Override
    public Iterator<T> iterator() {
        return new OptionIterator();
    }

    @Override
    public Object[] toArray() {
        Object[] objectArray;
        if (this.isEmpty()) {
            objectArray = new Object[]{};
        } else {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = this.get();
        }
        return objectArray;
    }

    @Override
    public boolean add(T value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        if (this.isEmpty()) {
            return c.isEmpty();
        }
        if (c.size() == 1) {
            return c.iterator().next().equals(this.get());
        }
        return false;
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IOption option = (IOption)o;
        return !this.isEmpty() && !option.isEmpty() ? this.get().equals(option.get()) : option.isEmpty() && this.isEmpty();
    }

    @Override
    public int hashCode() {
        return 0;
    }

    private class OptionIterator
    implements Iterator<T> {
        private T element;
        private boolean terminated;

        private OptionIterator() {
        }

        @Override
        public boolean hasNext() {
            if (!this.terminated) {
                this.element = LazyOption.this.get();
            }
            return this.element != null && !this.terminated;
        }

        @Override
        public T next() {
            Object current = this.element;
            if (current == null) {
                throw new NoSuchElementException();
            }
            this.terminated = true;
            return current;
        }

        @Override
        public void remove() {
            if (LazyOption.this.isEmpty()) {
                throw new NoSuchElementException();
            }
            LazyOption.this.clear();
        }
    }
}

