/*
 * Decompiled with CFR 0.152.
 */
package com.extollit.collect.cache;

import com.extollit.collect.cache.AbstractPurgeThread;
import java.lang.ref.Reference;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.NoSuchElementException;

abstract class AbstractReferenceIterable<V, R extends Reference<V>>
implements Iterable<V> {
    private static final Purge PURGE_THREAD = new Purge();
    private final LinkedList<R> backing = new LinkedList();

    public AbstractReferenceIterable() {
        this(Collections.emptyList());
    }

    public AbstractReferenceIterable(Collection<V> init) {
        for (V value : init) {
            this.add(value);
        }
        PURGE_THREAD.register(this);
    }

    private synchronized int cull(int offset, int batch) {
        LinkedList<R> backing = this.backing;
        Iterator i = backing.iterator();
        int size = backing.size();
        if (size > 0) {
            offset %= size;
        }
        int fin = offset;
        while (offset-- > 0) {
            i.next();
        }
        while (i.hasNext() && batch-- > 0) {
            Reference ref = (Reference)i.next();
            if (ref.get() == null) {
                i.remove();
            }
            ++fin;
        }
        return batch > 0 ? 0 : fin;
    }

    @Override
    public final Iterator<V> iterator() {
        if (this.backing.isEmpty()) {
            return Collections.emptyIterator();
        }
        return new Iter();
    }

    public final void add(V value) {
        this.backing.add(this.reference(value));
    }

    protected abstract R reference(V var1);

    static {
        PURGE_THREAD.start();
    }

    private final class Iter
    implements Iterator<V> {
        private final ListIterator<R> i;
        private V current;

        private Iter() {
            this.i = AbstractReferenceIterable.this.backing.listIterator();
        }

        protected V findNext() {
            ListIterator i = this.i;
            while (i.hasNext()) {
                Object value = ((Reference)i.next()).get();
                if (value != null) {
                    return value;
                }
                i.remove();
            }
            return null;
        }

        @Override
        public final boolean hasNext() {
            if (this.current == null) {
                this.current = this.findNext();
            }
            return this.current != null;
        }

        @Override
        public V next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException(MessageFormat.format("No more elements exist in this iterator {0}", this));
            }
            Object result = this.current;
            this.current = this.findNext();
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static final class Purge
    extends AbstractPurgeThread<AbstractReferenceIterable<?, ?>> {
        public Purge() {
            super("extollIT Iterable - Purge");
        }

        @Override
        protected int cull(int offset, AbstractReferenceIterable<?, ?> iterable) {
            return ((AbstractReferenceIterable)iterable).cull(offset, 100);
        }
    }
}

