/*
 * Decompiled with CFR 0.152.
 */
package com.extollit.gaming.ai.path;

import com.extollit.gaming.ai.path.AbstractNodeCalculator;
import com.extollit.gaming.ai.path.IConfigModel;
import com.extollit.gaming.ai.path.PassibilityHelpers;
import com.extollit.gaming.ai.path.model.Coords;
import com.extollit.gaming.ai.path.model.Element;
import com.extollit.gaming.ai.path.model.FlagSampler;
import com.extollit.gaming.ai.path.model.IInstanceSpace;
import com.extollit.gaming.ai.path.model.IPathingEntity;
import com.extollit.gaming.ai.path.model.Logic;
import com.extollit.gaming.ai.path.model.Node;
import com.extollit.gaming.ai.path.model.Passibility;

class GroundNodeCalculator
extends AbstractNodeCalculator {
    private static int MAX_SAFE_FALL_DISTANCE = 4;
    private static int MAX_SURVIVE_FALL_DISTANCE = 20;
    private static int MAX_FALL_SEARCH = 1024;
    private static int CESA_LIMIT = 16;

    public GroundNodeCalculator(IInstanceSpace instanceSpace) {
        super(instanceSpace);
    }

    public static void configureFrom(IConfigModel configModel) {
        MAX_SAFE_FALL_DISTANCE = configModel.safeFallDistance();
        MAX_SURVIVE_FALL_DISTANCE = configModel.surviveFallDistance();
        CESA_LIMIT = configModel.cesaLimit();
    }

    @Override
    public Node passibleNodeNear(int x0, int y0, int z0, Coords origin, FlagSampler flagSampler) {
        int dz;
        int dy;
        int dx;
        IPathingEntity.Capabilities capabilities = this.capabilities;
        if (origin != null) {
            dx = x0 - origin.x;
            dy = y0 - origin.y;
            dz = z0 - origin.z;
        } else {
            dz = 0;
            dy = 0;
            dx = 0;
        }
        boolean hasOrigin = dx != 0 || dy != 0 || dz != 0;
        boolean climbsLadders = this.capabilities.climber();
        Passibility passibility = Passibility.passible;
        int minY = Integer.MIN_VALUE;
        float minPartY = 0.0f;
        int r = this.discreteSize / 2;
        int xN = x0 + this.discreteSize - r;
        for (int x = x0 - r; x < xN; ++x) {
            int zN = z0 + this.discreteSize - r;
            for (int z = z0 - r; z < zN; ++z) {
                int jN;
                int y = y0;
                float partY0 = this.topOffsetAt(flagSampler, x - dx, y - dy - 1, z - dz);
                byte flags = flagSampler.flagsAt(x, y, z);
                boolean impedesMovement = PassibilityHelpers.impedesMovement(flags, capabilities);
                if (impedesMovement) {
                    float partialDisparity = partY0 - this.topOffsetAt(flags, x, y++, z);
                    flags = flagSampler.flagsAt(x, y, z);
                    if (partialDisparity < 0.0f || PassibilityHelpers.impedesMovement(flags, capabilities)) {
                        if (!hasOrigin) {
                            return new Node(x0, y0, z0, Passibility.impassible, flagSampler.volatility() > 0);
                        }
                        if (dx * dx + dz * dz <= 1) {
                            y -= dy + 1;
                            do {
                                flags = flagSampler.flagsAt(x - dx, y++, z - dz);
                            } while (climbsLadders && Logic.climbable(flags));
                        }
                        if (PassibilityHelpers.impedesMovement(flags = flagSampler.flagsAt(x, --y, z), capabilities) && (PassibilityHelpers.impedesMovement(flags = flagSampler.flagsAt(x, ++y, z), capabilities) || partY0 < 0.0f)) {
                            return new Node(x0, y0, z0, Passibility.impassible, flagSampler.volatility() > 0);
                        }
                    }
                }
                float partY = this.topOffsetAt(flagSampler, x, y - 1, z);
                int ys = y;
                passibility = this.verticalClearanceAt(flagSampler, this.tall, flags, passibility, dy, x, ys, z, Math.min(partY, partY0));
                boolean swimable = false;
                boolean condition = !impedesMovement || GroundNodeCalculator.unstable(flags);
                int n = jN = origin == null ? MAX_FALL_SEARCH : MAX_SURVIVE_FALL_DISTANCE;
                for (int j = 0; condition && !(swimable = this.swimable(flags)) && j <= jN; ++j) {
                    flags = flagSampler.flagsAt(x, --y, z);
                    condition = GroundNodeCalculator.unstable(flags);
                }
                if (swimable) {
                    byte flags0;
                    int cesaLimit = y + CESA_LIMIT;
                    byte flags00 = flags;
                    do {
                        flags0 = flags;
                    } while (this.swimable(flags = flagSampler.flagsAt(x, ++y, z)) && GroundNodeCalculator.unstable(flags) && y < cesaLimit);
                    if (y >= cesaLimit) {
                        y -= CESA_LIMIT + 1;
                        flags = flags00;
                    } else {
                        flags = flags0;
                    }
                }
                int n2 = --y;
                partY = this.topOffsetAt(flags, x, n2, z);
                passibility = this.verticalClearanceAt(flagSampler, ys - ++y, flagSampler.flagsAt(x, y, z), passibility, dy, x, y, z, Math.min(partY, partY0));
                if (y > minY) {
                    minY = y;
                    minPartY = partY;
                } else if (y == minY && partY > minPartY) {
                    minPartY = partY;
                }
                passibility = passibility.between(PassibilityHelpers.passibilityFrom(flagSampler.flagsAt(x, y, z), capabilities));
                if (!passibility.impassible(capabilities)) continue;
                return new Node(x0, y0, z0, Passibility.impassible, flagSampler.volatility() > 0);
            }
        }
        if (hasOrigin && !passibility.impassible(capabilities)) {
            passibility = this.originHeadClearance(flagSampler, passibility, origin, minY, minPartY);
        }
        if (origin != null) {
            passibility = this.fallingSafety(passibility, y0, minY);
        }
        if (passibility.impassible(capabilities)) {
            passibility = Passibility.impassible;
        }
        Node point = new Node(x0, minY + Math.round(minPartY), z0);
        point.passibility(passibility);
        point.volatile_(flagSampler.volatility() > 0);
        return point;
    }

    @Override
    public boolean omnidirectional() {
        return false;
    }

    private Passibility fallingSafety(Passibility passibility, int y0, int minY) {
        int dy = y0 - minY;
        if (dy > 1) {
            passibility = passibility.between(dy > MAX_SAFE_FALL_DISTANCE ? Passibility.dangerous : Passibility.risky);
        }
        return passibility;
    }

    private boolean swimable(byte flags) {
        return this.capabilities.swimmer() && GroundNodeCalculator.swimmingRequiredFor(flags) && (Element.water.in(flags) || this.capabilities.fireResistant());
    }

    private static boolean unstable(byte flags) {
        return !Element.earth.in(flags) || Logic.ladder.in(flags);
    }
}

