/*
 * Decompiled with CFR 0.152.
 */
package com.extollit.gaming.ai.path.model;

import com.extollit.gaming.ai.path.model.ColumnarOcclusionFieldList;
import com.extollit.gaming.ai.path.model.Element;
import com.extollit.gaming.ai.path.model.IBlockDescription;
import com.extollit.gaming.ai.path.model.IColumnarSpace;
import com.extollit.gaming.ai.path.model.IInstanceSpace;
import com.extollit.gaming.ai.path.model.IOcclusionProvider;
import com.extollit.gaming.ai.path.model.Logic;

public class OcclusionField
implements IOcclusionProvider {
    private static final byte ELEMENT_LENGTH_SHL = 2;
    private static final byte ELEMENT_LENGTH = 4;
    private static final byte WORD_LENGTH = 64;
    private static final byte ELEMENTS_PER_WORD = 16;
    private static final byte WORD_LAST_OFFSET = 15;
    private static final byte COORDINATE_TO_INDEX_SHR = 4;
    private static final byte DIMENSION_ORDER = 4;
    public static final int DIMENSION_SIZE = 16;
    static final int DIMENSION_MASK = 15;
    static final int DIMENSION_EXTENT = 15;
    private static final int DIMENSION_SQUARE_SIZE = 256;
    private static final int LAST_INDEX = 255;
    private static final long ELEMENT_MASK = 15L;
    private static final short FULLY_AREA_INIT = 1023;
    private long[] words;
    private byte singleton;
    private short areaInit;

    public boolean areaInitFull() {
        return this.areaInit == 1023;
    }

    public boolean areaInitAt(AreaInit direction) {
        return direction.in(this.areaInit);
    }

    public static boolean fuzzyOpenIn(byte element) {
        return Element.air.in(element) || Element.earth.in(element) && Logic.fuzzy.in(element);
    }

    public void loadFrom(IColumnarSpace columnarSpace, int cx, int cy, int cz) {
        int yNi;
        this.singleton = 0;
        this.words = new long[256];
        boolean compress = true;
        byte lastFlags = this.singleton;
        int x0 = cx << 4;
        int y0 = cy << 4;
        int yN = y0 + 16;
        int z0 = cz << 4;
        long[] words = this.words;
        int i = 255;
        for (int y = yNi = yN - 1; y >= y0; --y) {
            for (int z = 15; z >= 0; --z) {
                for (int x = 0; x >= 0; x -= 16) {
                    long word = 0L;
                    for (int b = 15; b >= 0; --b) {
                        int xx = x + b;
                        IBlockDescription blockDescription = columnarSpace.blockAt(xx, y, z);
                        byte flags = this.flagsFor(columnarSpace, x0 + xx, y, z0 + z, blockDescription);
                        compress &= lastFlags == flags || i == 255 && b == 15;
                        lastFlags = flags;
                        word <<= 4;
                        word |= (long)flags;
                        if (!blockDescription.isFenceLike() || y >= yNi) continue;
                        int indexUp = i + 16;
                        words[indexUp] = this.modifyWord(words[indexUp], b, flags);
                    }
                    words[i--] = word;
                }
            }
        }
        if (compress) {
            this.words = null;
            this.singleton = lastFlags;
        } else {
            this.areaInit();
        }
    }

    private boolean fenceOrDoorLike(byte flags) {
        return Element.earth.in(flags) && Logic.fuzzy.in(flags) || Logic.doorway.in(flags);
    }

    private void decompress() {
        long word = this.singletonWord();
        this.words = new long[256];
        long[] words = this.words;
        for (int i = 0; i < words.length; ++i) {
            words[i] = word;
        }
        this.singleton = 0;
    }

    private long singletonWord() {
        byte singleton = this.singleton;
        long word = 0L;
        for (int b = 16; b > 0; --b) {
            word <<= 4;
            word |= (long)singleton;
        }
        return word;
    }

    private void areaInit() {
        long[] words = this.words;
        if (words == null) {
            return;
        }
        int index = 1;
        for (int y = 0; y < 16; ++y) {
            for (int z = 1; z < 15; ++z) {
                for (int x = 0; x < 16; x += 16) {
                    long word = words[index];
                    long northWord = words[index - 1];
                    long southWord = words[index + 1];
                    int bN = 16 - (x + 16 >= 16 ? 1 : 0);
                    for (int b = x == 0 ? 1 : 0; b < bN; ++b) {
                        long westWord = words[index - (b - 1 >> 4)];
                        long eastWord = words[index + (b + 1 >> 4)];
                        word = this.areaWordFor(word, b, northWord, eastWord, southWord, westWord);
                    }
                    words[index++] = word;
                }
            }
            index += 2;
        }
    }

    void areaInitNorth(OcclusionField other) {
        this.areaInitZPlane(other, false);
        this.areaInit = AreaInit.north.to(this.areaInit);
    }

    void areaInitSouth(OcclusionField other) {
        this.areaInitZPlane(other, true);
        this.areaInit = AreaInit.south.to(this.areaInit);
    }

    void areaInitWest(OcclusionField other) {
        this.areaInitXPlane(other, false);
        this.areaInit = AreaInit.west.to(this.areaInit);
    }

    void areaInitEast(OcclusionField other) {
        this.areaInitXPlane(other, true);
        this.areaInit = AreaInit.east.to(this.areaInit);
    }

    void areaInitNorthEast(OcclusionField horizontal, OcclusionField depth) {
        this.areaInitVerticalEdge(horizontal, depth, true, false);
        this.areaInit = AreaInit.northEast.to(this.areaInit);
    }

    void areaInitSouthEast(OcclusionField horizontal, OcclusionField depth) {
        this.areaInitVerticalEdge(horizontal, depth, true, true);
        this.areaInit = AreaInit.southEast.to(this.areaInit);
    }

    void areaInitNorthWest(OcclusionField horizontal, OcclusionField depth) {
        this.areaInitVerticalEdge(horizontal, depth, false, false);
        this.areaInit = AreaInit.northWest.to(this.areaInit);
    }

    void areaInitSouthWest(OcclusionField horizontal, OcclusionField depth) {
        this.areaInitVerticalEdge(horizontal, depth, false, true);
        this.areaInit = AreaInit.southWest.to(this.areaInit);
    }

    void areaInitUp(IColumnarSpace columnarSpace, int cy, OcclusionField other) {
        this.resolveTruncatedFencesAndDoors(columnarSpace, cy, other, true);
        this.areaInit = AreaInit.up.to(this.areaInit);
    }

    void areaInitDown(IColumnarSpace columnarSpace, int cy, OcclusionField other) {
        this.resolveTruncatedFencesAndDoors(columnarSpace, cy, other, false);
        this.areaInit = AreaInit.down.to(this.areaInit);
    }

    private void resolveTruncatedFencesAndDoors(IColumnarSpace columnarSpace, int cy, OcclusionField other, boolean end) {
        OcclusionField object;
        OcclusionField subject;
        if (other == null) {
            return;
        }
        int i = 240;
        if (end) {
            subject = this;
            object = other;
            ++cy;
        } else {
            subject = other;
            object = this;
        }
        int y = (cy << 4) - 1;
        long[] words = subject.words;
        byte singleton = subject.singleton;
        long word = 0L;
        for (int z = 0; z < 16; ++z) {
            for (int x = 0; x < 16; x += 16) {
                if (words != null) {
                    word = words[i++];
                }
                for (int b = 0; b < 16; ++b) {
                    int xx = x + b;
                    byte flags = words != null ? (byte)(word & 0xFL) : singleton;
                    boolean fenceLike = Element.earth.in(flags) && Logic.fuzzy.in(flags);
                    boolean doorLike = Logic.doorway.in(flags);
                    if (fenceLike || doorLike) {
                        IBlockDescription block = columnarSpace.blockAt(xx, y, z);
                        if (fenceLike && block.isFenceLike() || doorLike && block.isDoor()) {
                            object.set(xx, 0, z, flags);
                        }
                    }
                    word >>= 4;
                }
            }
        }
    }

    private void areaInitZPlane(OcclusionField neighbor, boolean end) {
        long[] words = this.words;
        int z0 = end ? 15 : 0;
        int disposition = (z0 / 15 << 1) - 1;
        long[] neighborWords = neighbor.words;
        long singletonWord = words == null ? this.singletonWord() : 0L;
        long neighborSingletonWord = neighborWords == null ? neighbor.singletonWord() : 0L;
        int index = z0 * 16 >> 4;
        int northIndex = (16 - z0 - 1) * 16 >> 4;
        for (int y = 0; y < 16; ++y) {
            for (int x = 0; x < 16; x += 16) {
                long southWord;
                long northWord;
                long secondary;
                long word = words == null ? singletonWord : words[index];
                long primary = words == null ? singletonWord : words[index + -disposition * 1];
                long l = secondary = neighborWords == null ? neighborSingletonWord : neighborWords[northIndex];
                if (disposition < 0) {
                    northWord = secondary;
                    southWord = primary;
                } else {
                    northWord = primary;
                    southWord = secondary;
                }
                int bN = 16 - (x + 16 >= 16 ? 1 : 0);
                for (int b = x == 0 ? 1 : 0; b < bN; ++b) {
                    long eastWord;
                    long westWord;
                    if (words == null) {
                        eastWord = westWord = singletonWord;
                    } else {
                        westWord = words[index - (b - 1 >> 4)];
                        eastWord = words[index + (b + 1 >> 4)];
                    }
                    word = this.areaWordFor(word, b, northWord, eastWord, southWord, westWord);
                }
                if (words == null && word != singletonWord) {
                    this.decompress();
                    words = this.words;
                }
                if (words != null) {
                    words[index] = word;
                }
                ++index;
                ++northIndex;
            }
            int di = 15;
            index += 15;
            northIndex += 15;
        }
    }

    private void areaInitXPlane(OcclusionField neighbor, boolean end) {
        long[] words = this.words;
        int x0 = end ? 15 : 0;
        int disposition = (x0 / 15 << 1) - 1;
        int offset = (disposition + 1 >> 1) * 15;
        long[] neighborWords = neighbor.words;
        long singletonWord = words == null ? this.singletonWord() : 0L;
        long neighborSingletonWord = neighborWords == null ? neighbor.singletonWord() : 0L;
        int index = x0 + 16 >> 4;
        int neighborIndex = 16 - x0 - 1 + 16 >> 4;
        for (int y = 0; y < 16; ++y) {
            for (int z = 1; z < 15; ++z) {
                long southWord;
                long northWord;
                long eastWord;
                long westWord;
                long secondary;
                long word = words == null ? singletonWord : words[index];
                long primary = words == null ? singletonWord : words[index];
                long l = secondary = neighborWords == null ? neighborSingletonWord : neighborWords[neighborIndex];
                if (disposition < 0) {
                    westWord = secondary;
                    eastWord = primary;
                } else {
                    westWord = primary;
                    eastWord = secondary;
                }
                if (words == null) {
                    southWord = northWord = singletonWord;
                } else {
                    northWord = words[index - 1];
                    southWord = words[index + 1];
                }
                word = this.areaWordFor(word, offset, northWord, eastWord, southWord, westWord);
                if (words == null && word != singletonWord) {
                    this.decompress();
                    words = this.words;
                }
                if (words != null) {
                    words[index] = word;
                }
                boolean di = true;
                ++index;
                ++neighborIndex;
            }
            int di = 2;
            index += 2;
            neighborIndex += 2;
        }
    }

    private void areaInitVerticalEdge(OcclusionField horizNeighbor, OcclusionField depthNeighbor, boolean horizEnd, boolean depthEnd) {
        long[] words = this.words;
        int x0 = horizEnd ? 15 : 0;
        int z0 = depthEnd ? 15 : 0;
        int xd = (x0 / 15 << 1) - 1;
        int zd = (z0 / 15 << 1) - 1;
        int offset = (xd + 1 >> 1) * 15;
        long[] horizNeighborWords = horizNeighbor.words;
        long[] depthNeighborWords = depthNeighbor.words;
        long singletonWord = words == null ? this.singletonWord() : 0L;
        long horizNeighborSingletonWord = horizNeighborWords == null ? horizNeighbor.singletonWord() : 0L;
        long depthNeighborSingletonWord = depthNeighborWords == null ? depthNeighbor.singletonWord() : 0L;
        int index = z0 * 16 + x0 >> 4;
        int horizNeighborIndex = z0 * 16 + (16 - x0 - 1) >> 4;
        int depthNeighborIndex = (16 - z0 - 1) * 16 + x0 >> 4;
        for (int y = 0; y < 16; ++y) {
            long southWord;
            long northWord;
            long eastWord;
            long westWord;
            long depthSecondary;
            long word = words == null ? singletonWord : words[index];
            long horizSecondary = horizNeighborWords == null ? horizNeighborSingletonWord : horizNeighborWords[horizNeighborIndex];
            long l = depthSecondary = depthNeighborWords == null ? depthNeighborSingletonWord : depthNeighborWords[depthNeighborIndex];
            if (xd < 0) {
                westWord = horizSecondary;
                eastWord = word;
            } else {
                westWord = word;
                eastWord = horizSecondary;
            }
            if (zd < 0) {
                northWord = depthSecondary;
                southWord = word;
            } else {
                northWord = word;
                southWord = depthSecondary;
            }
            word = this.areaWordFor(word, offset, northWord, eastWord, southWord, westWord);
            if (words == null && word != singletonWord) {
                this.decompress();
                words = this.words;
            }
            if (words != null) {
                words[index] = word;
            }
            int di = 16;
            index += 16;
            horizNeighborIndex += 16;
            depthNeighborIndex += 16;
        }
    }

    private long areaWordFor(long centerWord, int offset, long northWord, long eastWord, long southWord, long westWord) {
        byte centerFlags = this.elementAt(centerWord, offset);
        byte northFlags = this.elementAt(northWord, offset);
        byte southFlags = this.elementAt(southWord, offset);
        byte westFlags = this.westFlags(offset, westWord);
        byte eastFlags = this.eastFlags(offset, eastWord);
        centerFlags = this.areaFlagsFor(centerFlags, northFlags, eastFlags, southFlags, westFlags);
        centerWord = this.modifyWord(centerWord, offset, centerFlags);
        return centerWord;
    }

    private long fenceAndDoorAreaWordFor(IColumnarSpace columnarSpace, int dx, int y, int dz, long centerWord, int offset, long upWord, long downWord, boolean handlingFenceTops) {
        byte centerFlags = this.elementAt(centerWord, offset);
        byte upFlags = this.elementAt(upWord, offset);
        byte downFlags = this.elementAt(downWord, offset);
        centerFlags = this.fenceAndDoorAreaFlagsFor(columnarSpace, dx, y, dz, centerFlags, upFlags, downFlags, handlingFenceTops);
        centerWord = this.modifyWord(centerWord, offset, centerFlags);
        return centerWord;
    }

    private byte eastFlags(int offset, long eastWord) {
        return this.elementAt(eastWord, (offset + 1) % 16);
    }

    private byte westFlags(int offset, long westWord) {
        return this.elementAt(westWord, (offset + 16 - 1) % 16);
    }

    private byte areaFlagsFor(byte centerFlags, byte northFlags, byte eastFlags, byte southFlags, byte westFlags) {
        Element northElem = Element.of(northFlags);
        Element southElem = Element.of(southFlags);
        Element westElem = Element.of(westFlags);
        Element eastElem = Element.of(eastFlags);
        Element centerElem = Element.of(centerFlags);
        if (Logic.ladder.in(centerFlags) && (northElem == Element.earth || eastElem == Element.earth || southElem == Element.earth || westElem == Element.earth)) {
            centerFlags = Element.earth.to(centerFlags);
        } else if (centerElem == Element.air && Logic.nothing.in(centerFlags) && (this.fuzziable(centerElem, northFlags) || this.fuzziable(centerElem, eastFlags) || this.fuzziable(centerElem, southFlags) || this.fuzziable(centerElem, westFlags))) {
            centerFlags = Logic.fuzzy.to(centerFlags);
        }
        return centerFlags;
    }

    private byte fenceAndDoorAreaFlagsFor(IColumnarSpace columnarSpace, int dx, int y, int dz, byte centerFlags, byte upFlags, byte downFlags, boolean handlingFenceTops) {
        boolean downFenceOrDoorLike = this.fenceOrDoorLike(downFlags);
        boolean centerFenceOrDoorLike = this.fenceOrDoorLike(centerFlags);
        IBlockDescription centerBlock = columnarSpace.blockAt(dx, y, dz);
        IBlockDescription downBlock = columnarSpace.blockAt(dx, y - 1, dz);
        if (!centerBlock.isImpeding() ? downFenceOrDoorLike && !centerFenceOrDoorLike && downBlock.isFenceLike() || !handlingFenceTops && !downFenceOrDoorLike && centerFenceOrDoorLike && !centerBlock.isFenceLike() || downFenceOrDoorLike && centerFenceOrDoorLike && (Logic.doorway.in(downFlags) && downBlock.isFenceLike() && downBlock.isDoor() && (Element.doorClosedLike(downFlags) || !centerBlock.isDoor() || !centerBlock.isFenceLike()) || Logic.doorway.in(centerFlags) && (!downBlock.isFenceLike() || !downBlock.isDoor())) : downFenceOrDoorLike && centerFenceOrDoorLike && Logic.doorway.in(downFlags) && Logic.doorway.in(centerFlags) && downBlock.isDoor() && centerBlock.isDoor()) {
            return downFlags;
        }
        return centerFlags;
    }

    private boolean fuzziable(Element centerElem, byte otherFlags) {
        Element otherElement = Element.of(otherFlags);
        return centerElem != otherElement && (otherElement != Element.earth || !Logic.fuzzy.in(otherFlags));
    }

    private long modifyWord(long word, int offset, byte flags) {
        int shl = offset << 2;
        return word & (15L << shl ^ 0xFFFFFFFFFFFFFFFFL) | (long)flags << shl;
    }

    public void set(IColumnarSpace columnarSpace, int x, int y, int z, IBlockDescription blockDescription) {
        int dx = x & 0xF;
        int dy = y & 0xF;
        int dz = z & 0xF;
        byte flags = this.flagsFor(columnarSpace, x, y, z, blockDescription);
        if (this.set(dx, dy, dz, flags)) {
            boolean dyb;
            boolean dzb = dz > 0 && dz < 15;
            boolean dxb = dx > 0 && dx < 15;
            boolean bl = dyb = dy > 0 && dy < 15;
            if (dzb && dxb && dyb) {
                this.areaComputeAt(dx, dy, dz);
            } else {
                this.greaterAreaComputeAt(columnarSpace, x, y, z);
            }
            if (dx > 1 && dzb) {
                this.areaComputeAt(dx - 1, dy, dz);
            } else {
                this.greaterAreaComputeAt(columnarSpace, x - 1, y, z);
            }
            if (dx < 14 && dzb) {
                this.areaComputeAt(dx + 1, dy, dz);
            } else {
                this.greaterAreaComputeAt(columnarSpace, x + 1, y, z);
            }
            if (dz > 1 && dxb) {
                this.areaComputeAt(dx, dy, dz - 1);
            } else {
                this.greaterAreaComputeAt(columnarSpace, x, y, z - 1);
            }
            if (dz < 14 && dxb) {
                this.areaComputeAt(dx, dy, dz + 1);
            } else {
                this.greaterAreaComputeAt(columnarSpace, x, y, z + 1);
            }
            if (dy > 0 && dy < 15) {
                this.fencesAndDoorsComputeAt(columnarSpace, dx, y, dz, true);
            } else if (y > 0 && y < 254) {
                this.greaterFencesAndDoorsComputeAt(columnarSpace, x, y, z, true);
            }
            if (dy > 1) {
                this.fencesAndDoorsComputeAt(columnarSpace, dx, y - 1, dz, false);
            } else if (y > 1) {
                this.greaterFencesAndDoorsComputeAt(columnarSpace, x, y - 1, z, false);
            }
            if (dy < 14) {
                this.fencesAndDoorsComputeAt(columnarSpace, dx, y + 1, dz, false);
            } else if (y < 254) {
                this.greaterFencesAndDoorsComputeAt(columnarSpace, x, y + 1, z, false);
            }
        }
    }

    private boolean set(int dx, int dy, int dz, byte flags) {
        if (this.words == null && flags != this.singleton) {
            this.decompress();
        }
        if (this.words != null) {
            int index = this.index(dx, dy, dz);
            long word = this.words[index];
            this.words[index] = this.modifyWord(word, dx % 16, flags);
            return true;
        }
        return false;
    }

    private int index(int dx, int dy, int dz) {
        return dy * 256 + dz * 16 + dx >> 4;
    }

    private void areaComputeAt(int dx, int dy, int dz) {
        long[] words = this.words;
        int offset = dx % 16;
        int index = this.index(dx, dy, dz);
        long northWord = words[this.index(dx, dy, dz - 1)];
        long southWord = words[this.index(dx, dy, dz + 1)];
        long westWord = words[this.index(dx - 1, dy, dz)];
        long eastWord = words[this.index(dx + 1, dy, dz)];
        long centerWord = words[index];
        words[index] = this.areaWordFor(centerWord, offset, northWord, eastWord, southWord, westWord);
    }

    private void fencesAndDoorsComputeAt(IColumnarSpace columnarSpace, int dx, int y, int dz, boolean handlingFenceTops) {
        long[] words = this.words;
        int dy = y & 0xF;
        int offset = dx % 16;
        int index = this.index(dx, dy, dz);
        long downWord = words[this.index(dx, dy - 1, dz)];
        long upWord = words[this.index(dx, dy + 1, dz)];
        long centerWord = words[index];
        words[index] = this.fenceAndDoorAreaWordFor(columnarSpace, dx, y, dz, centerWord, offset, upWord, downWord, handlingFenceTops);
    }

    private void greaterAreaComputeAt(IColumnarSpace columnarSpace, int x, int y, int z) {
        int dx = x & 0xF;
        int dy = y & 0xF;
        int dz = z & 0xF;
        int cx = x >> 4;
        int cy = y >> 4;
        int cz = z >> 4;
        IInstanceSpace instance = columnarSpace.instance();
        OcclusionField center = ColumnarOcclusionFieldList.optOcclusionFieldAt(instance, cx, cy, cz);
        if (center == null) {
            return;
        }
        OcclusionField north = ColumnarOcclusionFieldList.optOcclusionFieldAt(instance, cx, cy, z - 1 >> 4);
        OcclusionField east = ColumnarOcclusionFieldList.optOcclusionFieldAt(instance, x + 1 >> 4, cy, cz);
        OcclusionField south = ColumnarOcclusionFieldList.optOcclusionFieldAt(instance, cx, cy, z + 1 >> 4);
        OcclusionField west = ColumnarOcclusionFieldList.optOcclusionFieldAt(instance, x - 1 >> 4, cy, cz);
        byte centerFlags = center.elementAt(dx, dy, dz);
        byte northFlags = north == null ? (byte)0 : north.elementAt(dx, dy, dz - 1 & 0xF);
        byte southFlags = south == null ? (byte)0 : south.elementAt(dx, dy, dz + 1 & 0xF);
        byte westFlags = west == null ? (byte)0 : west.elementAt(dx - 1 & 0xF, dy, dz);
        byte eastFlags = east == null ? (byte)0 : east.elementAt(dx + 1 & 0xF, dy, dz);
        byte flags = this.areaFlagsFor(centerFlags, northFlags, eastFlags, southFlags, westFlags);
        center.set(dx, dy, dz, flags);
    }

    private void greaterFencesAndDoorsComputeAt(IColumnarSpace columnarSpace, int x, int y, int z, boolean handlingFenceTops) {
        int dx = x & 0xF;
        int dy = y & 0xF;
        int dz = z & 0xF;
        int cx = x >> 4;
        int cy = y >> 4;
        int cz = z >> 4;
        IInstanceSpace instance = columnarSpace.instance();
        OcclusionField center = ColumnarOcclusionFieldList.optOcclusionFieldAt(instance, cx, cy, cz);
        if (center == null) {
            return;
        }
        OcclusionField up = ColumnarOcclusionFieldList.optOcclusionFieldAt(instance, cx, y + 1 >> 4, cz);
        OcclusionField down = ColumnarOcclusionFieldList.optOcclusionFieldAt(instance, cx, y - 1 >> 4, cz);
        byte centerFlags = center.elementAt(dx, dy, dz);
        byte upFlags = up == null ? (byte)0 : up.elementAt(dx, dy + 1 & 0xF, dz);
        byte downFlags = down == null ? (byte)0 : down.elementAt(dx, dy - 1 & 0xF, dz);
        byte flags = this.fenceAndDoorAreaFlagsFor(columnarSpace, dx, y, dz, centerFlags, upFlags, downFlags, handlingFenceTops);
        center.set(dx, dy, dz, flags);
    }

    @Override
    public byte elementAt(int x, int y, int z) {
        byte element;
        if (this.words != null) {
            long word = this.words[this.index(x, y, z)];
            element = this.elementAt(word, x % 16);
        } else {
            element = this.singleton;
        }
        return element;
    }

    private byte elementAt(long word, int offset) {
        byte element = (byte)(word >> (offset << 2));
        element = (byte)((long)element & 0xFL);
        return element;
    }

    @Override
    public String visualizeAt(int dy) {
        return OcclusionField.visualizeAt(this, dy, 0, 0, 16, 16);
    }

    private byte flagsFor(IColumnarSpace columnarSpace, int x, int y, int z, IBlockDescription block) {
        byte flags = 0;
        IInstanceSpace instance = columnarSpace.instance();
        boolean doorway = block.isDoor();
        flags = doorway ? (byte)(flags | (instance.blockObjectAt((int)x, (int)y, (int)z).isImpeding() ? (block.isIntractable() ? Element.fire : Element.earth) : Element.air).mask) : (!block.isImpeding() ? (block.isLiquid() ? (block.isIncinerating() ? (byte)(flags | Element.fire.mask) : (byte)(flags | Element.water.mask)) : (block.isIncinerating() ? (byte)(flags | (Element.fire.mask | Logic.fuzzy.mask)) : (byte)(flags | Element.air.mask))) : (block.isIncinerating() ? (byte)(flags | Element.fire.mask) : (byte)(flags | Element.earth.mask)));
        if (doorway) {
            flags = Logic.doorway.to(flags);
        } else if (block.isClimbable()) {
            flags = Logic.ladder.to(flags);
        } else if (Element.earth.in(flags) && !block.isFullyBounded()) {
            flags = Logic.fuzzy.to(flags);
        }
        return flags;
    }

    static String visualizeAt(IOcclusionProvider provider, int dy, int x0, int z0, int xN, int zN) {
        StringBuilder sb = new StringBuilder();
        for (int z = z0; z < zN; ++z) {
            for (int x = x0; x < xN; ++x) {
                int ch;
                byte flags = provider.elementAt(x, dy, z);
                switch (Element.of(flags)) {
                    case air: {
                        ch = Logic.fuzzy.in(flags) ? 9617 : 32;
                        break;
                    }
                    case earth: {
                        if (Logic.climbable(flags)) {
                            ch = 35;
                            break;
                        }
                        if (Logic.fuzzy.in(flags)) {
                            ch = 9604;
                            break;
                        }
                        ch = 9608;
                        break;
                    }
                    case fire: {
                        ch = 88;
                        break;
                    }
                    case water: {
                        ch = 8779;
                        break;
                    }
                    default: {
                        ch = 63;
                    }
                }
                sb.append((char)ch);
            }
            sb.append(System.lineSeparator());
        }
        return sb.toString();
    }

    public static enum AreaInit {
        north(0, -1),
        south(0, 1),
        west(-1, 0),
        east(1, 0),
        northEast(1, -1),
        northWest(-1, -1),
        southEast(1, 1),
        southWest(-1, 1),
        up(1),
        down(-1);

        public final byte dx;
        public final byte dy;
        public final byte dz;
        public final short mask = (short)(1 << this.ordinal());

        private AreaInit(int dx, int dz) {
            this.dx = (byte)dx;
            this.dy = 0;
            this.dz = (byte)dz;
        }

        private AreaInit(int dy) {
            this.dz = 0;
            this.dx = 0;
            this.dy = (byte)dy;
        }

        public boolean in(short flags) {
            return (flags & this.mask) != 0;
        }

        public short to(short flags) {
            return (short)(flags | this.mask);
        }

        public static AreaInit given(int dx, int dy, int dz) {
            if (dx == -1 && dz == -1) {
                return northWest;
            }
            if (dx == 0 && dz == -1) {
                return north;
            }
            if (dx == 1 && dz == -1) {
                return northEast;
            }
            if (dx == 1 && dz == 0) {
                return east;
            }
            if (dx == 1 && dz == 1) {
                return southEast;
            }
            if (dx == 0 && dz == 1) {
                return south;
            }
            if (dx == -1 && dz == 1) {
                return southWest;
            }
            if (dx == -1 && dz == 0) {
                return west;
            }
            if (dx == 0 && dz == 0) {
                if (dy == -1) {
                    return down;
                }
                if (dy == 1) {
                    return up;
                }
            }
            return null;
        }
    }
}

